#version 150 compatibility
#extension GL_EXT_gpu_shader4: require
uniform sampler2D InPos;
uniform int   StartOffset;
uniform float ParticalSize;
out float out_MatIndex;
out vec3  out_normal;
out vec3  out_vpos;
out vec3  out_diffuse;
out vec3  out_emission;
out vec4  out_hpos;
out vec2  out_texcoord;
float rand(vec2 co, float f)
{
return fract(sin(dot(co.xy ,vec2(12.9898,78.233) * f)) * 43758.5453);
}
void main()
{
out_diffuse  = gl_FrontMaterial.diffuse.rgb * gl_FrontMaterial.diffuse.a ;
out_emission = gl_FrontMaterial.emission.rgb * gl_FrontMaterial.emission.a ;
out_MatIndex = gl_FrontMaterial.ambient.a;
float lightFactor = (0.25 + 0.3 * (rand(vec2(gl_InstanceID), 2.) - .5));
out_diffuse = vec3(lightFactor);
ivec2 MapSize = ivec2(256);
int index = (StartOffset + gl_InstanceID) % (MapSize.x * MapSize.y);
ivec2 ParticalUV = ivec2(index % MapSize.x,
index / MapSize.x);
vec3 pos   = texelFetch(InPos, ParticalUV, 0).xyz;
vec4 vertex = gl_Vertex;
vertex.xyz *= ParticalSize * 5.;
vec4 newVertex = vec4(vertex.xyz, 1.);
newVertex.xyz += pos;
newVertex.xyz *= 0.01;
out_vpos = (gl_ModelViewMatrix * newVertex).xyz;
out_normal = gl_Normal.xyz;
out_normal = normalize(gl_NormalMatrix * out_normal);
out_hpos = gl_Position = gl_ModelViewProjectionMatrix * newVertex;
}