#extension GL_EXT_gpu_shader4: require
uniform float SliderValue;
uniform int   SliderMode;
uniform mat4  ModelMatrix;
varying float out_MatIndex;
varying vec3  out_normal;
varying vec3  out_vpos;
varying vec3  out_diffuse;
varying vec3  out_emission;
varying vec4  out_hpos;
varying vec2  out_texcoord;
void main()
{
out_diffuse  = gl_FrontMaterial.diffuse.rgb * gl_FrontMaterial.diffuse.a ;
out_emission = gl_FrontMaterial.emission.rgb * gl_FrontMaterial.emission.a ;
out_MatIndex = gl_FrontMaterial.ambient.a;
vec3 mPos = gl_Vertex.xyz;
vec3 wPos = (ModelMatrix * vec4(mPos, 1.)).xyz;
if ((SliderMode & 1) > 0) out_diffuse *= sin(clamp((wPos.y - SliderValue) * .2, 0., 3.14))*2.;
if ((SliderMode & 2) > 0) out_diffuse *= (1.0 - sin(clamp((wPos.y - SliderValue) * .3, 0., 3.14)));
if ((SliderMode & 4) > 0) mPos.xz *= (1.0 + 1.5 * sin(clamp((wPos.y - SliderValue) * .4 - 3.14/2., 0., 3.14)));
if ((SliderMode & 8) > 0) mPos *= (1.2 - sin(clamp((wPos.y - SliderValue) * .3, 0., 3.14)));
if ((SliderMode & 16) > 0) out_diffuse *= SliderValue;
if ((SliderMode & 32) > 0) out_diffuse *= sin(clamp((wPos.y - SliderValue) * .4, 0., 3.14))*8.;
out_vpos = (gl_ModelViewMatrix * vec4(mPos, 1.)).xyz;
out_normal = gl_Normal;
out_normal = normalize(gl_NormalMatrix * out_normal);
out_hpos = gl_Position = gl_ModelViewProjectionMatrix * vec4(mPos, gl_Vertex.w);
out_texcoord = gl_MultiTexCoord0.xy;
}