uniform float FocalDepth;
uniform float FocalFactor;
uniform sampler2D Original;
uniform sampler2D ssDepth;
uniform sampler2D BloomMap1;
uniform sampler2D BloomMap2;
uniform sampler2D BloomMap3;
uniform sampler2D BloomMap4;
varying vec2 uv;
void main(void)
{
float depth = -texture2D(ssDepth, uv).z;
if (depth == 0.) depth = FocalDepth;
depth = pow(clamp(depth / FocalDepth, 0., 1.), FocalFactor);
depth *= 5.;
float factor_i0 = depth < 1. ? 1. : (1. - min(1., abs(depth - 1.)));
float factor_i1 = 1. - min(1., abs(depth - 2.));
float factor_i2 = 1. - min(1., abs(depth - 3.));
float factor_i3 = 1. - min(1., abs(depth - 4.));
float factor_i4 = 1. - min(1., abs(depth - 5.));
gl_FragColor = texture2D(Original, uv)  * factor_i0 +
texture2D(BloomMap1, uv) * factor_i1 +
texture2D(BloomMap2, uv) * factor_i2 +
texture2D(BloomMap3, uv) * factor_i3 +
texture2D(BloomMap4, uv) * factor_i4;
}