#define GammaCorrection(color, gamma) pow( color, 1.0 / vec3(gamma))
#define LevelsControlInputRange(color, minInput, maxInput)  min(max(color - vec3(minInput), 0.0) / (vec3(maxInput) - vec3(minInput)), 1.0)
#define LevelsControlInput(color, minInput, gamma, maxInput) GammaCorrection(LevelsControlInputRange(color, minInput, maxInput), gamma)
#define LevelsControlOutputRange(color, minOutput, maxOutput)  mix(vec3(minOutput), vec3(maxOutput), color)
#define LevelsControl(color, minInput, gamma, maxInput, minOutput, maxOutput)   LevelsControlOutputRange(LevelsControlInput(color, minInput, gamma, maxInput), minOutput, maxOutput)
#define ONETHIRD 0.333333
#define TWOTHIRD 0.666666
#define EPSILON  0.000001
varying vec2 uv;
uniform sampler2D sourceTexture;
uniform vec4 baseColor;
uniform float contrast;
uniform float saturation;
uniform float brightness;
uniform float gamma;
uniform float levels_InMin;
uniform float levels_InMax;
uniform float levels_OutMin;
uniform float levels_OutMax;
uniform float hueshift;
uniform float threshold;
uniform int nbColors;
uniform int invertMode;
uniform sampler2D overlayTexture;
uniform float     overlayAlpha;
uniform vec3      overlayXYS;
float HueToRGB(float f1, float f2, float hue)
{
float res;
hue += mix( -float( hue > 1.0 ), 1.0, float(hue < 0.0) );
res = mix( f1, mix( clamp( f1 + (f2 - f1) * ((2.0 / 3.0) - hue) * 6.0, 0.0, 1.0) , mix( f2,  clamp(f1 + (f2 - f1) * 6.0 * hue, 0.0, 1.0), float((6.0 * hue) < 1.0)),  float((2.0 * hue) < 1.0)), float((3.0 * hue) < 2.0) );
return res;
}
vec3 HSV2RGB(vec3 hsl)
{
vec3 rgb;
float f1, f2;
f2 = mix( (hsl.z + hsl.y) - (hsl.y * hsl.z), hsl.z * (1.0 + hsl.y), float(hsl.z < 0.5) );
f1 = 2.0 * hsl.z - f2;
rgb.r = HueToRGB(f1, f2, hsl.x + ONETHIRD);
rgb.g = HueToRGB(f1, f2, hsl.x);
rgb.b = HueToRGB(f1, f2, hsl.x - ONETHIRD);
rgb =  mix( rgb, vec3(hsl.z), float(hsl.y < EPSILON));
return rgb;
}
vec3 RGB2HSV( vec3 color )
{
vec3 hsl = vec3(0.0);
float fmin = min(min(color.r, color.g), color.b);
float fmax = max(max(color.r, color.g), color.b);
float delta = fmax - fmin + EPSILON;
vec3 deltaRGB = ( ( vec3(fmax) - color ) / 6.0  + vec3(delta) / 2.0 ) / delta ;
hsl.z = (fmax + fmin) / 2.0;
hsl.y = delta / ( EPSILON + mix( 2.0 - fmax - fmin, fmax + fmin, float(hsl.z < 0.5)) );
hsl.x = mix( hsl.x, TWOTHIRD + deltaRGB.g - deltaRGB.r, float(color.b == fmax));
hsl.x = mix( hsl.x, ONETHIRD + deltaRGB.r - deltaRGB.b, float(color.g == fmax));
hsl.x = mix( hsl.x, deltaRGB.b - deltaRGB.g,  float(color.r == fmax));
hsl.x += mix( - float( hsl.x > 1.0 ), 1.0, float(hsl.x < 0.0) );
hsl = mix ( hsl, vec3(-1.0, 0.0, hsl.z), float(delta<EPSILON) );
return hsl;
}
void main(void)
{
float alpha = texture2D(sourceTexture, uv).a  * baseColor.a;
vec3 transformedRGB;
transformedRGB = mix(vec3(0.62), texture2D(sourceTexture, uv).rgb, contrast) + brightness;
transformedRGB = LevelsControl(transformedRGB, levels_InMin, gamma, levels_InMax, levels_OutMin, levels_OutMax);
transformedRGB = vec3(float(invertMode==1)) + ( transformedRGB * vec3(1.0 - 2.0 * float(invertMode==1)) );
vec3 transformedHSL = RGB2HSV(transformedRGB);
transformedHSL.z = float(invertMode==2) +  transformedHSL.z * (1.0 - 2.0 * float(invertMode==2) );
transformedHSL.x = transformedHSL.x + hueshift;
transformedHSL.y *= saturation;
transformedHSL = mix( transformedHSL, floor(transformedHSL * vec3(nbColors)) / vec3(nbColors-1),  float( nbColors > 0 ) );
transformedHSL = mix( transformedHSL, vec3(0.0, 0.0, step( transformedHSL.z, threshold )), float(threshold > EPSILON));
transformedRGB = HSV2RGB(transformedHSL);
transformedRGB = transformedRGB * baseColor.rgb;
vec2 overlayUV = (vec2(uv.x, 1. - uv.y) - overlayXYS.xy) / overlayXYS.z;
vec4 overlay   = (overlayUV.x < 0.) || (overlayUV.x > 1.) || (overlayUV.y < 0.) || (overlayUV.y > 1.) ? vec4(0) : texture2D(overlayTexture, overlayUV);
transformedRGB = mix(transformedRGB, overlay.rgb * overlay.a, overlay.a * overlayAlpha);
gl_FragColor =  vec4(transformedRGB, alpha);
}