TRIANGLES   equ 0

Roto28Logic
    lda atten
    bne DoRotate    ;only rotate on outro

    lda measure
    and #1
    beq NoRotate

DoRotate
    lda tempoCount
    bpl DoneRotoSetup

    lda angle
    ;clc
    adc #16
    sta angle
    jmp DoneRotoSetup

NoRotate
    ;well, maybe just a little..
    lda beat
    bne NoRotateForSerious  ;super serious

    lda angle
    ;clc
    adc #6
    sta angle

NoRotateForSerious
    lda xstart
    ;clc
    adc #10
    sta xstart

DoneRotoSetup
    ldx angle
    lda SinTab,X
    lsr
    lsr
    lsr
    lsr
    sta dx
    sta dy0

    txa
    ;clc
    adc #128
    tax
    lda SinTab,X
    lsr
    lsr
    lsr
    lsr
    sta dx0
    eor #$FF
    sta dy

    lda xstart
    sta x0
    lda #0
    sta y0

XPOS    equ 82
    lda #XPOS
    ldx #0
    jsr PositionObject  ;P0

    sta WSYNC
    sta HMOVE

    lda #$07
    sta NUSIZ0      ;quad sized player

    lda #$02
    sta CTRLPF      ;score
    brk ;jmp LogicRet

Roto28Kernel
    lda atten
    bne FadingOut

    ldx frame
    lda SinTab,X
    lsr
    lsr
    lsr
    lsr
    ora #$B0
    sta COLUP0
    lda #$28
    bne SetRotoBackground

FadingOut
    sec
    sbc #1
    asl
    cmp #16
    bcs Black
    eor #$0F
    .byte $0C
Black
    lda #0
SetRotoBackground
    sta COLUBK
    sta COLUP1

#if TRIANGLES
    lda #LINES/11
#else
    lda #LINES/13+1
#endif
    sta rotoline
RotozoomKernel_Loop
    lda x0
    clc
    adc dx0
    sta x0
    sta x
    lda y0
    clc
    adc dy0
    sta y0
    tay

    ;setting the first bit is easier
#if TRIANGLES
    cmp x
    ror pf0next
#else
    eor x
    and #%10000000
    sta pf0next
#endif

    ldx #3          ;bits
DoPF0
    lda x
    adc dx
    sta x

    tya
    adc dy
    tay

#if TRIANGLES
    cmp x
#else
    eor x
    cmp #%10000000
#endif
    ror pf0next

    dex
    bne DoPF0

    ldx #8          ;bits
DoPF1
    lda x
    adc dx
    sta x

    tya
    adc dy
    tay

#if TRIANGLES
    cmp x
#else
    eor x
    cmp #%10000000
#endif
    rol pf1next

    dex
    bne DoPF1

    ldx #8          ;bits
DoPF2
    lda x
    adc dx
    sta x

    tya
    adc dy
    tay

#if TRIANGLES
    cmp x
#else
    eor x
    cmp #%10000000
#endif
    ror pf2next

    dex
    bne DoPF2

    ldx #8          ;bits
DoGRP0
    lda x
    adc dx
    sta x

    tya
    adc dy
    tay

#if TRIANGLES
    cmp x
#else
    eor x
    cmp #%10000000
#endif
    rol grp0next

    dex
    bne DoGRP0

    ;sta WSYNC      ;no need to waste time actually..
    lda pf0next
    sta PF0
    lda pf1next
    sta PF1
    lda pf2next
    sta PF2
    lda grp0next
    sta GRP0

    dec rotoline
    bne RotozoomKernel_Loop

    lda #0

#if !TRIANGLES
    SLEEP 10        ;line count varies without this
    ldx #9
SquareBurn
    sta WSYNC
    dex
    bne SquareBurn
    sta COLUBK
#endif

    sta PF0
    sta PF1
    sta PF2
    sta GRP0

#if TRIANGLES
    sta WSYNC
    sta WSYNC
#endif

    jmp KernelRet