/*
 * Decompiled with CFR 0.152.
 */
package timeline;

import interfaces.OpenGLDrawable;
import java.io.Serializable;
import java.util.ArrayList;
import javax.media.opengl.GL2;
import opengl.Renderer;
import timeline.TimeEntitiyScene;
import timeline.TimeEntity;
import timeline.TimeEntityMasterAudio;

public class TimeLine
implements OpenGLDrawable,
Serializable {
    private TimeEntityMasterAudio masterAudio = null;
    private double currentTime = 0.0;
    private ArrayList<TimeEntity> entities = new ArrayList();
    private static TimeLine instance = null;

    public TimeLine() {
        TimeEntitiyScene te = new TimeEntitiyScene();
        te.setStartTime(0.0);
        te.setEndTime(150.0);
        te.setLevel(0);
        TimeEntitiyScene te2 = new TimeEntitiyScene();
        te2.setStartTime(150.0);
        te2.setEndTime(300.0);
        te2.setLevel(1);
        this.entities.add(te);
        this.entities.add(te2);
    }

    public static TimeLine getInstance() {
        if (instance == null) {
            instance = new TimeLine();
        }
        return instance;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(double currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public void glDraw(GL2 gl) {
        if (this.masterAudio != null && this.masterAudio.isPlaying()) {
            this.currentTime = (double)this.masterAudio.GetTime() + this.masterAudio.getStartTime();
        }
        TimeEntity[] list2drawEntities = new TimeEntity[32];
        for (TimeEntity e : this.entities) {
            if (!(this.currentTime >= e.getStartTime()) || !(this.currentTime <= e.getEndTime())) continue;
            int n = e.getLevel();
            list2drawEntities[n] = e;
        }
        int n = 0;
        while (n < 16) {
            if (list2drawEntities[n] != null && !list2drawEntities[n].getClass().equals(TimeEntityMasterAudio.class)) {
                list2drawEntities[n].glDraw(gl, (float)this.currentTime);
                Renderer.getInstance().currentTexture.renderToTexture();
            }
            ++n;
        }
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        this.glDraw(gl);
    }

    public ArrayList<TimeEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(ArrayList<TimeEntity> entities) {
        this.entities = entities;
    }

    public TimeEntityMasterAudio getMasterAudio() {
        return this.masterAudio;
    }

    public void setMasterAudio(TimeEntityMasterAudio masterAudio) {
        this.masterAudio = masterAudio;
    }
}

