/*
 * Decompiled with CFR 0.152.
 */
package timeline;

import java.util.ArrayList;
import javax.media.opengl.GL2;
import model.MyShaderProgram;
import opengl.Renderer;
import timeline.TimeEntity;
import variables.MyLine;
import variables.MyTexMap;
import variables.Variable;

public class TimeEntityShaderBlur
extends TimeEntity {
    private MyLine angle = new MyLine("Angle", 0.0, 1.0);
    private MyLine amount = new MyLine("Amount", 0.5, 1.5);
    private MyLine mix = new MyLine("Mix output", 1.0, 2.0);
    private MyTexMap outputMap = new MyTexMap();
    private MyTexMap inputMap = new MyTexMap();
    transient MyShaderProgram shader = null;

    public TimeEntityShaderBlur() {
        this.name = "Blur [shader]";
        this.inputMap.setName("Input Map");
        this.outputMap.setName("Output Map");
        this.inputMap.tex_type = 1;
        this.outputMap.tex_type = 1;
    }

    private void screenQuad(GL2 gl) {
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl.glLoadIdentity();
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3d(-1.0, -1.0, 0.0);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3d(-1.0, 1.0, 0.0);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3d(1.0, 1.0, 0.0);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3d(1.0, -1.0, 0.0);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glPopMatrix();
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        float time2;
        poz = time2 = (float)(500.0 * ((double)poz - this.startTime) / (this.endTime - this.startTime));
        gl.glPushAttrib(1048575);
        gl.glClear(16384);
        gl.glDisable(2896);
        gl.glDisable(3042);
        gl.glEnable(3553);
        gl.glDisable(2929);
        gl.glClear(256);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.shader == null) {
            Renderer.getInstance().getGL2().getContext().makeCurrent();
            this.shader = Renderer.getInstance().getEffect_blur();
            if (this.shader == null) {
                Renderer.getInstance().CreateShaders();
            }
        }
        this.shader.bind(true);
        Renderer.getInstance().currentTexture.bind();
        gl.glActiveTexture(33984);
        this.inputMap.bind();
        int uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "t1");
        gl.glUniform1i(uloc, 0);
        Renderer.getInstance().currentTexture.bind();
        gl.glActiveTexture(33985);
        this.inputMap.bind();
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "t2");
        gl.glUniform1i(uloc, 1);
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "angle");
        gl.glUniform1f(uloc, (float)(-this.angle.getScaledValue(poz)) + 0.1f);
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "amount");
        gl.glUniform1f(uloc, (float)(-this.amount.getScaledValue(poz)));
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "mix");
        gl.glUniform1f(uloc, 1.0f);
        this.screenQuad(gl);
        gl.glActiveTexture(33984);
        Renderer.getInstance().tempTexture.renderToTexture();
        gl.glActiveTexture(33984);
        Renderer.getInstance().tempTexture.bind();
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "t1");
        gl.glUniform1i(uloc, 0);
        gl.glActiveTexture(33985);
        this.inputMap.bind();
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "t2");
        gl.glUniform1i(uloc, 1);
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "angle");
        gl.glUniform1f(uloc, (float)(-this.angle.getScaledValue(poz)) + 2.0f);
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "amount");
        gl.glUniform1f(uloc, (float)(-this.amount.getScaledValue(poz)));
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "mix");
        gl.glUniform1f(uloc, (float)(-this.mix.getScaledValue(poz)));
        this.screenQuad(gl);
        gl.glUseProgram(0);
        gl.glActiveTexture(33984);
        this.outputMap.renderToTexture();
        gl.glPopAttrib();
    }

    @Override
    public ArrayList<Variable> getAttributes() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.angle);
        var.add(this.amount);
        var.add(this.mix);
        var.add(this.inputMap);
        var.add(this.outputMap);
        return var;
    }
}

