/*
 * Decompiled with CFR 0.152.
 */
package timeline;

import java.util.ArrayList;
import javax.media.opengl.GL2;
import model.MyShaderProgram;
import opengl.Renderer;
import timeline.TimeEntity;
import variables.MyLine;
import variables.MyTexMap;
import variables.Variable;

public class TimeEntityBokehDOF
extends TimeEntity {
    private MyLine amount = new MyLine("Amount", 2.0, 5.0);
    private MyLine dofFadein = new MyLine("DOF fade in", 10.0, 200.0);
    private MyLine dofClear = new MyLine("DOF clear", 40.0, 200.0);
    private MyLine dofFadeout = new MyLine("DOF fade out", 80.0, 200.0);
    private MyTexMap outputMap = new MyTexMap();
    private MyTexMap inputMap = new MyTexMap();
    transient MyShaderProgram shader = null;

    public TimeEntityBokehDOF() {
        this.name = "Bokeh DOF";
        this.inputMap.setName("Input Map");
        this.outputMap.setName("Output Map");
        this.inputMap.tex_type = 1;
        this.outputMap.tex_type = 1;
    }

    private void screenQuad(GL2 gl) {
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glColor4d(1.0, 1.0, 1.0, 1.0);
        gl.glLoadIdentity();
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3d(-1.0, -1.0, 0.0);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3d(-1.0, 1.0, 0.0);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3d(1.0, 1.0, 0.0);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3d(1.0, -1.0, 0.0);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glPopMatrix();
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
        float time2;
        poz = time2 = (float)(500.0 * ((double)poz - this.startTime) / (this.endTime - this.startTime));
        gl.glPushAttrib(1048575);
        gl.glClear(16384);
        gl.glDisable(2896);
        gl.glDisable(3042);
        gl.glEnable(3553);
        gl.glDisable(2929);
        gl.glClear(256);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.shader == null) {
            Renderer.getInstance().getGL2().getContext().makeCurrent();
            this.shader = Renderer.getInstance().getDOF_blur();
            if (this.shader == null) {
                Renderer.getInstance().CreateShaders();
            }
        }
        this.shader.bind(true);
        gl.glActiveTexture(33984);
        this.inputMap.bind();
        int uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "t1");
        gl.glUniform1i(uloc, 0);
        gl.glActiveTexture(33985);
        Renderer.getInstance().depthBuffer.bind();
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "depthpacked");
        gl.glUniform1i(uloc, 1);
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "amount");
        gl.glUniform1f(uloc, (float)(-this.amount.getScaledValue(poz)));
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "fadein");
        gl.glUniform1f(uloc, (float)(-this.dofFadein.getScaledValue(poz)));
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "clear");
        gl.glUniform1f(uloc, (float)(-this.dofClear.getScaledValue(poz)));
        uloc = gl.glGetUniformLocation(this.shader.getProgramID(), "fadeout");
        gl.glUniform1f(uloc, (float)(-this.dofFadeout.getScaledValue(poz)));
        this.screenQuad(gl);
        gl.glActiveTexture(33984);
        this.outputMap.renderToTexture();
        gl.glUseProgram(0);
        gl.glActiveTexture(33984);
        Renderer.getInstance().currentTexture.renderToTexture();
        gl.glPopAttrib();
    }

    @Override
    public ArrayList<Variable> getAttributes() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.amount);
        var.add(this.inputMap);
        var.add(this.outputMap);
        var.add(this.dofFadein);
        var.add(this.dofClear);
        var.add(this.dofFadeout);
        return var;
    }
}

