/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import opengl.Renderer;
import scene.Entity;
import util.newId;
import variables.MyLine;
import variables.MyShaderVariable;
import variables.Variable;

public class Camera
implements Entity {
    private static final long serialVersionUID = -8699890929379297365L;
    transient GLU glu = null;
    private String name = "Camera";
    public Point2D position = new Point2D.Double(100.0, 100.0);
    private int id;
    private MyLine x = new MyLine("X", 0.0, 10.0);
    private MyLine y = new MyLine("Y", 0.0, 10.0);
    private MyLine z = new MyLine("Z", 0.0, 10.0);
    private MyLine rotx = new MyLine("rot.X", 30.0, 180.0);
    private MyLine roty = new MyLine("rot.Y", 0.0, 180.0);
    private MyLine rotz = new MyLine("rot.Z", 0.0, 180.0);
    private MyLine dist = new MyLine("Distance", -2.5, 20.0);
    private MyLine fov = new MyLine("FOV", 45.0, 120.0);
    public MyLine camShakePozVal = new MyLine("Rand.XYZ.val", 0.0, 1.0);
    public MyLine camShakePozSpd = new MyLine("Rand.XYZ.spd", 0.2, 1.0);
    public MyLine camShakeRotVal = new MyLine("Rand.rot.val", 0.0, 1.0);
    public MyLine camShakeRotSpd = new MyLine("Rand.rot.spd", 0.2, 1.0);

    public Camera() {
        this.roty.points.add(new Point2D.Double(275.0, 275.0));
        this.roty.type = 1;
        this.id = newId.getNextId();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public MyShaderVariable getShader() {
        return null;
    }

    public void Push(GL2 gl, float poz) {
        Random r = new Random(5L);
        double randX = 0.0;
        double randY = 0.0;
        double randZ = 0.0;
        double randsize = -this.camShakePozVal.getScaledValue(poz) / 2.0;
        double randspd = -this.camShakePozSpd.getScaledValue(poz) / 2.0;
        int u = 0;
        while (u < 3) {
            randX += Math.sin(randspd * (double)poz * r.nextDouble() + r.nextDouble() * 2.0) * r.nextDouble();
            randY += Math.sin(randspd * (double)poz * r.nextDouble() + r.nextDouble() * 3.0) * r.nextDouble();
            randZ += Math.sin(randspd * (double)poz * r.nextDouble() + r.nextDouble() * 4.0) * r.nextDouble();
            ++u;
        }
        randX *= randsize;
        randY *= randsize;
        randZ *= randsize;
        double randRX = 0.0;
        double randRY = 0.0;
        double randRZ = 0.0;
        double randRsize = -this.camShakeRotVal.getScaledValue(poz) / 2.0;
        double randRspd = -this.camShakeRotSpd.getScaledValue(poz) / 2.0;
        int u2 = 0;
        while (u2 < 3) {
            randRX += Math.sin(randRspd * (double)poz * r.nextDouble() + r.nextDouble() * 2.0) * r.nextDouble();
            randRY += Math.sin(randRspd * (double)poz * r.nextDouble() + r.nextDouble() * 3.0) * r.nextDouble();
            randRZ += Math.sin(randRspd * (double)poz * r.nextDouble() + r.nextDouble() * 4.0) * r.nextDouble();
            ++u2;
        }
        randRX *= randRsize;
        randRY *= randRsize;
        randRZ *= randRsize;
        if (this.glu == null) {
            this.glu = Renderer.getInstance().getGlu();
        }
        double cam_dist = this.dist.getScaledValue(poz);
        double xrot = -this.rotx.getScaledValue(poz);
        double yrot = -this.roty.getScaledValue(poz);
        double zrot = -this.rotz.getScaledValue(poz);
        double xt = -this.x.getScaledValue(poz);
        double yt = -this.y.getScaledValue(poz);
        double zt = -this.z.getScaledValue(poz);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(-this.fov.getScaledValue(poz), 1.7777777910232544, (double)0.01f, 500.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        float[] light_ambient = new float[]{0.2f, 0.0f, 0.0f, 1.0f};
        float[] light_diffuse = new float[]{0.5f, 0.8f, 0.5f, 1.0f};
        float[] light_specular = new float[]{0.0f, 1.0f, 1.0f, 1.0f};
        float[] light_position = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        gl.glPushMatrix();
        gl.glTranslated(0.0, 0.0, -cam_dist);
        gl.glRotated(xrot, 1.0, 0.0, 0.0);
        gl.glRotated(yrot, 0.0, 1.0, 0.0);
        gl.glRotated(zrot, 0.0, 0.0, 1.0);
        gl.glTranslated(xt + randX, yt + randY, zt + randZ);
        gl.glPushMatrix();
        gl.glRotated(randRX, 1.0, 0.0, 0.0);
        gl.glRotated(randRY, 0.0, 1.0, 0.0);
        gl.glRotated(randRZ, 0.0, 0.0, 1.0);
        gl.glPushMatrix();
    }

    public void Pop(GL2 gl) {
        gl.glPopMatrix();
        gl.glPopMatrix();
        gl.glPopMatrix();
    }

    @Override
    public ArrayList<Variable> GetVariables() {
        ArrayList<Variable> var = new ArrayList<Variable>();
        var.add(this.x);
        var.add(this.y);
        var.add(this.z);
        var.add(this.rotx);
        var.add(this.roty);
        var.add(this.rotz);
        var.add(this.dist);
        var.add(this.fov);
        var.add(this.camShakePozVal);
        var.add(this.camShakePozSpd);
        var.add(this.camShakeRotVal);
        var.add(this.camShakeRotSpd);
        return var;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point2D position) {
        this.position = position;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void glDraw(GL2 gl) {
    }

    @Override
    public void glDraw(GL2 gl, float poz) {
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setShader(MyShaderVariable var) {
    }
}

