/*
 * Decompiled with CFR 0.152.
 */
package opengl;

import com.jogamp.opengl.util.FPSAnimator;
import interfaces.OpenGLDrawable;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import model.MyShaderProgram;
import opengl.RenderTexture;
import scene.Camera;
import scene.CameraLookat;
import scene.EntityModel;
import scene.Scene;

public class Renderer
implements GLEventListener {
    public int MAX_SHADERS = 24;
    private Object camera = null;
    float scenetime;
    private int x = 0;
    private int y = 0;
    private int width;
    private int height;
    public GLAutoDrawable gLAutoDrawable;
    private GLU glu = new GLU();
    FPSAnimator animator;
    private boolean useShaders = true;
    public int MAX_RENDER_TEXTURES = 5;
    public RenderTexture[] renderTetxures = new RenderTexture[5];
    public RenderTexture normalBuffer;
    public RenderTexture depthBuffer;
    public RenderTexture colorBuffer;
    public RenderTexture ssaoBuffer;
    public RenderTexture currentTexture;
    public RenderTexture tempTexture;
    private ArrayList<MyShaderProgram> shaders = new ArrayList();
    private MyShaderProgram AO_Shader;
    private MyShaderProgram AO_blur;
    private MyShaderProgram AO_normal;
    private MyShaderProgram AO_depth;
    private MyShaderProgram AO_mix;
    private MyShaderProgram DOF_blur;
    public MyShaderProgram currentShader = null;
    private MyShaderProgram Effect_blur = null;
    public RENDER_LAYER renderLayer;
    private boolean builtinShadersCompiled = false;
    private static Renderer instance = null;
    OpenGLDrawable GLobjectToDraw;

    public MyShaderProgram getDOF_blur() {
        return this.DOF_blur;
    }

    public MyShaderProgram getEffect_blur() {
        return this.Effect_blur;
    }

    public MyShaderProgram getAO_Shader() {
        return this.AO_Shader;
    }

    public MyShaderProgram getAO_blur() {
        return this.AO_blur;
    }

    public MyShaderProgram getAO_normal() {
        return this.AO_normal;
    }

    public MyShaderProgram getAO_depth() {
        return this.AO_depth;
    }

    public MyShaderProgram getAO_mix() {
        return this.AO_mix;
    }

    public boolean isUseShaders() {
        return this.useShaders;
    }

    public void setUseShaders(boolean useShaders) {
        this.useShaders = useShaders;
    }

    public void CompileBuiltinShaders() {
        this.gLAutoDrawable.getGL().getContext().makeCurrent();
        this.AO_Shader.compile();
        this.AO_blur.compile();
        this.AO_normal.compile();
        this.AO_depth.compile();
        this.AO_mix.compile();
        this.Effect_blur.compile();
        this.DOF_blur.compile();
    }

    public void CreateShaders() {
        this.gLAutoDrawable.getContext().makeCurrent();
        int i = 0;
        while (i < this.MAX_SHADERS) {
            MyShaderProgram msp = new MyShaderProgram();
            msp.setName("Blank shader #" + i);
            msp.setPosition(new Point2D.Double(200.0, i * 40));
            this.shaders.add(msp);
            ++i;
        }
        this.AO_Shader = new MyShaderProgram("shaders/ao.vert", "shaders/ao.frag");
        this.AO_blur = new MyShaderProgram("shaders/ao_blur.vert", "shaders/ao_blur.frag");
        this.AO_normal = new MyShaderProgram("shaders/ao_normal.vert", "shaders/ao_normal.frag");
        this.AO_depth = new MyShaderProgram("shaders/ao_depth.vert", "shaders/ao_depth.frag");
        this.AO_mix = new MyShaderProgram("shaders/ao_mix.vert", "shaders/ao_mix.frag");
        this.DOF_blur = new MyShaderProgram("shaders/blur.vert", "shaders/dofBlur.frag");
        this.Effect_blur = new MyShaderProgram("shaders/blur.vert", "shaders/blur.frag");
        this.CompileBuiltinShaders();
    }

    public ArrayList<MyShaderProgram> getShaders() {
        return this.shaders;
    }

    public void setShaders(ArrayList<MyShaderProgram> shaders) {
        this.shaders = shaders;
    }

    public GLU getGlu() {
        return this.glu;
    }

    public GL2 getGL2() {
        return this.gLAutoDrawable.getGL().getGL2();
    }

    public static Renderer getInstance() {
        if (instance == null) {
            instance = new Renderer();
        }
        return instance;
    }

    public OpenGLDrawable getGLobjectToDraw() {
        return this.GLobjectToDraw;
    }

    public void setGLobjectToDraw(OpenGLDrawable gLobjectToDraw) {
        this.GLobjectToDraw = gLobjectToDraw;
        try {
            this.display(this.gLAutoDrawable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        GL2 gl = this.gLAutoDrawable.getGL().getGL2();
        gl.glClear(16640);
        gl.glLoadIdentity();
    }

    public void display(GLAutoDrawable gLDrawable) {
        GL2 gl = gLDrawable.getGL().getGL2();
        gl.glClear(16640);
        gl.glLoadIdentity();
        gl.glUseProgram(0);
        gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.GLobjectToDraw != null && this.GLobjectToDraw.getClass() != EntityModel.class) {
            gl.glDisable(2896);
        }
        if (this.camera != null) {
            if (this.camera.getClass().equals(Camera.class)) {
                ((Camera)this.camera).Push(gl, this.scenetime);
            }
            if (this.camera.getClass().equals(CameraLookat.class)) {
                ((CameraLookat)this.camera).Push(gl, this.scenetime);
            }
        }
        if (this.GLobjectToDraw != null && this.GLobjectToDraw.getClass().equals(Scene.class)) {
            ((Scene)this.GLobjectToDraw).enableLights(gl, this.scenetime);
        }
        if (this.GLobjectToDraw != null) {
            this.GLobjectToDraw.glDraw(gl, this.scenetime);
        }
        if (this.camera != null) {
            if (this.camera.getClass().equals(Camera.class)) {
                ((Camera)this.camera).Pop(gl);
            }
            if (this.camera.getClass().equals(CameraLookat.class)) {
                ((CameraLookat)this.camera).Pop(gl);
            }
        }
        if (this.GLobjectToDraw != null && this.GLobjectToDraw.getClass().equals(Scene.class)) {
            ((Scene)this.GLobjectToDraw).disableLights(gl);
        }
        gl.glFlush();
    }

    public void displayChanged(GLAutoDrawable gLDrawable, boolean modeChanged, boolean deviceChanged) {
        System.out.println("displayChanged called");
    }

    public void init(GLAutoDrawable gLDrawable) {
        System.out.println("init() called");
        GL2 gl = gLDrawable.getGL().getGL2();
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.width = gLDrawable.getWidth();
        this.height = gLDrawable.getHeight();
        this.gLAutoDrawable = gLDrawable;
        this.CreateShaders();
        this.animator = new FPSAnimator(gLDrawable, 60);
        this.animator.start();
    }

    public void reshape(GLAutoDrawable gLDrawable, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.gLAutoDrawable = gLDrawable;
        System.out.println("reshape() called: x = " + x + ", y = " + y + ", width = " + width + ", height = " + height);
        GL2 gl = gLDrawable.getGL().getGL2();
        if (height <= 0) {
            height = 1;
        }
        int w = width;
        int h = height;
        if (width > height * 16 / 9) {
            w = h * 16 / 9;
        } else {
            h = w * 9 / 16;
        }
        int xx = (width - w) / 2;
        int yy = (height - h) / 2;
        int i = 0;
        while (i < this.MAX_RENDER_TEXTURES) {
            this.renderTetxures[i] = new RenderTexture();
            this.renderTetxures[i].allocate(xx, yy, w, h);
            ++i;
        }
        this.normalBuffer = new RenderTexture();
        this.normalBuffer.allocate(xx, yy, w, h);
        this.depthBuffer = new RenderTexture();
        this.depthBuffer.allocate(xx, yy, w, h);
        this.colorBuffer = new RenderTexture();
        this.colorBuffer.allocate(xx, yy, w, h);
        this.ssaoBuffer = new RenderTexture();
        this.ssaoBuffer.allocate(xx, yy, w, h);
        this.currentTexture = new RenderTexture();
        this.currentTexture.allocate(xx, yy, w, h);
        this.tempTexture = new RenderTexture();
        this.tempTexture.allocate(xx, yy, w, h);
        gl.glViewport(xx, yy, w, h);
    }

    public void dispose(GLAutoDrawable arg0) {
        System.out.println("dispose() called");
    }

    public void setSceneTime(float scenetime) {
        this.scenetime = scenetime;
    }

    public void setCamera(Object selectedCamera) {
        this.camera = selectedCamera;
    }

    public static enum RENDER_LAYER {
        DEPTH,
        NORMAL,
        COLOR,
        SSAO;

    }
}

