/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.StringTokenizer;
import model.MyTexture;
import obj3d.ObjModel;
import util.newId;

public class Resource
implements Serializable {
    private String name;
    protected String filename;
    private MyTexture texture = null;
    private ObjModel model = null;
    private Point2D position = new Point2D.Double(110.0, 111.0);
    private int id = newId.getNextId();

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void load() {
        StringTokenizer st = new StringTokenizer(this.filename, ".");
        String str = "";
        while (st.hasMoreTokens()) {
            str = st.nextToken().toLowerCase();
        }
        if (str.equals("png") || str.equals("jpg") || str.equals("bmp")) {
            this.setTexture(new MyTexture(this.filename));
        }
        if (str.equals("obj")) {
            this.setModel(new ObjModel(this.filename));
        }
    }

    public ObjModel getModel() {
        return this.model;
    }

    public void setModel(ObjModel model) {
        this.model = model;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public MyTexture getTexture() {
        return this.texture;
    }

    public void setTexture(MyTexture texture) {
        this.texture = texture;
    }
}

