/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.menus.PopupShader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import model.MyShaderProgram;
import opengl.Renderer;

public class PanelShaderEditor
extends JPanel {
    private MyShaderProgram shader = null;
    private int shaderNum = -1;
    PanelShaderEditor panelShaderEditor = this;
    private JButton btnCompile = new JButton("Compile & Link");
    JMenuBar menubar = new JMenuBar();
    JTabbedPane tabs = new JTabbedPane();
    private TextEditor editFrag = new TextEditor();
    private TextEditor editVert = new TextEditor();
    JTextArea txtOutputMain = new JTextArea(18, 80);
    JPanel panel = new JPanel();

    public void setInfoLog(String log) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.editVert.txtEditor.setEnabled(enabled);
        this.getEditFrag().txtEditor.setEnabled(enabled);
        this.btnCompile.setEnabled(enabled);
    }

    public void SetShader(MyShaderProgram sp, int shaderNum) {
        this.shader = sp;
        this.getEditFrag().txtEditor.setText("");
        this.editVert.txtEditor.setText("");
        if (this.shader != null) {
            this.getEditFrag().setText(this.shader.getFragString());
            this.editVert.setText(this.shader.getVertString());
        }
        shaderNum = Renderer.getInstance().getShaders().indexOf(sp);
    }

    public PanelShaderEditor(int shaderNum) {
        this.txtOutputMain.setEditable(false);
        this.shaderNum = shaderNum;
        try {
            this.shader = Renderer.getInstance().getShaders().get(shaderNum);
            if (this.shader != null) {
                this.getEditFrag().setText(this.shader.getFragString());
                this.editVert.setText(this.shader.getVertString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int w = toolkit.getScreenSize().width;
        int h = toolkit.getScreenSize().width;
        this.setSize(w / 2, h / 2);
        this.setLocation(w / 4, 0);
        this.tabs.addTab("Vertex Shader", this.editVert);
        this.tabs.addTab("Fragment Shader", this.getEditFrag());
        JScrollPane spane = new JScrollPane(this.txtOutputMain);
        JSplitPane splitpane = new JSplitPane(0, this.tabs, spane);
        this.add((Component)this.btnCompile, "North");
        this.add((Component)splitpane, "Center");
        this.btnCompile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PanelShaderEditor.this.txtOutputMain.setText("Compiling...");
                try {
                    PanelShaderEditor.this.shader.setFragString(PanelShaderEditor.this.getEditFrag().getText());
                    PanelShaderEditor.this.shader.setVertString(PanelShaderEditor.this.editVert.getText());
                    PanelShaderEditor.this.shader.compile();
                    PanelShaderEditor.this.txtOutputMain.setText(PanelShaderEditor.this.shader.getInfoLog());
                }
                catch (Exception e) {
                    PanelShaderEditor.this.txtOutputMain.setText("Error occured during compile...");
                    e.printStackTrace();
                }
            }
        });
    }

    public void setEditFrag(TextEditor editFrag) {
        this.editFrag = editFrag;
    }

    public TextEditor getEditFrag() {
        return this.editFrag;
    }

    public TextEditor getEditVert() {
        return this.editVert;
    }

    public class TextEditor
    extends JPanel {
        JSplitPane splitpane;
        public JTextArea txtEditor = new JTextArea(18, 80);
        JScrollPane spEditor = new JScrollPane();
        JScrollPane spOutput = new JScrollPane();
        Font font = new Font("Courier", 0, 12);

        public void loadTextFile(String name) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(name));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
            }
            catch (Exception e) {
                return;
            }
            this.txtEditor.setText(sb.toString());
        }

        public void setText(String text) {
            this.txtEditor.setText(text);
        }

        public String getText() {
            return this.txtEditor.getText();
        }

        public TextEditor() {
            this.setLayout(new BorderLayout());
            this.txtEditor.setFont(this.font);
            this.spEditor = new JScrollPane(this.txtEditor);
            this.add(this.spEditor);
            this.txtEditor.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        PopupShader popup = new PopupShader(((TextEditor)TextEditor.this).PanelShaderEditor.this.panelShaderEditor);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                }

                @Override
                public void mouseEntered(MouseEvent arg0) {
                }

                @Override
                public void mouseClicked(MouseEvent arg0) {
                }
            });
        }
    }
}

