/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.App;
import gui.FrameSelectBlendType;
import gui.FrameSelectList;
import gui.FrameSelectModel;
import gui.FrameSelectModelFromScene;
import gui.FrameSelectShader;
import gui.FrameSelectTexture;
import gui.MyLineEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import model.MyShaderProgram;
import model.Resources;
import opengl.Renderer;
import scene.Entity;
import scene.Scene;
import variables.BlendType;
import variables.ModelID;
import variables.MyInteger;
import variables.MyLine;
import variables.MyShaderVariable;
import variables.TexGenMode;
import variables.TextureID;
import variables.Toggle;
import variables.Uniform;
import variables.Variable;

public class PanProperties
extends JPanel {
    private JPanel panButtons = new JPanel();
    private MyLineEditorPanel panLineEditor = new MyLineEditorPanel();
    private ArrayList<String> attribnames = new ArrayList();
    private ArrayList<Component> attribButtons = new ArrayList();
    private MyLine selectedLine = new MyLine();
    final JPanel panShaderUniforms = new JPanel(new GridLayout(32, 1));
    private JPanel view;
    private Entity selectedEntity;
    protected float scenetime;
    Entity selectedCamera;
    Scene selected;

    public Entity getSelectedCamera() {
        return this.selectedCamera;
    }

    public void setSelectedCamera(Entity sel) {
        this.selectedCamera = sel;
    }

    public Scene getSelected() {
        return this.selected;
    }

    public void setSelected(Scene selected) {
        this.selected = selected;
    }

    public Entity getSelectedEntity() {
        return this.selectedEntity;
    }

    public void setSelectedEntity(Entity selectedEntity) {
        this.selectedEntity = selectedEntity;
    }

    public void setUniformLines(MyShaderVariable var) {
        this.panShaderUniforms.removeAll();
        this.panShaderUniforms.add(new JLabel("Shader uniforms:"));
        for (final Uniform eu : this.selectedEntity.getShader().getUniforms()) {
            final JToggleButton btnUniform = new JToggleButton();
            btnUniform.setText(eu.name);
            btnUniform.setToolTipText(String.valueOf(eu.name) + " - type: " + eu.type);
            btnUniform.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PanProperties.this.panLineEditor.setLine(eu.line);
                    PanProperties.this.panLineEditor.updateUI();
                    Component[] componentArray = PanProperties.this.panShaderUniforms.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component comp2 = componentArray[n2];
                        if (comp2.getClass().equals(JToggleButton.class)) {
                            if (!comp2.equals(btnUniform)) {
                                ((JToggleButton)comp2).setSelected(false);
                            } else {
                                ((JToggleButton)comp2).setSelected(true);
                            }
                        }
                        ++n2;
                    }
                }
            });
            this.panShaderUniforms.add(btnUniform);
        }
        Font font = new Font(this.panButtons.getFont().getName(), 0, 11);
        Component[] componentArray = this.panShaderUniforms.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setFont(font);
            c.setPreferredSize(new Dimension(90, 17));
            ++n2;
        }
    }

    public void SetLines(ArrayList<Variable> lines) {
        this.panShaderUniforms.removeAll();
        this.removeAll();
        this.panButtons = new JPanel();
        GridLayout layout = new GridLayout(lines.size(), 1);
        this.panLineEditor = new MyLineEditorPanel();
        for (Variable v : lines) {
            if (!v.getClass().equals(MyLine.class)) continue;
            this.panLineEditor.setLine((MyLine)v);
        }
        boolean i = false;
        for (final Variable l : lines) {
            JLabel lblVarName;
            JPanel panStuff;
            final JToggleButton btn = new JToggleButton(l.getName());
            double K = 0.65;
            Dimension d = btn.getPreferredSize();
            d.setSize(72.0, d.getHeight() * K);
            btn.setPreferredSize(d);
            Font font = new Font(btn.getFont().getName(), 0, 11);
            btn.setFont(font);
            btn.setText(l.getName());
            if (l.getClass().equals(TextureID.class)) {
                try {
                    btn.setText(String.valueOf(l.getName()) + ": " + Resources.getInstance().getByID(((TextureID)l).ID).getName());
                }
                catch (Exception e) {
                    btn.setText(String.valueOf(l.getName()) + " - select");
                }
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        btn.setSelected(false);
                        FrameSelectTexture frameSelTex = new FrameSelectTexture(((TextureID)l).ID);
                        frameSelTex.setLocation(MouseInfo.getPointerInfo().getLocation().x - (int)frameSelTex.getSize().getWidth() / 2, MouseInfo.getPointerInfo().getLocation().y - (int)frameSelTex.getSize().getHeight() / 2);
                        frameSelTex.setModal(true);
                        frameSelTex.show();
                        if (frameSelTex.getSelected() != null) {
                            ((TextureID)l).ID = frameSelTex.getSelected().getId();
                            btn.setText(String.valueOf(l.getName()) + ": " + Resources.getInstance().getByID(((TextureID)l).ID).getName());
                            PanProperties.this.view.updateUI();
                            App.frame.paintAll(App.frame.getGraphics());
                        }
                    }
                });
                this.attribButtons.add(btn);
            }
            if (l.getClass().equals(TexGenMode.class)) {
                final JButton btnTexGen = new JButton(l.getName());
                btnTexGen.setPreferredSize(new Dimension(64, (int)btn.getPreferredSize().getHeight()));
                btnTexGen.setToolTipText(((TexGenMode)l).getName());
                btnTexGen.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        FrameSelectList frameSel = new FrameSelectList(((TexGenMode)l).names);
                        frameSel.setLocation(MouseInfo.getPointerInfo().getLocation().x - (int)frameSel.getSize().getWidth() / 2, MouseInfo.getPointerInfo().getLocation().y - (int)frameSel.getSize().getHeight() / 2);
                        frameSel.setModal(true);
                        frameSel.show();
                        if (frameSel.getSelected() >= 0) {
                            int a;
                            ((TexGenMode)l).mode = a = frameSel.getSelected();
                            btnTexGen.setText(String.valueOf(l.getName()) + frameSel.getSelected());
                            btnTexGen.setToolTipText(((TexGenMode)l).getName());
                            PanProperties.this.view.updateUI();
                            App.frame.paintAll(App.frame.getGraphics());
                        }
                    }
                });
                this.attribButtons.add(btnTexGen);
            }
            if (l.getClass().equals(BlendType.class)) {
                final JButton btnBlend = new JButton(String.valueOf(l.getName()) + ": " + (Object)((Object)((BlendType)l).getBlendtype()));
                btnBlend.setPreferredSize(new Dimension(64, (int)btn.getPreferredSize().getHeight()));
                btnBlend.setToolTipText("" + (Object)((Object)((BlendType)l).getBlendtype()));
                btnBlend.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        FrameSelectBlendType frameSelBlend = new FrameSelectBlendType(((BlendType)l).getBlendtype());
                        frameSelBlend.setLocation(MouseInfo.getPointerInfo().getLocation().x - (int)frameSelBlend.getSize().getWidth() / 2, MouseInfo.getPointerInfo().getLocation().y - (int)frameSelBlend.getSize().getHeight() / 2);
                        frameSelBlend.setModal(true);
                        frameSelBlend.show();
                        if (frameSelBlend.getSelected() != null) {
                            ((BlendType)l).setBlendtype(frameSelBlend.getSelected());
                            btnBlend.setText(String.valueOf(l.getName()) + ": " + frameSelBlend.getSelected().name());
                            btnBlend.setToolTipText(frameSelBlend.getSelected().name());
                            PanProperties.this.view.updateUI();
                            App.frame.paintAll(App.frame.getGraphics());
                        }
                    }
                });
                this.attribButtons.add(btnBlend);
            }
            if (l.getClass().equals(ModelID.class)) {
                panStuff = new JPanel(new BorderLayout());
                final JButton btnSel = new JButton("");
                btnSel.setPreferredSize(new Dimension(32, 12));
                final JLabel lblName = new JLabel();
                try {
                    lblName.setText(String.valueOf(l.getName()) + ": " + Resources.getInstance().getByID(((ModelID)l).ID).getName());
                }
                catch (Exception e) {
                    lblName.setText("Select a model");
                }
                btnSel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (((ModelID)l).mode == 0) {
                            FrameSelectModel frameSelModel = new FrameSelectModel(((ModelID)l).ID);
                            frameSelModel.setLocation(MouseInfo.getPointerInfo().getLocation().x - (int)frameSelModel.getSize().getWidth() / 2, MouseInfo.getPointerInfo().getLocation().y - (int)frameSelModel.getSize().getHeight() / 2);
                            frameSelModel.setModal(true);
                            frameSelModel.show();
                            if (frameSelModel.getSelected() != null) {
                                ((ModelID)l).ID = frameSelModel.getSelected().getId();
                                btnSel.setText(String.valueOf(l.getName()) + ": " + Resources.getInstance().getByID(((ModelID)l).ID).getName());
                                PanProperties.this.selectedEntity.setName(Resources.getInstance().getByID(((ModelID)l).ID).getName());
                                lblName.setText(PanProperties.this.selectedEntity.getName());
                                PanProperties.this.view.updateUI();
                                App.frame.paintAll(App.frame.getGraphics());
                            }
                        } else {
                            FrameSelectModelFromScene frameSelModel = new FrameSelectModelFromScene(((ModelID)l).ID, PanProperties.this.selected);
                            frameSelModel.setLocation(MouseInfo.getPointerInfo().getLocation().x - (int)frameSelModel.getSize().getWidth() / 2, MouseInfo.getPointerInfo().getLocation().y - (int)frameSelModel.getSize().getHeight() / 2);
                            frameSelModel.setModal(true);
                            frameSelModel.show();
                            if (frameSelModel.getSelected() != 0) {
                                ((ModelID)l).ID = frameSelModel.getSelected();
                                PanProperties.this.view.updateUI();
                                App.frame.paintAll(App.frame.getGraphics());
                            }
                        }
                    }
                });
                panStuff.add((Component)btnSel, "East");
                panStuff.add((Component)lblName, "Center");
                this.attribButtons.add(panStuff);
            }
            if (l.getClass().equals(MyLine.class)) {
                btn.setMinimumSize(new Dimension(96, 12));
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (l.getClass().equals(MyLine.class)) {
                            PanProperties.this.panLineEditor.setLine((MyLine)l);
                        }
                        PanProperties.this.panLineEditor.updateUI();
                        for (Component bb : PanProperties.this.attribButtons) {
                            if (!bb.getClass().equals(JToggleButton.class)) continue;
                            JToggleButton b = (JToggleButton)bb;
                            if (!b.getText().equals(btn.getText())) {
                                b.setSelected(false);
                                continue;
                            }
                            b.setSelected(true);
                        }
                        PanProperties.this.view.updateUI();
                        App.frame.paintAll(App.frame.getGraphics());
                    }
                });
                this.attribButtons.add(btn);
            }
            if (l.getClass().equals(MyInteger.class)) {
                panStuff = new JPanel(new BorderLayout());
                lblVarName = new JLabel(l.getName());
                final JTextField txtVar = new JTextField(6);
                txtVar.setText("" + l.getScaledValue(0.0f));
                panStuff.add((Component)lblVarName, "West");
                panStuff.add((Component)txtVar, "East");
                txtVar.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent arg0) {
                        try {
                            int value = Integer.parseInt(txtVar.getText());
                            ((MyInteger)l).setInteger(value);
                        }
                        catch (Exception e) {
                            txtVar.setText("" + ((MyInteger)l).getInteger());
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent arg0) {
                    }

                    @Override
                    public void keyPressed(KeyEvent arg0) {
                    }
                });
                this.attribButtons.add(panStuff);
            } else if (l.getClass().equals(MyShaderVariable.class)) {
                panStuff = new JPanel(new BorderLayout());
                lblVarName = new JLabel(l.getName());
                btn.setText("...");
                btn.setPreferredSize(new Dimension(32, 12));
                panStuff.add((Component)lblVarName, "Center");
                panStuff.add((Component)btn, "East");
                try {
                    btn.setToolTipText(Resources.getInstance().getByID(((MyShaderVariable)l).getID()).getName());
                }
                catch (Exception e) {
                    btn.setToolTipText("Nothing selected");
                }
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        FrameSelectShader frameSel = new FrameSelectShader(((MyShaderVariable)l).getID());
                        frameSel.setLocation(MouseInfo.getPointerInfo().getLocation().x - (int)frameSel.getSize().getWidth() / 2, MouseInfo.getPointerInfo().getLocation().y - (int)frameSel.getSize().getHeight() / 2);
                        frameSel.setModal(true);
                        frameSel.show();
                        if (frameSel.getSelected() != null) {
                            MyShaderProgram shaderprogram = frameSel.getSelected();
                            ((MyShaderVariable)l).setID(shaderprogram.getId());
                            ((MyShaderVariable)l).generateUniforms(shaderprogram);
                            PanProperties.this.setUniformLines((MyShaderVariable)l);
                            PanProperties.this.updateUI();
                            btn.setToolTipText(String.valueOf(l.getName()) + ": " + shaderprogram.getName());
                            PanProperties.this.view.updateUI();
                            App.frame.paintAll(App.frame.getGraphics());
                        } else {
                            MyShaderProgram shaderprogram = frameSel.getSelected();
                            ((MyShaderVariable)l).setID(0);
                            ((MyShaderVariable)l).generateUniforms(shaderprogram);
                            PanProperties.this.setUniformLines((MyShaderVariable)l);
                            PanProperties.this.updateUI();
                            btn.setToolTipText(String.valueOf(l.getName()) + ": ");
                            PanProperties.this.view.updateUI();
                            App.frame.paintAll(App.frame.getGraphics());
                        }
                    }
                });
                this.attribButtons.add(panStuff);
            } else if (l.getClass().equals(Toggle.class)) {
                JPanel panstuff = new JPanel(new BorderLayout());
                final JCheckBox cbToggle = new JCheckBox();
                JLabel label = new JLabel(l.getName());
                label.setFont(btn.getFont());
                panstuff.add((Component)label, "Center");
                panstuff.add((Component)cbToggle, "East");
                this.attribButtons.add(panstuff);
                cbToggle.setSelected(((Toggle)l).getBool());
                cbToggle.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Toggle t = (Toggle)l;
                        t.setBool(cbToggle.isSelected());
                        PanProperties.this.view.updateUI();
                        App.frame.paintAll(App.frame.getGraphics());
                    }
                });
            }
            try {
                this.panButtons.add(this.attribButtons.get(this.attribButtons.size() - 1));
            }
            catch (Exception e) {
                System.out.println("exception " + l.getName());
            }
        }
        Font font = new Font(this.panButtons.getFont().getName(), 0, 11);
        Component[] componentArray = this.panButtons.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setFont(font);
            c.setPreferredSize(new Dimension(120, 17));
            ++n2;
        }
        this.panButtons.setLayout(layout);
        this.panLineEditor.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent arg0) {
                Renderer.getInstance().setSceneTime(PanProperties.this.scenetime);
                PanProperties.this.panLineEditor.updateUI();
                PanProperties.this.scenetime = (float)((PanProperties)PanProperties.this).panLineEditor.scenetimeP.getX();
                Renderer.getInstance().clear();
                Renderer.getInstance().setSceneTime(PanProperties.this.scenetime);
                Renderer.getInstance().setCamera(PanProperties.this.selectedCamera);
                Renderer.getInstance().setGLobjectToDraw(PanProperties.this.selected);
                App.frame.paintAll(App.frame.getGraphics());
            }

            @Override
            public void mouseDragged(MouseEvent arg0) {
                PanProperties.this.panLineEditor.updateUI();
                PanProperties.this.scenetime = (float)((PanProperties)PanProperties.this).panLineEditor.scenetimeP.getX();
                Renderer.getInstance().clear();
                Renderer.getInstance().setSceneTime(PanProperties.this.scenetime);
                Renderer.getInstance().setGLobjectToDraw(PanProperties.this.selected);
                App.frame.paintAll(App.frame.getGraphics());
            }
        });
        JPanel panLine = new JPanel(new BorderLayout());
        panLine.add((Component)this.panLineEditor, "South");
        panLine.add((Component)this.panLineEditor.getPanLineAttrib(), "North");
        this.add((Component)this.panButtons, "East");
        this.add((Component)this.panShaderUniforms, "Center");
        this.add((Component)panLine, "West");
        this.updateUI();
    }

    public PanProperties(JPanel view, Entity selectedEntity) {
        this.view = view;
        this.selectedEntity = selectedEntity;
    }

    public MyLine getSelectedLine() {
        return this.selectedLine;
    }

    public void setSelectedLine(MyLine selectedLine) {
        this.selectedLine = selectedLine;
        this.panLineEditor.setLine(selectedLine);
        this.panLineEditor.updateUI();
    }
}

