// 2011-2012 - rascy@dilemma.ws

$(document).ready(function() {

    $.extend(demo, {

        text : {
            title : 'STATE ZERO-ONE',
            party : 'Function 2012',
            group : 'Dilemma / Hungary',
            site : 'dilemma.ws',
            description : 'Thank you for watching our first WebGL powered demonstration! <br /> Made by <a href="mailto:rascy@dilemma.ws">rascy@dilemma.ws</a> for the <a href="http://2012.function.hu/">Function 2012</a> Hungarian Demoscene Party<br />Music by Shamen (Fatal Error / 2006)',
            greetings : ["Alcatraz", "Ninjadev", " Traction", "Hedelmae", "adinpsz", "ribbon", "xplsv", "vrtx", "Fairlight", "Byterapers", "Farbrausch", "Kewlers", "Andromeda", "Orange", "Stravaganza", "Haujobb", "RGBA", "MFX", "ASD", "TRSI", "TBC", "Orb", "Conspiracy", "Exceed", "Freshmindworkz", "United Force", "Ümlaüt Design", "Singular Crew", "Resource", "Rebels", "Neurosis", "Chorus"]
        },

        musicfile : {
            ogg : 'data/fatal_error_short.ogg'
        },

        // available scenes
        scene : {

            //text : new THREE.Scene(),
            title : new THREE.Scene(),
            //cookies : new THREE.Scene(),
            antenna : new THREE.Scene(),
            polip : new THREE.Scene(),
            //twister : new THREE.Scene(),
            //greets : new THREE.Scene(),
            //windows : new THREE.Scene(),
            balls : new THREE.Scene(),
            sindots : new THREE.Scene(),
            //spiker : new THREE.Scene(),
            //boxcube : new THREE.Scene()
            end : new THREE.Scene()

        },

    });

    if (demo.scene.text) {

        $.extend(demo.scene.text, {

            init : function() {

                demo.atmosphere.bright(this);

                demo.text.greetings.sort();
                var text = demo.text.greetings.join(' ');
                var mat = demo.material.text(text, 512);

                var plane = new THREE.Mesh(new THREE.PlaneGeometry(2000, 2000, 1, 1), mat);
                plane.name = 'plane';
                plane.position.set(0, 0, 0);
                plane.castShadow = false;
                plane.receiveShadow = false;
                this.add(plane);

                demo.scene_loaded++;

            },

            timeline : [[1, {
                cam : [{
                    position : [0, 0, 2000],
                    rotation : [0, 0, 0]

                }]
            }]]

        });
    }

    if (demo.scene.title) {

        $.extend(demo.scene.title, {

            init : function() {

                var thisSCENE = this;

                demo.atmosphere.title(thisSCENE);

                var text = demo.object.text('STATE ZERO-ONE', demo.material.silver, 500);
                text.position.set(2500, 0, 0);
                text.rotation.y = demo.rad(180);
                text.castShadow = true;
                text.receiveShadow = false;
                thisSCENE.add(text);

                var plane = new THREE.Mesh(new THREE.CubeGeometry(25000, 6000, 25000, 1, 1, 1, false, true), demo.material.plane);
                plane.name = 'plane';
                plane.position.set(0, 2700, 0);
                plane.castShadow = false;
                plane.receiveShadow = true;
                thisSCENE.add(plane);

                var length = 14000;
                var size_max = 300;
                var space_min = size_max;
                var space_max = size_max * 8;
                var count = length / size_max * 3;

                for ( i = 0; i < count; i++) {

                    var mat = demo.material.num0;
                    if (i % 2 == 0)
                        mat = demo.material.num1;

                    var cube = new THREE.Mesh(new THREE.CubeGeometry(size_max, size_max, size_max, 1, 1, 1, false, true), mat);
                    cube.name = 'box' + i;

                    var spaceY = Math.floor((Math.random() * space_max) + space_min);
                    var spaceZ = Math.floor((Math.random() * space_max) + space_min);

                    cube.position.y = spaceY - space_max + 2500;
                    cube.position.z = spaceZ - space_max;
                    cube.position.x = -2000 + (i * (size_max / 3));

                    cube.castShadow = true;
                    cube.receiveShadow = false;
                    thisSCENE.add(cube);

                }

                demo.scene_loaded++;

            },

            animate : function() {

                var thisSCENE = this;

                //demo.motion.camera.basic(thisSCENE, 'main');
                //demo.motion.object.flying_boxes(thisSCENE, 'box');

            },

            timeline : [[1, {
                cam : [{
                    position : [-711, 4500, -185],
                    rotation : [-1.63, 0.03, -1.6],
                    focus : 1.2,
                    aperture : 3,
                    maxblur : 0.05
                }],
                obj : {
                    multi : {
                        func : demo.motion.object.flying_boxes,
                        params : {
                            name : 'box'
                        }
                    }
                }
            }], [3000, {
                cam : [{
                    position : [-711, 2500, -185],
                    rotation : [-1.62, -0.07, -2.77],
                }]
            }], [10000, {
                cam : [{
                    focus : 1.1,
                    aperture : 2,
                    maxblur : 0.02,
                    position : [-968, 2180, 12],
                    rotation : [-1.62, -0.07, -2.77],
                }]
            }], [12800, {
                cam : [{
                    focus : 1,
                    aperture : 2,
                    maxblur : 0.02,
                    position : [-1520, 187, -2045],
                    rotation : [-2.88, -0.10, -3.01]
                }]
            }], [14590, {
                cam : [{
                    position : [1357, 859, -2593],
                    rotation : [-2.88, -0.10, -3.01]

                }]
            }], [15590, {
                cam : [{
                    position : [1357, 859, -2593],
                    rotation : [-2.88, -0.46, -3.01]

                }]
            }], [16590, {
                cam : [{
                    position : [2138, 1042, -2742],
                    rotation : [-2.65, -0.31, -3.11]
                }]
            }], [24500, {
                cam : [{
                    position : [-84, 1381, -3108],
                    rotation : [-2.59, 0.74, -3.03]
                }]
            }], [1000000, {
                cam : [{
                }]
            }]]

        });
    }

    if (demo.scene.cookies) {

        $.extend(demo.scene.cookies, {

            init : function() {

                var thisSCENE = this;

                demo.atmosphere.shadow2(thisSCENE);

                var length = 14000;
                var size_max = 300;
                var space_min = size_max;
                var space_max = size_max * 8;
                var count = length / size_max * 3;

                for ( i = 0; i < count; i++) {

                    var mat = demo.material.num0;
                    if (i % 2 == 0)
                        mat = demo.material.num1;

                    var cube = new THREE.Mesh(new THREE.CubeGeometry(size_max, size_max, size_max, 1, 1, 1, false, true), mat);
                    cube.name = 'box' + i;

                    var spaceY = Math.floor((Math.random() * space_max) + space_min);
                    var spaceZ = Math.floor((Math.random() * space_max) + space_min);

                    cube.position.y = spaceY - space_max - 500;
                    cube.position.z = spaceZ - space_max;
                    cube.position.x = (i * (size_max / 3));

                    cube.castShadow = true;
                    cube.receiveShadow = false;
                    thisSCENE.add(cube);

                }

                plane = new THREE.Mesh(new THREE.CubeGeometry(25000, 6000, 25000, 1, 1, 1, false, true), demo.material.plane);
                plane.name = 'plane';
                plane.position.set(0, 0, 0);
                plane.castShadow = false;
                plane.receiveShadow = true;
                thisSCENE.add(plane);

                demo.scene_loaded++;

            },

            animate : function() {

                var thisSCENE = this;

                demo.motion.camera.basic(thisSCENE, 'main');
                demo.motion.object.flying_boxes(thisSCENE, 'box');

            }
        });
    }

    if (demo.scene.antenna) {

        $.extend(demo.scene.antenna, {

            init : function() {

                var thisSCENE = this;

                demo.atmosphere.white(thisSCENE);

                var sky = demo.object.sky(4000, demo.material.black_plastic);
                thisSCENE.add(sky);

                var spots = demo.object.spots(6000, 500, 200);
                spots.name = 'spots';
                thisSCENE.add(spots);

                var spots2 = demo.object.spots(5000, 2000, 35);
                spots2.name = 'spots2';
                thisSCENE.add(spots2);

                var obj = demo.object.spikes;
                obj.material = demo.material.black_plastic;
                obj.scale.x = obj.scale.y = obj.scale.z = 230;
                obj.position.set(0, 0, 0);
                obj.name = 'antenna';
                thisSCENE.add(obj);

                demo.scene_loaded++;

            },

            timeline : [[1, {
                cam : [{
                    focus : 1.5,
                    aperture : 3,
                    maxblur : 0.06,
                    fov : 175,
                    position : demo.motion.camera.antenna.pos,
                    lookat : demo.motion.camera.antenna.lookat
                }],
                obj : {
                    antenna : {
                        rotation : demo.motion.object.antenna.rot
                    },
                    spots : {
                        rotation : demo.motion.object.antenna_stars.rot,
                        pad : 20
                    },
                    spots2 : {
                        rotation : demo.motion.object.antenna_stars.rot,
                        pad : 60
                    }
                }
            }], [1000, {
                cam : [{
                    focus : 1.1,
                    aperture : 2.5,
                    maxblur : 0.03,
                    fov : 125
                }]
            }], [3000, {
                cam : [{
                    focus : 1,
                    aperture : 2,
                    maxblur : 0.02,
                    fov : 95
                }]
            }], [400000, {
                cam : [{}],
                obj : {}
            }]]

        });
    }

    if (demo.scene.twister) {

        $.extend(demo.scene.twister, {

            init : function() {

                var thisSCENE = this;

                demo.atmosphere.shadow(thisSCENE);

                // generate cubes
                var size = 400;
                var count = 20;
                for ( i = 0; i < count; i++) {
                    var cube = new THREE.Mesh(new THREE.CubeGeometry(size, size, size, 1, 1, 1, false, true), demo.material.sun_pattern);
                    cube.doubleSided = false;
                    cube.name = 'cube' + i;
                    cube.position.x = -1000 + (i * size) + 500;
                    cube.castShadow = true;
                    cube.receiveShadow = false;
                    thisSCENE.add(cube);
                }

                var plane = new THREE.Mesh(new THREE.PlaneGeometry(15000, 15000, 10, 10), demo.material.plane);

                plane.doubleSided = true;
                plane.position.y = -1000;
                //plane.rotation.x = demo.rad(90);
                plane.name = 'plane';

                plane.castShadow = false;
                plane.receiveShadow = true;

                thisSCENE.add(plane);

                demo.scene_loaded++;

            },

            animate : function() {

                var thisSCENE = this;
                //demo.motion.object.rot(thisSCENE, 'cube1');
                demo.motion.object.twister(thisSCENE, 'cube');
                demo.motion.camera.polip(thisSCENE, 'main');

            }
        });
    }

    if (demo.scene.greets) {

        $.extend(demo.scene.greets, {

            init : function() {

                var thisSCENE = this;
                demo.atmosphere.foggy(thisSCENE);

                var cube = new THREE.Mesh(new THREE.CubeGeometry(5000, 5000, 5000, 16, 16, 16, false, true), demo.material.plastic_white);
                cube.doubleSided = true;
                thisSCENE.add(cube);

                demo.scene_loaded++;

            },

            animate : function() {

                var thisSCENE = this;
                demo.motion.camera.polip(thisSCENE, 'main');

            }
        });
    }

    if (demo.scene.polip) {

        $.extend(demo.scene.polip, {

            init : function() {

                var thisSCENE = this;

                demo.atmosphere.polip(this);

                var bigcube = new THREE.Mesh(new THREE.CubeGeometry(8000, 8000, 8000, 8, 8, 8, false, true), demo.material.square_lines);
                bigcube.castShadow = false;
                bigcube.receiveShadow = true;
                bigcube.name = 'cube';
                bigcube.position.set(0, 0, 0);
                this.add(bigcube);

                this.polip = demo.object.polip('cube', demo.material.energie, 30);
                this.polip.name = 'bigpolip';
                this.add(this.polip);

                // generate cubes
                var count = 9;
                var size = 1500 / (count / 3);
                var space = 1000 / (count / 3);

                for ( i = 0; i < count; i++) {
                    for ( j = 0; j < count; j++) {

                        var cube = new THREE.Mesh(new THREE.CubeGeometry(size, size, (size * Math.random() * 4), 1, 1, 1, false, true), demo.material.polip_refbox);
                        cube.doubleSided = false;
                        cube.name = 'cube' + i + j;
                        cube.position.z = 4200 - size;
                        cube.position.x = -3400 + i * (size + space);
                        cube.position.y = -3400 + j * (size + space);
                        cube.castShadow = true;
                        cube.receiveShadow = true;
                        this.add(cube);

                        var cube2 = new THREE.Mesh(new THREE.CubeGeometry(size, size, (size * Math.random() * 4), 1, 1, 1, false, true), demo.material.polip_refbox);
                        cube2.doubleSided = false;
                        cube2.name = 'cube' + i + j;
                        cube2.position.z = -4200 + size;
                        cube2.position.x = -3400 + i * (size + space);
                        cube2.position.y = -3400 + j * (size + space);
                        cube2.castShadow = true;
                        cube2.receiveShadow = true;
                        this.add(cube2);

                    }
                }

                demo.scene_loaded++;

            },

            timeline : [[1, {
                cam : [{
                    focus : 1,
                    aperture : 3,
                    maxblur : 0.02,
                    fov : 175,
                    position : [2169, 497, 3237],
                    rotation : [-0.15, 0.58, 0.61],
                    lookat : [0, 0, 0],
                    scale : [0, 1, 1]

                }],
                obj : {
                    bigpolip : {
                        rotation : [0, 5, 0]
                    }
                }
            }], [3100, {
                cam : [{
                    focus : 1,
                    aperture : 1,
                    maxblur : 0.01,
                    fov : 95,
                    position : [1620, 370, 2425],
                    rotation : [-0.15, 0.58, 0.61],
                    lookat : [0, 0, 0],
                    scale : [1, 1, 1]
                }],
                obj : {
                    bigpolip : {
                        rotation : [0, 10, 0]
                    }
                }
            }], [6340, {
                cam : [{
                    position : [2208, 1391, 2757],
                    rotation : [-0.46, 0.56, 0.32],
                    lookat : [0, 0, 0]
                }],
                obj : {
                    bigpolip : {
                        rotation : [0, 15, 0]
                    },
                    multi : {
                        func : demo.motion.byname.polip2,
                        params : {
                            name : 'polip'
                        }
                    }
                }
            }], [9700, {
                cam : [{
                    position : [-2108, 1391, 2557],
                    rotation : [0.46, -0.56, 2.32],
                    lookat : [0, 0, 0]
                }],
                obj : {
                    bigpolip : {
                        rotation : [0, 20, 0]
                    },
                    multi : {
                        func : demo.motion.byname.polip2,
                        params : {
                            name : 'polip'
                        }
                    }
                }
            }], [41000, {
                cam : [{
                    position : demo.motion.camera.polip.pos,
                    lookat : demo.motion.camera.polip.lookat,
                    rotation : SKIP,
                    scale : [1, 1, 1],
                    fov : 95
                }],
                obj : {
                    bigpolip : {
                        rotation : [15, 40, 30]
                    }
                }
            }], [43000, {
                cam : [{
                    position : demo.motion.camera.polip.pos,
                    lookat : demo.motion.camera.polip.lookat,
                    rotation : SKIP,
                    scale : [0, 0, 0],
                    fov : 175
                }],
                obj : {
                    bigpolip : {
                        rotation : [15, 40, 30]
                    }
                }
            }], [70000, {
                cam : [{
                    position : demo.motion.camera.polip.pos,
                    lookat : demo.motion.camera.polip.lookat,
                    rotation : SKIP
                }],
                obj : {
                    bigpolip : {
                        rotation : [15, 40, 30]
                    }
                }
            }]],

            animate : function() {

                //demo.motion.byname.polip2(thisSCENE, 'polip');
                demo.motion.object.light1(this, 'L1');
                demo.motion.object.light2(this, 'L3');

            }
        });
    }

    if (demo.scene.sindots) {

        $.extend(demo.scene.sindots, {

            init : function() {

                this.myMaterials = [];
                demo.atmosphere.sindots(this);

                var stars1 = demo.object.stars(5000, 3500, 45, 0xfefefe);
                stars1.name = 'stars1';
                this.add(stars1);

                // greets
                demo.text.greetings.sort();

                // particle dots
                geometry = new THREE.Geometry();
                geometry2 = new THREE.Geometry();

                var space = 1500;
                for ( i = 0; i < 192; i++) {

                    var vertex = new THREE.Vector3();
                    vertex.x = Math.sin(i) * space + (i / 5) - space / 2;
                    vertex.y = Math.sin(i) * space - space / 2;
                    vertex.z = Math.cos(i) * space - space / 2;
                    geometry2.vertices.push(vertex);

                    var vertex = new THREE.Vector3();
                    vertex.x = Math.sin(i) * space - space / 2;
                    vertex.y = Math.sin(i) * space - space / 2;
                    vertex.z = Math.cos(i) * space - space / 2;
                    geometry.vertices.push(vertex);

                }

                this.particles_count = 32;

                for ( i = 0; i < this.particles_count; i++) {

                    var even = i % 2;

                    this.myMaterials[i] = new THREE.ParticleBasicMaterial({
                        size : 400 + Math.sin(i) * 384,
                        map : demo.texture.dust,
                        blending : THREE.AdditiveBlending,
                        depthTest : false,
                        transparent : true,
                        opacity : 0.35
                    });

                    this.myMaterials[i].color.setRGB(0, 0.02, 0.1);

                    if (even) {
                        this.myParticles = new THREE.ParticleSystem(geometry, this.myMaterials[i]);
                    } else {
                        this.myParticles = new THREE.ParticleSystem(geometry2, this.myMaterials[i]);
                    }

                    this.myParticles.sortParticles = true;
                    //this.myParticles.updateMatrix();
                    this.myParticles.name = 'particle' + i;
                    this.add(this.myParticles);
                }

                demo.scene_loaded++;

            },

            timeline : [[1, {
                cam : [{
                    position : demo.motion.camera.sindots.pos,
                    lookat : demo.motion.camera.sindots.lookat,
                    scale : [1, 1, 1],
                    fov : 20
                }]
            }], [1500, {
                cam : [{
                    fov : 95
                }],

            }], [19300, {
                cam : [{
                    fov : 95,
                    position : demo.motion.camera.sindots.pos,
                    lookat : demo.motion.camera.sindots.lookat
                }],

            }], [19301, {
                cam : [{
                    fov : 95,
                    position : [0, 0, 1000],
                    lookat : [0, 0, 0],
                    scale : [1, 1, 1]
                }],

            }], [20400, {
                cam : [{
                    fov : 165,
                    position : [0, 0, 1000],
                    lookat : [0, 0, 0],
                    scale : [1, 1, 1]
                }],

            }], [25400, {
                cam : [{
                    fov : 179,
                    position : [0, 0, 5000],
                    lookat : [0, 0, 0],
                    scale : [0, 1, 1]
                }],

            }]],

            animate : function() {

                var t = demo.time + 60000;

                //var greets = this.getChildByName('greets');
                //var campos = demo.motion.camera.sindots.pos();
                //var lookat = new THREE.Vector3(campos.x, campos.y, campos.z);
                //greets.position.y = (this.currentTime / 5)- 5000;
                //greets.lookAt(lookat);

                //demo.text.greetings

                for ( i = 0; i < this.particles_count; i++) {
                    var obj = this.getChildByName('particle' + i);
                    obj.rotation.x = (t / 1980) * i / 25;
                    obj.rotation.y = (t / 1710)
                    obj.rotation.z = (t / 1120)
                }

            }
        });
    }

    if (demo.scene.spiker) {

        $.extend(demo.scene.spiker, {

            init : function() {

                var thisSCENE = this;
                demo.atmosphere.shadow2(thisSCENE);

                var cube = new THREE.Mesh(new THREE.CubeGeometry(5000, 5000, 5000, 1, 1, 1, null, true), demo.material.square_lines);
                cube.castShadow = false;
                cube.receiveShadow = true;
                thisSCENE.add(cube);

                var dust = demo.object.dust(3000, 250, 25);
                dust.name = 'dust';
                //magma.position.set(0, 2000, -2000);
                dust.position.set(0, 0, 0);
                thisSCENE.add(dust);

                var dust2 = demo.object.dust(3500, 500, 10);
                dust2.name = 'dust2';
                //magma.position.set(0, 2000, -2000);
                dust2.position.set(0, 0, 0);
                thisSCENE.add(dust2);

                var obj = demo.object.spikes;
                obj.material = demo.material.spikerball;
                obj.scale.x = obj.scale.y = obj.scale.z = 150;
                obj.position.set(0, 0, 0);
                obj.castShadow = true;
                obj.receiveShadow = false;
                thisSCENE.add(obj);

                //var text = demo.object.text_greetings('STATE ZERO-ONE',
                // 'test');
                //text.position.y = 100;
                //thisSCENE.add(text);

                demo.scene_loaded++;

            },

            animate : function() {

                var thisSCENE = this;

                demo.motion.object.rot(thisSCENE, 'spikes');

                demo.motion.object.dust(thisSCENE, 'dust', 100);
                demo.motion.object.dust(thisSCENE, 'dust2', 110);

            }
        });
    }

    if (demo.scene.balls) {

        $.extend(demo.scene.balls, {

            init : function() {

                var thisSCENE = this;

                demo.atmosphere.bright(thisSCENE);

                var sky = demo.object.sky(9000, demo.material.silver);
                sky.name = 'sky';
                //thisSCENE.add(sky);

                var balls = demo.object.balls(6000, 1000, 200);
                balls.name = 'balls';
                thisSCENE.add(balls);

                var obj = demo.object.spikerball;
                obj.material = demo.material.energie;
                obj.scale.x = obj.scale.y = obj.scale.z = 220;
                obj.castShadow = true;
                obj.name = 'spikerball';
                obj.receiveShadow = false;
                thisSCENE.add(obj);

                demo.scene_loaded++;

            },

            timeline : [[1, {
                cam : [{
                    focus : 1.5,
                    aperture : 3,
                    maxblur : 0.06,
                    fov : 175,
                    position : demo.motion.camera.antenna.pos,
                    lookat : demo.motion.camera.antenna.lookat
                }]
            }], [1000, {
                cam : [{
                    focus : 1.1,
                    aperture : 2.5,
                    maxblur : 0.03,
                    fov : 125
                }]
            }], [3000, {
                cam : [{
                    focus : 1,
                    aperture : 1,
                    maxblur : 0.01,
                    fov : 95
                }]
            }], [400000, {
                cam : [{}],
                obj : {}
            }]],

            animate : function() {

                var thisSCENE = this;

                //demo.motion.camera.basic(thisSCENE, 'main');
                demo.motion.object.rot(thisSCENE, 'balls');
                demo.motion.object.rot(thisSCENE, 'spikerball');

                //demo.camera.main.position.x = Math.sin(time * 15) * 260;
                //demo.camera.main.position.y = Math.sin(time * 4) * 370;
                //demo.camera.main.position.z = 1000 + Math.sin(time * 3) * 220;
            }
        });
    }

    if (demo.scene.boxcube) {

        $.extend(demo.scene.boxcube, {

            init : function() {

                var thisSCENE = this;

                demo.atmosphere.intube(thisSCENE);

                var sky = demo.object.sky(3000, demo.material.sky);
                sky.name = 'sky';
                thisSCENE.add(sky);

                var obj = demo.object.star2;
                obj.material = demo.material.silver;
                obj.scale.x = obj.scale.y = obj.scale.z = 25;
                obj.position.set(0, 0, 1000);
                obj.castShadow = true;
                obj.receiveShadow = true;
                thisSCENE.add(obj);

                var cubes = 200;
                var size = 150;
                var posZ = 0;

                for ( i = 0; i < cubes; i++) {

                    if (i % 5 == 0) {
                        var cube = new THREE.Mesh(new THREE.CubeGeometry(size, size * 5, size * 4, 1, 1, 1, false, true), demo.material.broken_mirror);
                        cube.name = 'cube-action' + i;
                    } else {
                        var cube = new THREE.Mesh(new THREE.CubeGeometry(size, size, size * 4, 1, 1, 1, false, true), demo.material.silver);
                        cube.name = 'cube' + i;
                    }

                    if (i > 20)
                        posZ = posZ - 20;

                    cube.position.x = Math.sin(i) * size * 5;
                    cube.position.y = Math.cos(i) * size * 5;
                    cube.position.z = 1500 + posZ;
                    cube.rotation.z = i;
                    cube.castShadow = true;
                    cube.receiveShadow = true;

                    thisSCENE.add(cube);

                }

                demo.scene_loaded++;

            },

            animate : function() {

                var thisSCENE = this;

                demo.motion.camera.intube(thisSCENE, 'main');

            }
        });
    }

    if (demo.scene.windows) {

        $.extend(demo.scene.windows, {

            init : function() {

                var thisSCENE = this;
                demo.atmosphere.basic(thisSCENE);

                var row_count = 10;
                var cubes = row_count * row_count;
                var size = 100;
                var row = 0;
                var last = [];
                var gap = 8;
                var segmens = 10;
                last['x'] = 0;

                side1 = new THREE.Object3D();

                for ( i = 0; i < cubes; i++) {

                    if (i % row_count == 0) {
                        row++;
                        last['x'] = 0;
                    }

                    if (row % 2 == 0) {
                        var cube = new THREE.Mesh(new THREE.CubeGeometry(size * 3, size, size, segmens, segmens, segmens, false, false), demo.material.building_glass);
                        cube.name = 'building-glass' + i;
                        cube.doubleSided = true;
                    } else {
                        var cube = new THREE.Mesh(new THREE.CubeGeometry(size * 3, size + (size / 3), size, segmens, segmens, segmens, false, false), demo.material.building_column);
                        cube.name = 'building-column' + i;
                        cube.doubleSided = false;

                    }

                    cube.position.x = last['x'];
                    last['x'] = cube.position.x + size * 3 + gap;
                    cube.position.y = 0;
                    cube.position.z = row * (size + gap);
                    side1.add(cube);

                }
                side1.updateMatrix();
                side1.rotation.z = 1;
                thisSCENE.add(side1);

                demo.scene_loaded++;

            },

            animate : function() {

                var thisSCENE = this;
                //demo.motion.camera.basic(thisSCENE, 'main');

            }
        });
    }
    if (demo.scene.end) {

        $.extend(demo.scene.end, {

            init : function() {
                demo.scene_loaded++;
            },

            animate : function() {

                var thisSCENE = this;

                if (!this.endscreen) {

                    $('body').html('<div id="overlay"></div>');

                    $("#overlay").css({
                        height : window.innerHeight,
                        width : window.innerWidth,
                        opacity : 0
                    }).show().animate({
                        opacity : 1
                    }, 2000);

                    this.endscreen = true;

                }

            },

            timeline : [[1, {
                cam : [{
                    position : [0, 0, 2000],
                    rotation : [0, 0, 0]

                }]
            }]]

        });
    }

});

