/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap.impl;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.DetailImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.FaultElementImpl;
import com.sun.xml.internal.messaging.saaj.soap.name.NameImpl;
import java.util.Locale;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPFaultElement;
import org.w3c.dom.Element;

public abstract class FaultImpl
extends ElementImpl
implements SOAPFault {
    protected SOAPFaultElement faultStringElement;
    protected SOAPFaultElement faultActorElement;
    protected SOAPFaultElement faultCodeElement;
    protected Detail detail;

    protected FaultImpl(SOAPDocumentImpl sOAPDocumentImpl, NameImpl nameImpl) {
        super(sOAPDocumentImpl, nameImpl);
    }

    protected abstract NameImpl getDetailName();

    protected abstract NameImpl getFaultCodeName();

    protected abstract NameImpl getFaultStringName();

    protected abstract NameImpl getFaultActorName();

    protected abstract DetailImpl createDetail();

    protected abstract FaultElementImpl createSOAPFaultElement(String var1);

    protected abstract FaultElementImpl createSOAPFaultElement(QName var1);

    protected abstract FaultElementImpl createSOAPFaultElement(Name var1);

    protected abstract void checkIfStandardFaultCode(String var1, String var2) throws SOAPException;

    protected abstract void finallySetFaultCode(String var1) throws SOAPException;

    protected abstract boolean isStandardFaultElement(String var1);

    protected abstract QName getDefaultFaultCode();

    protected void findFaultCodeElement() {
        this.faultCodeElement = (SOAPFaultElement)this.findChild(this.getFaultCodeName());
    }

    protected void findFaultActorElement() {
        this.faultActorElement = (SOAPFaultElement)this.findChild(this.getFaultActorName());
    }

    protected void findFaultStringElement() {
        this.faultStringElement = (SOAPFaultElement)this.findChild(this.getFaultStringName());
    }

    public void setFaultCode(String string) throws SOAPException {
        this.setFaultCode(NameImpl.getLocalNameFromTagName(string), NameImpl.getPrefixFromTagName(string), null);
    }

    public void setFaultCode(String string, String string2, String string3) throws SOAPException {
        if (string2 == null || string2.equals("")) {
            if (string3 == null || string3.equals("")) {
                log.severe("SAAJ0140.impl.no.ns.URI");
                throw new SOAPExceptionImpl("No NamespaceURI, SOAP requires faultcode content to be a QName");
            }
            string2 = this.getNamespacePrefix(string3);
            if (string2 == null || string2.equals("")) {
                string2 = "ns0";
            }
        }
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        if (this.faultCodeElement == null) {
            this.faultCodeElement = this.addFaultCodeElement();
        } else {
            this.faultCodeElement.removeContents();
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.faultCodeElement.getNamespaceURI(string2);
        }
        if (string3 == null || string3.equals("")) {
            log.severe("SAAJ0140.impl.no.ns.URI");
            throw new SOAPExceptionImpl("No NamespaceURI, SOAP requires faultcode content to be a QName");
        }
        this.checkIfStandardFaultCode(string, string3);
        ((FaultElementImpl)this.faultCodeElement).ensureNamespaceIsDeclared(string2, string3);
        this.finallySetFaultCode(string2 + ":" + string);
    }

    public void setFaultCode(Name name) throws SOAPException {
        this.setFaultCode(name.getLocalName(), name.getPrefix(), name.getURI());
    }

    public void setFaultCode(QName qName) throws SOAPException {
        this.setFaultCode(qName.getLocalPart(), qName.getPrefix(), qName.getNamespaceURI());
    }

    protected static QName convertCodeToQName(String string, SOAPElement sOAPElement) {
        int n = string.indexOf(58);
        if (n == -1) {
            return new QName(string);
        }
        String string2 = string.substring(0, n);
        String string3 = ((ElementImpl)sOAPElement).lookupNamespaceURI(string2);
        return new QName(string3, FaultImpl.getLocalPart(string), string2);
    }

    protected void initializeDetail() {
        NameImpl nameImpl = this.getDetailName();
        this.detail = (Detail)this.findChild(nameImpl);
    }

    public Detail getDetail() {
        if (this.detail == null) {
            this.initializeDetail();
        }
        if (this.detail != null && this.detail.getParentNode() == null) {
            this.detail = null;
        }
        return this.detail;
    }

    public Detail addDetail() throws SOAPException {
        if (this.detail == null) {
            this.initializeDetail();
        }
        if (this.detail == null) {
            this.detail = this.createDetail();
            this.addNode(this.detail);
            return this.detail;
        }
        throw new SOAPExceptionImpl("Error: Detail already exists");
    }

    public boolean hasDetail() {
        return this.getDetail() != null;
    }

    public void setFaultActor(String string) throws SOAPException {
        if (this.faultActorElement == null) {
            this.findFaultActorElement();
        }
        if (this.faultActorElement != null) {
            this.faultActorElement.detachNode();
        }
        if (string == null) {
            return;
        }
        this.faultActorElement = this.addSOAPFaultElement(this.getFaultActorName().getLocalName());
        this.faultActorElement.addTextNode(string);
    }

    public String getFaultActor() {
        if (this.faultActorElement == null) {
            this.findFaultActorElement();
        }
        if (this.faultActorElement != null) {
            return this.faultActorElement.getValue();
        }
        return null;
    }

    public SOAPElement setElementQName(QName qName) throws SOAPException {
        log.log(Level.SEVERE, "SAAJ0146.impl.invalid.name.change.requested", new Object[]{this.elementQName.getLocalPart(), qName.getLocalPart()});
        throw new SOAPException("Cannot change name for " + this.elementQName.getLocalPart() + " to " + qName.getLocalPart());
    }

    protected SOAPElement convertToSoapElement(Element element) {
        String string;
        if (element instanceof SOAPFaultElement) {
            return (SOAPElement)element;
        }
        if (element instanceof SOAPElement) {
            SOAPElement sOAPElement = (SOAPElement)element;
            if (this.getDetailName().equals(sOAPElement.getElementName())) {
                return FaultImpl.replaceElementWithSOAPElement(element, this.createDetail());
            }
            String string2 = sOAPElement.getElementName().getLocalName();
            if (this.isStandardFaultElement(string2)) {
                return FaultImpl.replaceElementWithSOAPElement(element, this.createSOAPFaultElement(sOAPElement.getElementQName()));
            }
            return sOAPElement;
        }
        Name name = NameImpl.copyElementName(element);
        ElementImpl elementImpl = this.getDetailName().equals(name) ? this.createDetail() : (this.isStandardFaultElement(string = name.getLocalName()) ? this.createSOAPFaultElement(name) : (ElementImpl)this.createElement(name));
        return FaultImpl.replaceElementWithSOAPElement(element, elementImpl);
    }

    private SOAPFaultElement addFaultCodeElement() throws SOAPException {
        if (this.faultCodeElement == null) {
            this.findFaultCodeElement();
        }
        if (this.faultCodeElement == null) {
            this.faultCodeElement = this.addSOAPFaultElement(this.getFaultCodeName().getLocalName());
            return this.faultCodeElement;
        }
        throw new SOAPExceptionImpl("Error: Faultcode already exists");
    }

    private SOAPFaultElement addFaultStringElement() throws SOAPException {
        if (this.faultStringElement == null) {
            this.findFaultStringElement();
        }
        if (this.faultStringElement == null) {
            this.faultStringElement = this.addSOAPFaultElement(this.getFaultStringName().getLocalName());
            return this.faultStringElement;
        }
        throw new SOAPExceptionImpl("Error: Faultstring already exists");
    }

    private SOAPFaultElement addFaultActorElement() throws SOAPException {
        if (this.faultActorElement == null) {
            this.findFaultActorElement();
        }
        if (this.faultActorElement == null) {
            this.faultActorElement = this.addSOAPFaultElement(this.getFaultActorName().getLocalName());
            return this.faultActorElement;
        }
        throw new SOAPExceptionImpl("Error: Faultactor already exists");
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        if (this.getDetailName().equals(name)) {
            return this.addDetail();
        }
        if (this.getFaultCodeName().equals(name)) {
            return this.addFaultCodeElement();
        }
        if (this.getFaultStringName().equals(name)) {
            return this.addFaultStringElement();
        }
        if (this.getFaultActorName().equals(name)) {
            return this.addFaultActorElement();
        }
        return super.addElement(name);
    }

    protected SOAPElement addElement(QName qName) throws SOAPException {
        return this.addElement(NameImpl.convertToName(qName));
    }

    protected FaultElementImpl addSOAPFaultElement(String string) throws SOAPException {
        FaultElementImpl faultElementImpl = this.createSOAPFaultElement(string);
        this.addNode(faultElementImpl);
        return faultElementImpl;
    }

    protected static Locale xmlLangToLocale(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("-");
        if (n == -1) {
            n = string.indexOf("_");
        }
        if (n == -1) {
            return new Locale(string, "");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return new Locale(string2, string3);
    }

    protected static String localeToXmlLang(Locale locale) {
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (!"".equals(string2)) {
            string = string + "-" + string2;
        }
        return string;
    }
}

