uniform sampler2D Tex;
uniform sampler2D TexNormal;

varying vec3 Pos;
varying vec2 Uv;
varying vec4 Color;

varying vec3 Btnx;
varying vec3 Btny;
varying vec3 Btnz;

void main()
{
	vec3 e = normalize(-Pos);
	vec3 l = e;
	vec3 tmp = texture2D(TexNormal, Uv).xyz * 2.0 - 1.0;
	tmp.xy *= .5;
	vec3 n = normalize(vec3(dot(Btnx, tmp), dot(Btny, tmp), dot(Btnz, tmp)));
	vec3 r = reflect(normalize(Pos - l), n);
	float diffuse = max(dot(n, l), 0.1) * .9;
	float specular = pow(max(dot(r, e), 0.0), 85.0) * .3;

	gl_FragData[0] = Color * (texture2D(Tex, Uv) * diffuse + specular);
}