
float4x4 g_mWorldViewProjection;
float4x4 g_mView;
float4x4 g_mWorld;

float g_luminosity;
float g_whiteness;

float g_windowWidth;
float g_windowHeight;

float2 g_texCoordScale;
float2 g_texCoordOfs;

float4 g_color;


float g_defHeight;
float g_defBumpness;
float g_depthClipMul;


struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
    float  Depth  : DEPTH;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
    float4  vTangent : TEXCOORD2;
    float4  vBiTangent : TEXCOORD3;
    float  Depth  : TEXCOORD4;
};


VS_OUTPUT vs_float_to_onezero( const VS_INPUT v ) {
  VS_OUTPUT o = (VS_OUTPUT)o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = ((v.vTexcoord)*correcter+float2(1.0/g_windowWidth, 1.0/g_windowHeight))*g_texCoordScale+g_texCoordOfs; 
//  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*0.50*correcter;
  
  float2 res = float2(32.0, 32.0);
 
  
  float3 normalResult;
  normalResult = mul(float3(1.0, 0.0, 0.0), (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  o.vTangent *= 1.0/res.x;
  
  normalResult = mul(float3(0.0, 1.0, 0.0), (float3x3)(g_mWorld));
  o.vBiTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  o.vBiTangent *= 1.0/res.y;
  
  o.Depth = v.Depth;
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};


struct PS_OUT_DEF {
  float4 rt0 : COLOR0; // depth
  float4 rt1 : COLOR1; // normal
  float4 rt2 : COLOR2; // diffuse
  float4 rt3 : COLOR3; // ambspec
  float  Depth  : DEPTH;
};


texture tex0;
texture tex1;

sampler sm =
sampler_state {
  Texture = <tex0>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = MIRROR;
  AddressV = MIRROR;
};

sampler smHeight =
sampler_state {
  Texture = <tex1>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = MIRROR;
  AddressV = MIRROR;
};


PS_OUT ps_particle( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
 
  result += tex2D(sm, In.vTexcoord);
  result = clamp(result*1.0, 0.0, 100000.0)*g_color;
   
  o.rt0 = result;
  return o;
}

PS_OUT_DEF ps_particle_deferred( VS_OUTPUT In ) {

 
  float depthaa = tex2D(smHeight, In.vTexcoord).g;

 // 

 // float depthiForZ = (In.vPosSS.z-depthaa) / In.vPosSS.w;  
  float depthi = (In.vPosSS.z-depthaa*g_defHeight) / In.vPosSS.w;
  
  if (In.Depth > depthi)
    discard;

  float4 kukkers = depthaa*g_color*g_depthClipMul;
  if ((kukkers.a) < (1.0-kukkers.g)*1.0 || kukkers.a < 0.01)
    discard;
    
	
  PS_OUT_DEF o = (PS_OUT_DEF)0;
  float4 result = 0;
	
  result = tex2D(sm, In.vTexcoord)*g_color;
	
    
  result = clamp(result, 0.0, 100000.0);
   
  // diffuse 
  result.a = 1.0;
  o.rt2 = result;
  
    
  // normal
  float4 bumpe = 0;
  
 
  bumpe.x = (tex2D(smHeight, In.vTexcoord+float2(In.vTangent.x, In.vTangent.y)).g - tex2D(smHeight, In.vTexcoord-float2(In.vTangent.x, In.vTangent.y)).g)*(-0.667);
  bumpe.y = (tex2D(smHeight, In.vTexcoord+float2(In.vBiTangent.x, In.vBiTangent.y)).g - tex2D(smHeight, In.vTexcoord-float2(In.vBiTangent.x, In.vBiTangent.y)).g)*(1.0);
  bumpe = bumpe*g_defBumpness;
  bumpe.z = -g_defHeight;
  bumpe = (normalize(bumpe)+1.0)*0.5;
      
  o.rt1 = float4(bumpe.x, bumpe.y, bumpe.z, 0.0);  

  o.Depth = depthi;
  
  // depth
  o.rt0 = depthi;  
    
  o.rt3.x = 0.0f;
  o.rt3.y = 0.5f;
  
  return o;
}


technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_particle( );
    }
}

technique RenderDeferred {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_particle_deferred( );
    }
}




