
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float g_time;


struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
 
  return o;
}

struct PS_OUT {
  float4 rt0 : COLOR0; 
};

texture g_tDiffuse;

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

float rnd(float2 co){
  return 1.0*(frac(sin(dot(co.xy ,float2(12.9898,78.233))) * 43758.5453));
}

float g_amount = 1.0;
float4 g_color;

PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;

  float4 r = tex2D(smDiffuse, In.vTexcoord) + g_color*g_amount*rnd(In.vTexcoord+g_amount*float2(g_time,0.0));
  o.rt0 = r;
  return o;
}

technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs();
        PixelShader  = compile ps_3_0 ps();
    }
}

