
float g_time;

float4x4 g_mWorld;                  // World matrix for object
float4x4 g_mView;
// float4x4 g_mProj;
float4x4 g_mWorldViewProjection;    // World * View * Projection matrix

float4 g_texCoordScale;
float4 g_texCoordOfs;

float4 g_materialDiffuse;

float g_materialAmbient;

float g_diffuseIntensity;
float g_heightIntensity;
float g_specularIntensity;
float g_specularExponent;

float4 g_diffuseTexCoordScale;
float4 g_diffuseTexCoordOfs;

float4 g_heightTexCoordScale;
float4 g_heightTexCoordOfs;

float4 g_specularTexCoordScale;
float4 g_specularTexCoordOfs;


float g_windowWidth;
float g_windowHeight;


texture tex0;
texture tex1;
texture tex2;

sampler smDiffuse =
sampler_state {
  Texture = <tex0>;
  MipFilter = LINEAR; // ANISOTROPIC
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smHeight =
sampler_state {
  Texture = <tex1>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smSpecular =
sampler_state {
  Texture = <tex2>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};


struct VS_INPUT {
    float4 vPosition : POSITION;
    float3 vNormal : NORMAL;
    float2 vTexcoord : TEXCOORD0;
    float4 vWHI : TEXCOORD1;
    float3 vTangent : TANGENT;
    float3 vBiNormal : BINORMAL;
};

struct VS_OUTPUT_BASIC {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vNormal : TEXCOORD1;
    float4  vPosSS : TEXCOORD2;
    float4  vTangent : TEXCOORD3;
    float4  vBiNormal : TEXCOORD4;
    float4  vTexcoordHS : TEXCOORD5;
};


VS_OUTPUT_BASIC vs_deferred_draw( const VS_INPUT v ) {
  VS_OUTPUT_BASIC o;
  
  float4 vPosTrans = v.vPosition;
  
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  o.vNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
  o.vTexcoord = v.vTexcoord*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = v.vTexcoord*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = v.vTexcoord*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}


#include "mrt_deferred_bump.h"

#include "mrt_deferred_background.h"
#include "mrt_deferred_depth.h"
#include "mrt_deferred_march.h"
#include "mrt_deferred_march_diffuse.h"

#include "mrt_deferred_move.h"