
float4x4 g_mWorldViewProjection;    

float g_luminosity;
float g_whiteness;

float g_windowWidth;
float g_windowHeight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs_aa( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  float2 correcter = float2((g_windowWidth+0.1)/g_windowWidth, (g_windowHeight+0.1)/g_windowHeight);
  o.vTexcoord = float2(0.5/g_windowWidth, 0.2/g_windowHeight)+(v.vTexcoord)*correcter; 
//  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*0.50*correcter;
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;
texture g_tDiffuseOrig;

sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = CLAMP;
  AddressV = CLAMP;
};


sampler smDiffuseOrig =
sampler_state {
  Texture = <g_tDiffuseOrig>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = MIRROR;
  AddressV = MIRROR;
};


float g_glowBaseAngle; // 0.7
float g_glowCurrentDispTexCoordMul; // 0.2
float g_glowAngleTexCoordMul; // 2.0

float4 g_glowCurrentDisp; // 0.0, 2.0, 0.0, 0.0
float4 g_glowSize;

float g_glowMulFactor;


float rand(float2 co){
  return 0.5+(frac(sin(dot(co.xy ,float2(12.9898,78.233))) * 43758.5453))*0.5;
}


PS_OUT ps_blur_cross( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float2 d = g_glowSize;
  
  float4 current = tex2D(smDiffuseOrig, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5));
  
  float angle = dot(current, g_glowCurrentDisp)+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  
  float2 sc = float2(sin(0.0+angle), cos(0.0+angle));
  float2 scm = float2(sin(-1.57+angle), cos(-1.57+angle));
  
  float2 vx = float2(d.x*sc.y, d.x*sc.x);
  float2 vy = float2(-d.y*sc.x, d.y*sc.y);
  
  result += tex2D(smDiffuse, In.vTexcoord+vy);
  result += tex2D(smDiffuse, In.vTexcoord-vy);
  result += tex2D(smDiffuse, In.vTexcoord+vx);
  result += tex2D(smDiffuse, In.vTexcoord-vx);
  
  vx = float2(d.x*scm.y, d.x*scm.x);
  vy = float2(-d.y*scm.x, d.y*scm.y);
  
  result += tex2D(smDiffuse, In.vTexcoord+vy);
  result += tex2D(smDiffuse, In.vTexcoord-vy);
  result += tex2D(smDiffuse, In.vTexcoord+vx);
  result += tex2D(smDiffuse, In.vTexcoord-vx);
  
  
  result *= 0.125;
  
  o.rt0 = result;
  return o;
}


PS_OUT ps_blur_stream( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float2 d = g_glowSize;
  
  float4 current = tex2D(smDiffuseOrig, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5));
  
  float angleR = current.r*g_glowCurrentDisp.r+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  float angleG = current.g*g_glowCurrentDisp.g+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  float angleB = current.b*g_glowCurrentDisp.b+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  
  float2 scR = float2(sin(0.0+angleR), cos(0.0+angleR));
  float2 scG = float2(sin(0.0+angleG), cos(0.0+angleG));
  float2 scB = float2(sin(0.0+angleB), cos(0.0+angleB));
    
  float2 vx = float2(d.x*scR.y, d.x*scR.x);
  float2 vy = float2(-d.y*scR.x, d.y*scR.y);
  
  result += tex2D(smDiffuse, In.vTexcoord+vy).r;
  result += tex2D(smDiffuse, In.vTexcoord-vy).r;
  result += tex2D(smDiffuse, In.vTexcoord+vx).r;
  result += tex2D(smDiffuse, In.vTexcoord-vx).r;
    
  vx = float2(d.x*scG.y, d.x*scG.x);
  vy = float2(-d.y*scG.x, d.y*scG.y);
  result += tex2D(smDiffuse, In.vTexcoord+vy).g;
  result += tex2D(smDiffuse, In.vTexcoord-vy).g;
  result += tex2D(smDiffuse, In.vTexcoord+vx).g;
  result += tex2D(smDiffuse, In.vTexcoord-vx).g;
  
  vx = float2(d.x*scB.y, d.x*scB.x);
  vy = float2(-d.y*scB.x, d.y*scB.y);
  result += tex2D(smDiffuse, In.vTexcoord+vy).b;
  result += tex2D(smDiffuse, In.vTexcoord-vy).b;
  result += tex2D(smDiffuse, In.vTexcoord+vx).b;
  result += tex2D(smDiffuse, In.vTexcoord-vx).b;
  

  result *= 0.125*g_glowMulFactor;
  
  o.rt0 = result;
  return o;
}


PS_OUT ps_blur_box( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float2 d = g_glowSize;
  
  float4 current = tex2D(smDiffuseOrig, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5));
  
  float angle = dot(current, g_glowCurrentDisp)+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  
  float2 sc = float2(sin(angle), cos(angle));
  
  float2 vx = float2(d.x*sc.y, d.x*sc.x);
  float2 vy = float2(-d.y*sc.x, d.y*sc.y);

  result += tex2D(smDiffuse, In.vTexcoord+vy*1.0);
  result += tex2D(smDiffuse, In.vTexcoord-vy*1.0);
  result += tex2D(smDiffuse, In.vTexcoord+vx*1.0);
  result += tex2D(smDiffuse, In.vTexcoord-vx*1.0);

  result *= 0.25;
  
  o.rt0 = result;
  return o;
}



PS_OUT ps_blur_line( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  half2 d = g_glowSize;
  
  half4 current = tex2D(smDiffuseOrig, (In.vTexcoord-float2(0.5, 0.5))*g_glowCurrentDispTexCoordMul+float2(0.5, 0.5));
  
  half angle = dot(current, g_glowCurrentDisp)+g_glowBaseAngle+(In.vTexcoord-float2(0.5, 0.5))*g_glowAngleTexCoordMul;
  
  half2 sc = half2(sin(0.0+angle), cos(0.0+angle));
  
  half2 vx = half2(d.x*sc.y, d.x*sc.x);
  
  result += tex2D(smDiffuse, In.vTexcoord+vx);
  result += tex2D(smDiffuse, In.vTexcoord-vx);
    
  result *= 0.5;
  
  result *= 0.0+1.0*rand(In.vTexcoord).x;
  
  o.rt0 = result;
  return o;
}

PS_OUT ps_blur_god_rays( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float2 d = g_glowSize;
  

  result += tex2D(smDiffuse, In.vTexcoord*(d+1.0)+float2(-d.x, -d.y));
  result += tex2D(smDiffuse, In.vTexcoord*(d+1.0)+float2(d.x, -d.y));
  result += tex2D(smDiffuse, In.vTexcoord*(d+1.0)+float2(-d.x, d.y));
  result += tex2D(smDiffuse, In.vTexcoord*(d+1.0)+float2(d.x, d.y));

  result *= 0.25;
  
  o.rt0 = result;
  return o;
}




float g_glowExponent;
float g_glowLowLimit;
float g_glowPreMul;

PS_OUT ps_plain( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = clamp((tex2D(smDiffuse, In.vTexcoord)-g_glowLowLimit)*g_glowPreMul, 0.0, 10000.0);
  colorIn = pow(colorIn, g_glowExponent);
  o.rt0 = clamp(colorIn, 0.0, 10000.0);
  return o;
}

PS_OUT ps_blit( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord);
  o.rt0 = colorIn;
  return o;
}



float4 g_glowColor;

PS_OUT ps_glow_mix( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord);
  colorIn = colorIn*g_glowColor;
 // colorIn = colorIn*colorIn;
  o.rt0 = clamp(colorIn, 0.0, 10000.0);
  return o;
}




technique RenderBlurCross {
    pass P0 {          
        VertexShader = compile vs_2_a vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_cross( );
    }
}


technique RenderBlurGodRays {
    pass P0 {          
        VertexShader = compile vs_2_a vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_god_rays( );
    }
}



technique RenderBlurStream {
    pass P0 {          
        VertexShader = compile vs_2_a vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_stream( );
    }
}


technique RenderBlurBox {
    pass P0 {          
        VertexShader = compile vs_2_a vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_box( );
    }
}

technique RenderBlurLine {
    pass P0 {          
        VertexShader = compile vs_2_a vs_aa( );
        PixelShader  = compile ps_3_0 ps_blur_line( );
    }
}


technique RenderPlain {
    pass P0 {          
        VertexShader = compile vs_2_a vs_aa( );
        PixelShader  = compile ps_3_0 ps_plain( );
    }
}


technique RenderBlit {
    pass P0 {          
        VertexShader = compile vs_2_a vs_aa( );
        PixelShader  = compile ps_3_0 ps_blit( );
    }
}


technique RenderGlowMix {
    pass P0 {          
        VertexShader = compile vs_2_a vs_aa( );
        PixelShader  = compile ps_3_0 ps_glow_mix( );
    }
}





