

float4x4 g_mWorldViewProjection;    
float4x4 g_mView;    


float hdr_gamma = 1.0;

float hdr_ca = 1.0;
float hdr_cb = 0.4;


float zFar = 10000.0;
float zNear = 1.0;

float g_windowWidth;
float g_windowHeight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};



struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
    float2  vTexcoordActual : TEXCOORD2;
};


VS_OUTPUT vs_deferred_mixer( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
 // o.vPosition =v.vPosition;
  o.vPosSS = o.vPosition;
 // o.vTexcoord = v.vTexcoord;
 
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*0.50*correcter;
   
  
  o.vTexcoordActual = v.vTexcoord;
  
  return o;
}

VS_OUTPUT vs_deferred_mixer_ao( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*(0.5)*correcter;
//  o.vTexcoord = v.vTexcoord;
//  o.vTexcoord = v.vTexcoord+float2(0.250/g_windowWidth, 0.50/g_windowHeight);
//  o.vTexcoord = (0.9999-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*(0.5);
  
//  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
//  o.vTexcoord = v.vTexcoord*correcter;
 
  
  o.vTexcoordActual = v.vTexcoord;

  return o;
}


VS_OUTPUT vs_deferred_mixer_ambient( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*(0.5)*correcter;
 // o.vTexcoord = v.vTexcoord;
 // o.vTexcoord = v.vTexcoord+float2(1.0/g_windowWidth, 1.0/g_windowHeight);
 
 // o.vTexcoord = v.vTexcoord*correcter+float2(-1.0/g_windowWidth, -1.0/g_windowHeight);
 
  o.vTexcoordActual = v.vTexcoord;

  return o;
}


VS_OUTPUT vs_blur_ao( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  float2 correcter = float2((g_windowWidth-1)/(g_windowWidth), (g_windowHeight-1)/(g_windowHeight));
 // o.vTexcoord = v.vTexcoord+float2(1.0/g_windowWidth, 1.0/g_windowHeight);
  o.vTexcoord = (1.0-float2(-o.vPosition.x-2.0/g_windowWidth, o.vPosition.y-2.0/g_windowHeight))*(0.5)*correcter;
 // o.vTexcoord = v.vTexcoord*correcter;
   
  o.vTexcoordActual = (1.0-float2(-o.vPosition.x-2.0/g_windowWidth, o.vPosition.y-2.0/g_windowHeight))*(0.5)*correcter;

  return o;
}


float g_ambience = 0.25;
float g_ambience_att = 200.0;
float g_ao_darkness = 2.0;
float g_ao_whiteness = 1.0;
float g_ao_area = 10.0;
float g_ao_pow = 1.0;




texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;
texture g_tNoise;
texture g_tAO;
texture g_tAmbSpec;


sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNoise =
sampler_state {
  Texture = <g_tNoise>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smAO =
sampler_state {
  Texture = <g_tAO>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smAmbSpec =
sampler_state {
  Texture = <g_tAmbSpec>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};



struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

float4 g_lightPos;
float4 g_lightColor;
float g_lightInvDistance;

float g_lightBallSharpness;
float g_lightBallSize;


PS_OUT ps_deferred_mixer( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 lightResult = (float4)0;
  float4 result = (float4)0.0;

  float4 lightViewPos;
   
  float4 depthV = tex2D(smDepth, In.vTexcoord);

  if (depthV.r > 0.9999) {
    lightResult.a = 1.0;
    lightResult.r = 1.0;
    o.rt0 = lightResult;
    return o;
  }

  
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  float pointDist = clipB/(depthV.r-clipA);
  
  float pointDist2 = pointDist*pointDist;
  float4 pointV = float4(In.vPosSS.x*g_windowWidth/g_windowHeight, In.vPosSS.y, 1.0, 0.0)*pointDist;
  
  float4 pointVN = normalize(pointV);
    
  // render lightball
  
  lightViewPos = mul(g_lightPos, g_mView);
  
  float lightDist2 = dot(lightViewPos, lightViewPos);
  if (lightViewPos.z > 0.0) {
	  float dotta = dot(lightViewPos, pointVN);
	  float4 vd = lightViewPos-dotta*pointVN;
	  float vdLen2 = pow(dot(vd, vd), g_lightBallSharpness);
	  dotta = g_lightBallSize/(vdLen2*2.0+1.0);
	  dotta = clamp(dotta-0.02, 0.0, 1000.0);
// put this to see light box	  
//	  dotta += 0.1;
	  float softArea = 1000.0+100.0*vdLen2;
	  if (pointDist2 > lightDist2) {
		lightResult += dotta*g_lightColor;
		lightResult.a += dotta;
	  } else if (pointDist2 > lightDist2-softArea) {
		float softness = (pointDist2-(lightDist2-softArea))/softArea;
		lightResult += dotta*g_lightColor*softness;	  
		lightResult.a += dotta*softness;
	  }	
  }   

  float2 texus = (In.vTexcoordActual-0.5)*2.0;
  float lightCover = clamp((3.0-dot(texus, texus)*3.0)*1.0, 0.0, 1.0);
  
  lightResult *= lightCover;
  
  


  float4 ambSpec = tex2D(smAmbSpec, In.vTexcoord);
  float4 normalV = (tex2D(smNormal, In.vTexcoord)*2.0)-1.0;
  float4 diffuseV = tex2D(smDiffuse, In.vTexcoord);
  
  diffuseV *= diffuseV;  
 // diffuseV = sqrt(diffuseV);
  
  // diffuseV = exp(diffuseV/hdr_cb)/hdr_ca;
  // diffuseV*=0.95;
  // diffuseV = sqrt(diffuseV/(hdr_gamma-hdr_gamma*diffuseV));
  
    
  // for (int i=0; i<g_num_lights; i++) {
    
    lightViewPos = mul(g_lightPos, g_mView);

	float4 lightToPoint = lightViewPos-pointV;
	float lightToPointDist2 = dot(lightToPoint, lightToPoint);

    float4 ambienssi = tex2D(smAO, In.vTexcoord);
    ambienssi = pow(clamp(ambienssi, 0.0, 1.0), g_ao_pow);
    
     ambienssi *=ambienssi;
    
    // ambienssi.r *= .0;


//	 if (lightToPointDist2 < 10000.0) { 	
      float lightToPointDist = sqrt(lightToPointDist2);
	  float normalLightDot = dot(normalV, lightToPoint/(lightToPointDist+1.0));
	  normalLightDot = clamp(normalLightDot, 0.0, 100.0);
	  normalLightDot = pow(normalLightDot, 1.0)*256.0/(lightToPointDist2*2.0*g_lightInvDistance+1.0)-0.01;
	  normalLightDot = clamp(normalLightDot, 0.0, 10000.0)*lightCover;
	  result += (normalLightDot*g_lightColor*g_lightColor)*diffuseV*ambienssi;
	  
	  // specular reflection
	  float3 reflected = reflect(float3(lightToPoint.xyz), normalize(float3(normalV.xyz)));
	  float specularDot = dot(reflected, float3(pointVN.xyz))/(lightToPointDist+1.0);
	  specularDot = clamp(specularDot, 0.0, 1.0);
	  specularDot = pow(specularDot, 1.0f + ambSpec.y*128.0)*ambSpec.y*1024.0/(lightToPointDist2*0.50*g_lightInvDistance+1.0)-0.01;
	  specularDot = clamp(specularDot, 0.0, 10000.0)*lightCover*ambienssi;
	  result += specularDot*g_lightColor*g_lightColor*1.0;
	  
//	 }
 // }
 
  
 // result = pointV*0.2;
 // result += depthV.r;
 // result.z = 0.0;
 // result = (normalV+1.0)*0.5;
 // result = diffuseV;
 // result = pointV;

  result = sqrt(result);
// result *= result;
  
   result += lightResult;
  
  //result.a = 1.0;
 // result = 0.0;
 // result.a = 0.0; //diffuseV.w;
  result.a = diffuseV.w;

  
  o.rt0 = result;
  return o;
}



PS_OUT ps_deferred_mixer_ambient( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = (float4)0;

  float4 depthV = tex2D(smDepth, In.vTexcoord);

  if (depthV.r > 0.99999) {
   // result.a = 0.0;
   // o.rt0 = result;
   // return o;
    discard;
  }
 
  float4 diffuseV = tex2D(smDiffuse, In.vTexcoord);
  float4 ambSpec = tex2D(smAmbSpec, In.vTexcoord);


  if (diffuseV.a < 0.005)
    discard;
      
  
  float3 upVec = float4(0.0, 0.0, 1.0, 0.0);
  float3 normalV = (float3(tex2D(smNormal, In.vTexcoord).xyz)*2.0)-1.0;
  float3 upAmb = mul(upVec,(float3x3)(g_mView));
  
  float skaala = ((dot(normalV, upAmb)+1.0)*0.5)*0.50+0.50;
  float4 ambColor = skaala*float4(1.0, 1.0, 1.0, 1.0);
  
  
  float ambienssi = tex2D(smAO, In.vTexcoord+float2(1.50/g_windowWidth, 1.50/g_windowHeight));
//  ambienssi = clamp(((1.0-ambienssi)-0.5), 0.0, 0.5)*2.0;
//  ambienssi = clamp(((1.0-ambienssi)-0.75), 0.0, 0.25)*4.0;
    ambienssi = pow(clamp(1.0-ambienssi, 0.0, 1.0), g_ao_pow);
  
 //  ambienssi = g_ao_darkness*ambienssi;
 

  
 // ambienssi = 1.0/(1.0+g_ao_darkness*ambienssi);
  result = ambienssi*diffuseV*g_ambience*ambColor*(1.0-pow(depthV.r, g_ambience_att));
  result += diffuseV*ambSpec.x;
 // result = ambienssi*5.0;
    
  result.a = diffuseV.a;
  
  o.rt0 = result;
  return o;
}


float g_blurAmount;

float4 getPointV(float4 vPosSS, float depthV) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  float pointDist = clipB/(depthV-clipA);
  float4 pointV = float4(vPosSS.x*4.0/3.0, vPosSS.y, 1.0, 0.0)*pointDist;  
  return pointV;
}


PS_OUT ps_blur_ao_x( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = (float4)0;
  
  float2 p = In.vTexcoord;
  float2 pa = In.vTexcoordActual;
  
  float3 depthV = tex2D(smDepth, pa).xyz;
  
  if (depthV.r > 0.9999) {
    o.rt0 = 0.0;
    return o;
  }
     
  
  float4 tn = tex2D(smNormal, p);
  float3 normalV = (tn.xyz)*2.0-1.0;
  
  // float4 current = tex2D(smAO, p);

  float a = 0.0;
  float2 ko;
  float3 depthVP;
  float3 normalVP;
   
  float koke = g_blurAmount/(clamp((depthV.r-0.99)*100.0, 0.0, 1.0)*1.0+1.0);

//  float ker[5] = { 3.0, 2.0, 1.0, 2.0, 3.0 };
  float ker[3] = { 2.0, 1.0, 2.0 };

  float eroNorm;
  float kerR;
  
  for (int y=0; y<3; y++) {
    for (int x=0; x<3; x++) {
  	  ko = p+koke*float2((x-1.0), (y-1.0));
  //	  koa = p+koke*float2((x-1.0), (y-1.0));
  	  
  	  float4 texNorm = tex2D(smNormal, ko);

   //   if (texNorm.w < 0.5)
   //     continue;

      normalVP = (texNorm.xyz)*2.0-1.0;
   //     eroNorm = 0.0;
      eroNorm = (dot(normalV, normalVP)+1.0)*0.5;
      eroNorm = clamp(eroNorm-0.9, 0.0, 1.0);
      eroNorm = pow(eroNorm, 1.0)*2000.0;
	  depthVP = tex2D(smDepth, ko);
	  if (depthVP.r > 0.9999)
	    eroNorm = 0.0;
	  float ero = (depthV.r-depthVP.r)*100.0;
	  eroNorm *= 1.0-clamp(ero*ero*ero*ero, 0.0, 1.0);
 	
	  eroNorm *= ker[x]*ker[y];
	  	   
  	  result += tex2D(smAO, ko)*eroNorm;
    //  result += current*(1.0-eroNorm)*kerR;
  	  
	
      a += eroNorm;
	}
  }
 // result = 1.0-(depthV.r-0.99)*200.0; //result/(a)*1.0;
  result = result/(a);

  result.a = 1.0;
  
  o.rt0 = result;
  return o;
}


float rand(float2 co){
  return 0.5+(frac(sin(dot(co.xy ,float2(12.9898,78.233))) * 43758.5453))*0.5;
}

PS_OUT ps_deferred_mixer_ao( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = (float4)0;
  

  float4 depthV = tex2D(smDepth, In.vTexcoord);

  if (depthV.r > 0.99999999) {
    discard;
    result.rgb = 0.0;
    result.a = 0.0;
    o.rt0 = result;
    return o;
 //   discard;
  }
  
  int samples = 8;
  
  float3 pSphere[] = {

  /*
   float3(0.24710192, 0.6445882, 0.033550154),
   float3(0.00991752, -0.21947019, 0.7196721),
   float3(0.25109035, -0.1787317, -0.011580509),
   float3(-0.08781511, 0.44514698, 0.56647956),
   float3(-0.011737816, -0.0643377, 0.16030222),
   float3(0.035941467, 0.04990871, -0.46533614),  
   float3(-0.058801126, 0.7347013, -0.25399926),
   float3(-0.24799341, -0.022052078, -0.13399573),
  */
   float3(0.53812504, 0.18565957, -0.43192),
   float3(0.13790712, 0.24864247, 0.44301823),
   float3(0.33715037, 0.56794053, -0.005789503),
   float3(-0.6999805, -0.04511441, -0.0019965635),
   
   float3(0.06896307, -0.15983082, -0.85477847),
   float3(0.056099437, 0.006954967, -0.1843352),
   float3(-0.014653638, 0.14027752, 0.0762037),
   float3(0.010019933, -0.1924225, -0.034443386),
   /*
   float3(-0.35775623, -0.5301969, -0.43581226),
   float3(-0.3169221, 0.106360726, 0.015860917),
   float3(0.010350345, -0.58698344, 0.0046293875),
   float3(-0.08972908, -0.49408212, 0.3287904),
   float3(0.7119986, -0.0154690035, -0.09183723),
   float3(-0.053382345, 0.059675813, -0.5411899),
   float3(0.035267662, -0.063188605, 0.54602677),
   float3(-0.47761092, 0.2847911, -0.0271716)
 /* */
  };
  

  float ambienssi = 0.0;
  
  float4 noiseVT = tex2D(smNoise, (In.vTexcoord)*2.0);
//  float4 noiseVT = float4(rand(In.vTexcoord), rand(In.vTexcoord+1.0), rand(In.vTexcoord+2.0), rand(In.vTexcoord+3.0));
  float3 noiseV = (noiseVT.xyz);
//  float3 noiseV = float3(rand(In.vTexcoord), rand(In.vTexcoord*1.5+2.320), 1.0)-0.5;
     
  // ao
   
  float4 pointV = getPointV(In.vPosSS, depthV.r); 
  
  float3 ray;
  
  float3 normalV = (float3(tex2D(smNormal, In.vTexcoord).xyz)*2.0)-1.0;
  
  float radD = g_ao_area*(noiseVT.a*1.0+0.0); 
 // float radD = g_ao_area*(rand(In.vTexcoord)); 
  
  float invSamples = 1.0/samples;

  float2 rayTexC;
  
  float4 colSum=0;
    
  for (int i=0; i<samples; i++) {

      ray = float4(reflect(pSphere[i],noiseV), 0.0);
	  ray = ray*sign(dot(ray,normalV))*radD+pointV+normalV*0.10;
	    
	  rayTexC = ((float2(ray.x*3.0/4.0, -ray.y)/(ray.z-0.0))+1.0)*0.5;
      float4 depthRay = tex2D(smDepth, rayTexC);
 
	  float kukko = depthV.r - depthRay.r;
	  if (kukko > -0.1) {

		float dots = dot(normalV, (float3(tex2D(smNormal, rayTexC).xyz)*2.0)-1.0);
		float4 col = tex2D(smDiffuse, rayTexC);
		
		dots = clamp((0.9-dots)*1.0, 0.0, 10.0);
		if (depthRay.r > 0.99999999 || depthRay.r < 0.01)
		  dots=0.0;
		
		kukko = clamp(kukko*kukko*1000000.0, 0.0, 10000.0);
		float mount = 1.0*invSamples/(kukko*6.0+5.0)*dots;
		ambienssi += mount;
	//	colSum += col*(0.5+0.5*mount);		
		colSum += col; // *(0.5+0.5*mount);		
  	  }	 	  
    }
    
  ambienssi = clamp(ambienssi, 0.0, 1000.0)*g_ao_darkness; 
  
  result = 0.0+1.0*clamp(0.3*colSum, 0.0, 1.0)-clamp(ambienssi*(1.0+ambienssi/g_ao_whiteness)/(1.0+ambienssi), 0.0, 1.0);
 // result = 1.0-clamp(ambienssi*(1.0+ambienssi/g_ao_whiteness)/(1.0+ambienssi), 0.0, 1.0);
  // result *= 2.0*(colSum);
 // result = colSum*0.20;

  result.a = 1.0;
  
  o.rt0 = result;
  return o;
}




technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_mixer( );
        PixelShader  = compile ps_3_0 ps_deferred_mixer( );
    }
}


technique RenderAO {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_mixer_ao( );
        PixelShader  = compile ps_3_0 ps_deferred_mixer_ao( );
    }
}

technique BlurAOX {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_blur_ao( );
        PixelShader  = compile ps_3_0 ps_blur_ao_x( );
    }
}


technique MixAmbient {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_mixer_ambient( );
        PixelShader  = compile ps_3_0 ps_deferred_mixer_ambient( );
    }
}

