float4x4 g_mWorldViewProjection;    
float4x4 g_mView;    

float hdr_gamma = 1.0;
float hdr_ca = 1.0;
float hdr_cb = 0.4;

float zFar = 10000.0;
float zNear = 1.0;

float g_windowWidth;
float g_windowHeight;
float g_time;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
    float2  vTexcoordActual : TEXCOORD2;
};

VS_OUTPUT vs_deferred_mixer( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
 
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*0.50*correcter;
  o.vTexcoordActual = v.vTexcoord;
  
  return o;
}


float g_ambience = 0.25;
float g_ambience_att = 200.0;
float g_ao_darkness = 2.0;
float g_ao_whiteness = 1.0;
float g_ao_area = 10.0;
float g_ao_pow = 1.0;


texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;
texture g_tNoise;
texture g_tAO;
texture g_tAmbSpec;

texture g_tAmbienceMap;
texture g_tEnvMap;


sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smAO =
sampler_state {
  Texture = <g_tAO>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smAmbSpec =
sampler_state {
  Texture = <g_tAmbSpec>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

float4 g_lightPos;
float4 g_lightColor;
float g_lightInvDistance;

float g_specularExponent = 128.0f;
float g_lightBallSharpness;
float g_lightBallSize;

PS_OUT ps_deferred_mixer( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 lightResult = (float4)0;
  float4 result = (float4)0.0;

  float4 lightViewPos;
   
  float4 depthV = tex2D(smDepth, In.vTexcoord);

  if (depthV.r > 0.9999) {
    lightResult.a = 1.0;
    lightResult.r = 1.0;
    o.rt0 = lightResult;
    return o;
  }

  
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  float pointDist = clipB/(depthV.r-clipA);
  
  float pointDist2 = pointDist*pointDist;
  float4 pointV = float4(In.vPosSS.x*g_windowWidth/g_windowHeight, In.vPosSS.y, 1.0, 0.0)*pointDist;
  
  float4 pointVN = normalize(pointV);
    
  // render lightball
  
  lightViewPos = mul(g_lightPos, g_mView);
  
  float4 lightSS = mul(g_lightPos, g_mWorldViewProjection)*pointDist;
  
  float lightDist2 = dot(lightViewPos, lightViewPos);
  if (lightViewPos.z > 5.0) {
	  float dotta = dot(lightViewPos, pointVN);
	  float4 vd = (lightViewPos-dotta*pointVN);
	  vd = 2.0*float4((In.vTexcoordActual.x-0.5), (In.vTexcoordActual.y-0.5), 0.0, 0.0);
	  dotta = 1.0-pow(abs(dot(vd, vd)), 1.0/g_lightBallSharpness);
	  float vdLen2 = dotta;
	  dotta = clamp(dotta-0.1, 0.0, 1.0);
	  dotta = pow(dotta*1.5, 2.0)*g_lightBallSize;
	//  dotta = pow(dotta, 2.0)*(1.1+1.0/(vdLen2*4.0+1.0)*0.5*sin(g_lightPos.x+20.0*atan((In.vTexcoordActual.y-0.5)/(In.vTexcoordActual.x-0.5))));
// put this to see light box	  
	//  dotta += 0.1;
	  float softArea = 1.0+0.20*vdLen2;
	  if (pointDist2 > lightDist2) {
		lightResult += dotta*g_lightColor;
		lightResult.a += dotta;
	  } else if (pointDist2 > lightDist2-softArea) {
		float softness = (pointDist2-(lightDist2-softArea))/softArea;
		lightResult += dotta*g_lightColor*softness;	  
		lightResult.a += dotta*softness;
	  }	
  }   

  float2 texus = (In.vTexcoordActual-0.5)*2.0;
  float lightCover = clamp((3.0-dot(texus, texus)*3.0)*1.0, 0.0, 1.0);
  
  lightResult *= lightCover;
  
  


  float4 ambSpec = tex2D(smAmbSpec, In.vTexcoord);
  float4 normalV = (tex2D(smNormal, In.vTexcoord)*2.0)-1.0;
  float4 diffuseV = tex2D(smDiffuse, In.vTexcoord);
  
 diffuseV *= diffuseV;  
    
  lightViewPos = mul(g_lightPos, g_mView);
  
  float4 lightToPoint = lightViewPos-pointV;
  float lightToPointDist2 = dot(lightToPoint, lightToPoint);

  float4 ambienssi = tex2D(smAO, In.vTexcoord).r;
  ambienssi = pow(clamp(1.0-ambienssi, 0.0, 1.0), g_ao_pow);
    
  ambienssi*=ambienssi;
    

  // diffuse
  float lightToPointDist = sqrt(lightToPointDist2);
  float normalLightDot = dot(normalV, lightToPoint/(lightToPointDist+1.0));
  normalLightDot = clamp(normalLightDot, 0.0, 100.0);
  normalLightDot = pow(normalLightDot, 1.0)*16.0/(lightToPointDist*4.0*g_lightInvDistance+1.0)-0.01;
  normalLightDot = clamp(normalLightDot, 0.0, 10000.0)*lightCover;
  result += (normalLightDot*g_lightColor*g_lightColor)*diffuseV*ambienssi;
 // result += (normalLightDot*g_lightColor)*diffuseV*ambienssi;
  
  // specular reflection
  float3 reflected = reflect(float3(lightToPoint.xyz), normalize(float3(normalV.xyz)));
  float specularDot = dot(reflected, float3(pointVN.xyz))/(lightToPointDist+1.0);
  specularDot = clamp(specularDot*1.0, 0.0, 100.0);
  specularDot = pow(specularDot, ambSpec.z)*ambSpec.y/(lightToPointDist*g_lightInvDistance+1.0); // pow(specularDot, g_specularExponent*(ambSpec.y*1.0+1.0))*ambSpec.y*16000.0/(lightToPointDist2*g_lightInvDistance+1.0)-0.01;
  specularDot = clamp(specularDot, 0.0, 10000.0)*lightCover*ambienssi;
  result += specularDot*g_lightColor*g_lightColor*1.0;
 // result += specularDot*g_lightColor*1.0;
  
  
  result += lightResult;

 // result.xyz = normalV.xyz*0.82;
  

  result.a = diffuseV.w;

  
  o.rt0 = result;
  return o;
}




technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_mixer( );
        PixelShader  = compile ps_3_0 ps_deferred_mixer( );
    }
}


