float4x4 comboMatrix : WorldViewProjection;

texture texture_0;

sampler texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput
{
	float3 position : POSITION;
	float2 uvCoord	: TEXCOORD0;
	float4 color	: TEXCOORD1;
};

struct VertexOutput
{
	float4 position : POSITION;
	float2 uvCoord	: TEXCOORD0;
	float4 color 	: COLOR;
};

struct VertexInputColor
{
	float3 position : POSITION;
	float4 color	: TEXCOORD0;
};

struct VertexOutputColor
{
	float4 position : POSITION;
	float4 color	: COLOR;
};


VertexOutput VS_VertexTransform( VertexInput IN )
{
	VertexOutput OUT;
	OUT.position = mul( float4(IN.position, 1.0f), comboMatrix );
	OUT.uvCoord = IN.uvCoord;
	OUT.color = IN.color;
	return OUT;
}

VertexOutput VS_VertexTransformFF( VertexInput IN )
{
	VertexOutput OUT;
	OUT.position = mul( float4(IN.position, 1.0f), comboMatrix );
	OUT.uvCoord = IN.uvCoord;
	OUT.color = IN.color * IN.color.a;
	return OUT;
}

float4 PS_Texture( VertexOutput IN ) : COLOR
{
	return tex2D( texture_0Sampler, IN.uvCoord ) * IN.color;
};

technique Textured
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexTransform();
		PixelShader = compile ps_1_1 PS_Texture();
	}
}

technique TexturedAlpha
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexTransform();
		PixelShader = compile ps_1_1 PS_Texture();
	
		ZWriteEnable =false;
			
		AlphaBlendEnable = true;
		SrcBlend = srcAlpha;
		DestBlend = invSrcAlpha;
	}
}

technique TexturedAlphaFF
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexTransformFF();
		PixelShader = NULL;
		
		Texture[0] = <texture_0>;
		MinFilter[0] = Linear;
		MagFilter[0] = Linear;
		MipFilter[0] = Linear;
	
		ZWriteEnable =false;
		
		AlphaBlendEnable = true;
		SrcBlend = srcAlpha;
		DestBlend = invSrcAlpha;
	}
}