function Vector3D_transform(matrix) {
    var ox = this.x, oy = this.y, oz = this.z
    this.x = matrix.e[0][0] * ox + matrix.e[0][1] * oy + matrix.e[0][2] * oz
    this.y = matrix.e[1][0] * ox + matrix.e[1][1] * oy + matrix.e[1][2] * oz
    this.z = matrix.e[2][0] * ox + matrix.e[2][1] * oy + matrix.e[2][2] * oz
}
function Vector3D_reset() {
    this.x = 0
    this.y = 0
    this.z = 0
}
function Vector3D(x, y, z) {
    this.x = x
    this.y = y
    this.z = z
    this.transform = Vector3D_transform
    this.reset = Vector3D_reset
}

function Matrix3D_reset() {
    this.e[0][0] = 1
    this.e[0][1] = 0
    this.e[0][2] = 0
    this.e[1][0] = 0
    this.e[1][1] = 1
    this.e[1][2] = 0
    this.e[2][0] = 0
    this.e[2][1] = 0
    this.e[2][2] = 1
}
function Matrix3D_multiply(matrix) {
    var o11 = this.e[0][0], o12 = this.e[0][1], o13 = this.e[0][2], o21 = this.e[1][0], o22 = this.e[1][1], o23 = this.e[1][2], o31 = this.e[2][0], o32 = this.e[2][1], o33 = this.e[2][2]
    this.e[0][0] = matrix.e[0][0] * o11 + matrix.e[0][1] * o21 + matrix.e[0][2] * o31
    this.e[0][1] = matrix.e[1][0] * o11 + matrix.e[1][1] * o21 + matrix.e[1][2] * o31
    this.e[0][2] = matrix.e[2][0] * o11 + matrix.e[2][1] * o21 + matrix.e[2][2] * o31
    this.e[1][0] = matrix.e[0][0] * o12 + matrix.e[0][1] * o22 + matrix.e[0][2] * o32
    this.e[1][1] = matrix.e[1][0] * o12 + matrix.e[1][1] * o22 + matrix.e[1][2] * o32
    this.e[1][2] = matrix.e[2][0] * o12 + matrix.e[2][1] * o22 + matrix.e[2][2] * o32
    this.e[2][0] = matrix.e[0][0] * o13 + matrix.e[0][1] * o23 + matrix.e[0][2] * o33
    this.e[2][1] = matrix.e[1][0] * o13 + matrix.e[1][1] * o23 + matrix.e[1][2] * o33
    this.e[2][2] = matrix.e[2][0] * o13 + matrix.e[2][1] * o23 + matrix.e[2][2] * o33
}
function Matrix3D() {
    this.e    = new Array(3)
    this.e[0] = new Array(3)
    this.e[1] = new Array(3)
    this.e[2] = new Array(3)
    this.multiply = Matrix3D_multiply
    this.reset = Matrix3D_reset
    this.reset()
}

function rotate3d1(a) {
    __MULT_MATRIX.e[0][0] = Math.cos(a);
    __MULT_MATRIX.e[0][1] = Math.sin(a);
    __MULT_MATRIX.e[0][2] = 0;
    __MULT_MATRIX.e[1][0] = -Math.sin(a);
    __MULT_MATRIX.e[1][1] = Math.cos(a);
    __MULT_MATRIX.e[1][2] = 0;
    __MULT_MATRIX.e[2][0] = 0;
    __MULT_MATRIX.e[2][1] = 0;
    __MULT_MATRIX.e[2][2] = 1;
    ROTATION_MATRIX.multiply(__MULT_MATRIX);
}

function rotate3d2(a) {
    __MULT_MATRIX.e[0][0] = Math.cos(a);
    __MULT_MATRIX.e[0][1] = 0;
    __MULT_MATRIX.e[0][2] = -Math.sin(a);
    __MULT_MATRIX.e[1][0] = 0;
    __MULT_MATRIX.e[1][1] = 1;
    __MULT_MATRIX.e[1][2] = 0;
    __MULT_MATRIX.e[2][0] = Math.sin(a);
    __MULT_MATRIX.e[2][1] = 0;
    __MULT_MATRIX.e[2][2] = Math.cos(a);
    ROTATION_MATRIX.multiply(__MULT_MATRIX);
}

function rotate3d3(a) {
    __MULT_MATRIX.e[0][0] = 1;
    __MULT_MATRIX.e[0][1] = 0;
    __MULT_MATRIX.e[0][2] = 0;
    __MULT_MATRIX.e[1][0] = 0;
    __MULT_MATRIX.e[1][1] = Math.cos(a);
    __MULT_MATRIX.e[1][2] = Math.sin(a);
    __MULT_MATRIX.e[2][0] = 0;
    __MULT_MATRIX.e[2][1] = -Math.sin(a);
    __MULT_MATRIX.e[2][2] = Math.cos(a);
    ROTATION_MATRIX.multiply(__MULT_MATRIX);
}

__MULT_MATRIX = new Matrix3D()
OFFSET_VECTOR = new Vector3D(0, 0, 0)
ROTATION_MATRIX = new Matrix3D()
