/* Low-level 2D paint methods */

function flatTriangle(x0, y0, x1, y1, x2, y2) {
	/* enlarge extremities by one pixel each direction to eliminate sub-pixel gaps at poly edges */
	var xmid = (x0+x1+x2) / 3; var ymid = (y0+y1+y2) / 3;
	var d0 = Math.abs(x0 - xmid) + Math.abs(y0-ymid);
	var d1 = Math.abs(x1 - xmid) + Math.abs(y1-ymid);
	var d2 = Math.abs(x2 - xmid) + Math.abs(y2-ymid);
	x0 += (x0-xmid) / d0;	y0 += (y0-ymid) / d0;
	x1 += (x1-xmid) / d1;	y1 += (y1-ymid) / d1;
	x2 += (x2-xmid) / d2;	y2 += (y2-ymid) / d2;

	triangle(x0, y0, x1, y1, x2, y2);
}

function triangle(x0, y0, x1, y1, x2, y2) {
	ctx.beginPath();
	ctx.moveTo(x0, y0);
	ctx.lineTo(x1, y1);
	ctx.lineTo(x2, y2);
	ctx.fill();
}

function gouraudTriangle(x0, y0, i0, x1, y1, i1, x2, y2, i2, colour) {
	var sx, sy, si, mx, my, mi, ex, ey, ei;
	i0 = Math.floor(i0); i1 = Math.floor(i1); i2 = Math.floor(i2);
	
	/* enlarge extremities by one pixel each direction to eliminate sub-pixel gaps at poly edges */
	var xmid = (x0+x1+x2) / 3; var ymid = (y0+y1+y2) / 3;
	var d0 = (Math.abs(x0 - xmid) + Math.abs(y0-ymid)) / 2;
	var d1 = (Math.abs(x1 - xmid) + Math.abs(y1-ymid)) / 2;
	var d2 = (Math.abs(x2 - xmid) + Math.abs(y2-ymid)) / 2;
	x0 += (x0-xmid) / d0;	y0 += (y0-ymid) / d0;
	x1 += (x1-xmid) / d1;	y1 += (y1-ymid) / d1;
	x2 += (x2-xmid) / d2;	y2 += (y2-ymid) / d2;
		
	/* sort vertices into start/midpoint/endpoint by intensity */
	if (i0 <= i1) {
		if (i1 <= i2) { /* i0 i1 i2 */
			sx = x0; sy = y0; si = i0;
			mx = x1; my = y1; mi = i1;
			ex = x2; ey = y2; ei = i2;
		} else if (i0 <= i2) { /* i0 i2 i1 */
			sx = x0; sy = y0; si = i0;
			mx = x2; my = y2; mi = i2;
			ex = x1; ey = y1; ei = i1;						
		} else { /* i2 i0 i1 */
			sx = x2; sy = y2; si = i2;
			mx = x0; my = y0; mi = i0;
			ex = x1; ey = y1; ei = i1;
		}
	} else {
		if (i0 <= i2) { /* i1 i0 i2 */
			sx = x1; sy = y1; si = i1;
			mx = x0; my = y0; mi = i0;
			ex = x2; ey = y2; ei = i2;
		} else if (i1 <= i2) { /* i1 i2 i0 */
			sx = x1; sy = y1; si = i1;
			mx = x2; my = y2; mi = i2;
			ex = x0; ey = y0; ei = i0;
		} else { /* i2 i1 i0 */
			sx = x2; sy = y2; si = i2;
			mx = x1; my = y1; mi = i1;
			ex = x0; ey = y0; ei = i0;
		}
	}
	
	if (si == ei) {
		/* need to flatshade instead */
		ctx.fillStyle = colour(si);
	} else {
		/* ratio of intensity increase before midpoint : intensity increase after midpoint */
		var r = (mi - si) / (ei - si);
		if (r == 0) {
			/* special case when mi = si: gradient boundary lines run parallel to edge SM,
			   so F must be the closest point to S on the boundary line through E, such that SF is perpendicular to those
			   boundary lines */
			var modms = (mx-sx)*(mx-sx) + (my-sy)*(my-sy);
			if (modms == 0) { alert("vertices are colinear!") }
			var u = (-(ex-sx)*(mx-sx) - (ey-sy)*(my-sy)) / modms;
			var fx = ex + u*(mx-sx); var fy = ey + u*(my-sy);
		} else {
			/* interpolate to find point I on line S-E with same intensity as point M */
			var ix = (1-r)*sx  + r*ex; var iy = (1-r)*sy + r*ey;
			
			/* find the point P on the line IM at which PS is perpendicular to IM;
			u is the coefficient satisfying P = I + u(M-I) */
			var modmi = (mx-ix)*(mx-ix) + (my-iy)*(my-iy);
			if (modmi == 0) { alert("vertices are colinear!") }
			var u = ((sx-ix)*(mx-ix) + (sy-iy)*(my-iy)) / modmi;
			var px = ix + u*(mx-ix); var py = iy + u*(my-iy);
			
			/* finally extend line SP by the ratio r to arrive at the final endpoint */
			var fx = sx + (px-sx)/r; var fy = sy + (py-sy)/r;
		}

		var grad = ctx.createLinearGradient(sx, sy, fx, fy);
		grad.addColorStop(0, colour(si));
		grad.addColorStop(1, colour(ei));
		ctx.fillStyle = grad;
	}

	// triangle(sx, sy, mx, my, ex, ey);
	triangle(x0, y0, x1, y1, x2, y2);
}

function drawBox(x, y, size) {
	ctx.fillStyle = 'rgba(255, 0, 255, 0.6)';
	ctx.fillRect(x - size/2, y - size/2, size, size);
}

function drawSprite(img, x, y, size) {
	ctx.drawImage(img, x - size/2, y - size/2, size, size);
}

var GROUND_COLOUR;
function paintHorizon(y) {
	/* insert something poetic about painting the horizon here */
	if (y > 0) {
		ctx.fillStyle = '#000033';
		ctx.fillRect(0, 0, CANVAS_WIDTH, y);
	}
	y = Math.max(y, 0);
	ctx.fillStyle = GROUND_COLOUR;
	ctx.fillRect(0, y, CANVAS_WIDTH, CANVAS_HEIGHT - y);
}

function magenta(intensity) {
	var i = Math.floor(intensity);
	return "rgb(" + i + ", 0, " + i + ")"
}
function white(intensity) {
	var i = Math.floor(intensity);
	return "rgb(" + i + ", " + i + ", " + i + ")"
}
function green(intensity) {
	var i = Math.floor(intensity);
	return "rgb(0, " + i + ", 0)"
}
function yellow(intensity) {
	var i = Math.floor(intensity);
	return "rgb(" + i + ", " + i + ", 0)"
}
function dutchColourScheme(i) {
	return "rgb(" + Math.floor(i) + ", " + Math.floor(i/4) + ", " + Math.floor(128 - i/2) + ")"
}
function greyStone(intensity) {
	var i = Math.floor(intensity * 0.6);
	return "rgb(" + i + ", " + i + ", " + i + ")"
}