/* flower scene */

var flowerLight = [4,3,0];

var flowerSceneSubjects = [
	{ light: flowerLight },
	{generate: genFlower},
]

var flowerScene = {
	subjects: flowerSceneSubjects
}

function flowerOpenness1(t) {
	return 1;
}
function flowerOpenness2(t) {
	return 1.05 + t * 0.4 / FLOWER_SHOT_2_LENGTH;
}
function flowerOpenness3(t) {
	return 3 + Math.sin(2 * Math.PI * (t % 6543) / 6543);
}

var flowerOpenness;

function genFlower(t) {
	return makeFlower(1, flowerOpenness(t), 4, 6, green, magenta);
}


var flowerImg;
function initFlowerScene() {
	flowerImg = new Image();
	flowerImg.src = 'data/flow0.png';
}

function startFlowerScene() {
	PERSPECTIVE_ALTERING_MINDFUCK_RATIO = 0;
	AMBIENT_LEVEL = 100;
	GROUND_COLOUR = '#444400';
	FOC = 8;
}

var FLOWER_FIRST_FADEON_TIME = 1000;
var FLOWER_FADEON_TIME = 250;
var FLOWER_FADE_TIME = 1000;

var FLOWER_SHOT_1_LENGTH = 15000;
var FLOWER_SHOT_2_LENGTH = 15000;
var FLOWER_SHOT_3_LENGTH = 15000;

var flowerShot1Inited; // unused
var flowerShot2Inited;
var flowerShot3Inited;

function flowerShot1(t) {
	var camera = [-4 + 13 * (t / FLOWER_SHOT_1_LENGTH), 1, -3];
	var lookingAt = [0, 0, 2];
	flowerOpenness = flowerOpenness1;
	if (t < 5000) {
		flowerLight[1] = 30 - 27*Math.pow(Math.sin(Math.PI * t / 10000), 3);
		//flowerLight[1] = -24 + 27*Math.pow(Math.sin(Math.PI * t / 10000), 3);
		/* don't know why this is upside down. Too rushed to check. */
	} else {
		flowerLight[1] = 3;
	}
	
	renderFrame(flowerScene, camera, lookingAt, t, true);
	
	if (t < FLOWER_FIRST_FADEON_TIME) {
		var fadeAmount = 1 - (t / FLOWER_FIRST_FADEON_TIME);
		ctx.fillStyle = "rgba(0, 0, 0, " + fadeAmount + ")";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	} else if (t > FLOWER_SHOT_1_LENGTH - FLOWER_FADE_TIME) {
		var fadeAmount = (t - FLOWER_SHOT_1_LENGTH + FLOWER_FADE_TIME) / FLOWER_FADE_TIME;
		ctx.fillStyle = "rgba(0, 0, 0, " + fadeAmount + ")";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	}
}

function initFlowerShot2() {
	flowerSceneSubjects.push(	{
		transform: constTranslation(0, 0.5, 0),
		subjects: [
			makeSphere(0.45, 7, 8, yellow, 6)
		]
	})
	flowerOpenness = flowerOpenness2;
}

function initFlowerShot3() {
	flowerOpenness = flowerOpenness3;
	flowerSceneSubjects.push(	{
		model: renderSprites, image: flowerImg, size: 1000,
		v: [
			[-30, 0, -15], [-15, 0, -15], [0, 0, -15], //[10, 0, -10],
			[-30, 0, 0], [-15, 0, 0], //[15, 0, 0],
			[-30, 0, 15], [-15, 0, 15], [0, 0, 15], //[15, 0, 15]
		]
	})
}

function flowerShot2(t) {
	if (!flowerShot2Inited) {initFlowerShot2(); flowerShot2Inited = true;}
	var progress = t / FLOWER_SHOT_2_LENGTH;
	var cameraRota = Math.PI * 0.5 * progress;
	var cameraRadius = 2.2 - progress * .4;
	var camera = [cameraRadius * Math.sin(cameraRota), .5 + 4 * progress, -cameraRadius * Math.cos(cameraRota)];
	// var camera = [0, .5, -1];
	var lookingAt = [0, 1, 0];
	flowerLight[1] = 3;
	
	renderFrame(flowerScene, camera, lookingAt, t, true);
	
	if (t < FLOWER_FADEON_TIME) {
		var fadeAmount = 1 - (t / FLOWER_FADEON_TIME);
		ctx.fillStyle = "rgba(0, 0, 0, " + fadeAmount + ")";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	} else if (t > FLOWER_SHOT_2_LENGTH - FLOWER_FADE_TIME) {
		var fadeAmount = (t - FLOWER_SHOT_2_LENGTH + FLOWER_FADE_TIME) / FLOWER_FADE_TIME;
		ctx.fillStyle = "rgba(0, 0, 0, " + fadeAmount + ")";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	}
}

function flowerShot3(t) {
	if (!flowerShot3Inited) {initFlowerShot3(); flowerShot3Inited = true;}
	var progress = t / FLOWER_SHOT_3_LENGTH;
	var cameraRota = Math.PI * 0.5 * progress;
	var cameraRadius = 2 + progress * 7;
	var camera = [cameraRadius * Math.sin(cameraRota), .5 + 5 * progress, -cameraRadius * Math.cos(cameraRota)];
	// var camera = [0, .5, -1];
	var lookingAt = [0, 1, 0];
	flowerLight[1] = 3;
	
	renderFrame(flowerScene, camera, lookingAt, t, true);
	
	if (t < FLOWER_FADEON_TIME) {
		var fadeAmount = 1 - (t / FLOWER_FADEON_TIME);
		ctx.fillStyle = "rgba(0, 0, 0, " + fadeAmount + ")";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	} else if (t > FLOWER_SHOT_3_LENGTH - FLOWER_FADE_TIME) {
		var fadeAmount = (t - FLOWER_SHOT_3_LENGTH + FLOWER_FADE_TIME) / FLOWER_FADE_TIME;
		ctx.fillStyle = "rgba(0, 0, 0, " + fadeAmount + ")";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	}
}

function doFlowerScene(t) {
	if (t < FLOWER_SHOT_1_LENGTH) {
		flowerShot1(t);
	} else if (t < FLOWER_SHOT_1_LENGTH + FLOWER_SHOT_2_LENGTH) {
		flowerShot2(t - FLOWER_SHOT_1_LENGTH);
	} else if (t < FLOWER_SHOT_1_LENGTH + FLOWER_SHOT_2_LENGTH + FLOWER_SHOT_3_LENGTH) {
		flowerShot3(t - FLOWER_SHOT_1_LENGTH - FLOWER_SHOT_2_LENGTH);
	} else {
		ctx.fillStyle = "#000000";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	}
	
}