#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>


#include "font.h"

int xres=640;
int yres=480;
int bpp = 32;

long blend( long c1, long c2 )
{
    c1 &= 0x00fefeff;
    c2 &= 0x00fefeff;

    return( (c1+c2)>>1 );
}

void luz( long *buffer, float t )
{
    int i, j, k, col;
    int x, y;

    x = (xres/2) + (xres/2)*sin( 1.0 + 10.0*t );
    y = (yres/2) + (yres/2)*sin( 3.0 + 13.0*t );


    for( i=0; i<xres; i++ )
    for( j=0; j<yres; j++ )
        {
        
        //k = abs(i-x)+abs(j-y);
        k = 255*j/yres;
        col = (k<<16)|(k<<8)|(k);

        *buffer = blend( *buffer, col );
        buffer++;
        }


}


extern void set_palette( long *palette );
extern void set_color( int i, int r, int g, int b );

void do_boton( long *buffer, int x, int y, int w, int h, char *txt );
void memsetl( long *buf, long col, long amo );
void do_marco( long *buffer, int x, int y, int w, int h, int stado );
void do_recrangle( long *buffer, int x, int y, int w, int h, int col );

int hace_cancion( void );


int FFX_Init( void *buffer )
{
    if( !hace_cancion() )
        {
        return( 0 );
        }

    return( 1 );
}



void FFX_End( void )
{
}




void do_boton( long *buffer, int x, int y, int w, int h,
               char *txt )
{
    long    osc = 0xff202020;
    long    cla = 0xfff0f0f0;
    long    i, j;
    long    *kk=buffer;

    buffer += xres*y+x;

    for( i=0; i<h; i++ )
        memsetl( buffer+xres*i, 0xffa0a0a0, w );

    for( i=0; i<w; i++ )
        {
        buffer[i-xres] = 0;
        buffer[i] = cla;
        buffer[xres*h+i] = osc;
        buffer[xres*h+i+xres] = 0;
        }

    for( i=0; i<h; i++ )
        {
        buffer[i*xres+0-1] = 0;

        buffer[i*xres+0] = cla;
        buffer[i*xres+w-1] = osc;
        buffer[i*xres+w] = 0;
        }

    FONT_PrintString( txt, kk, x+(w-8*strlen(txt))/2,
                               y+((h-16)/2), xres, yres, 0 );

}

void do_marco( long *buffer, int x, int y, int w, int h, int stado )
{
    long    osc = 0xff202020;
    long    cla = 0xfff0f0f0;
    long    i, j;

    if( stado )
        {
        osc = 0xff404040;
        cla = 0xfff0f0f0;
        }
    else
        {
        osc = 0xfff0f0f0;
        cla = 0xff404040;
        }

    buffer += xres*y+x;

    for( i=0; i<w; i++ )
        {
        buffer[i-xres] = 0;
        buffer[i] = cla;
        buffer[xres*h+i] = osc;
        buffer[xres*h+i+xres] = 0;
        }

    for( i=0; i<h; i++ )
        {
        buffer[i*xres+0-1] = 0;

        buffer[i*xres+0] = cla;
        buffer[i*xres+w-1] = osc;
        buffer[i*xres+w] = 0;
        }
}

void do_recrangle( long *buffer, int x, int y, int w, int h, int col )
{
    long    i, j;

    buffer += xres*y+x;

    for( i=0; i<h; i++ )
        memsetl( buffer+xres*i, col, w );

}

void memsetl( long *buf, long col, long amo )
{
    long *p1=buf;
    long  p2=col;
    long  p3=amo;

    __asm
        {
        mov edi, p1
        mov eax, p2
        mov ecx, p3
        rep stosd
        }
}


void drawsignals( long *buffer, float t )
{
    int i, j, k;
    int y, x, z;
    float s;
    float f[8] = {3.0, 2.2, 1.3, 6.8, 0.1, 2.3, 15.4, 2.3};
    float v[8] = {1.0, 2.2, 4.3, 1.6, 6.1, 8.3,  4.4, 7.3};

    

    for( j=0; j<2; j++ )
    for( i=0; i<4; i++ )
        {
        x = 2+72*i;
        y = 80+67*j;

        do_recrangle( buffer, x, y, 64, 45, 0 );
        do_marco( buffer, x, y, 65, 45, 0 );

        for( k=0; k<64; k++ )
            {
            s = sin( v[4*j+i]*t + f[4*j+i]*6.2831*k/64.0 );

            z = 22*s;
            buffer[xres*(y+22+z)+2+x+k] = 0xffffffff;
            }
        }

}

static char *cancion[64];

static char *notas[12] = {
                  "c.",
                  "c#",
                  "d.",
                  "d#",
                  "e.",
                  "f.",
                  "f#",
                  "g.",
                  "g#",
                  "a.",
                  "a#",
                  "b." };

void rellena_cancion( float t )
{
    int i, j, k;
    int a = t*10.0;
    char    str[16];

    a &= 63;
    if( a==0 )


    for( i=0; i<64; i++ )
    {
    strcpy( cancion[i], "..." );
    strcat( cancion[i], " " );
    strcat( cancion[i], ".." );
    strcat( cancion[i], " " );
    strcat( cancion[i], "00" );
    for( j=0; j<7; j++ )
        {
        k = rand()&31;
        if( k>=12 )
            strcat( cancion[i], "..." );
        else
            {
            strcat( cancion[i], notas[k] );
            //strcat( cancion[i], "." );
            sprintf( str, "%1d", rand()%4 );
            strcat( cancion[i], str );
            }

        strcat( cancion[i], " " );
        strcat( cancion[i], ".." );
        strcat( cancion[i], " " );
        strcat( cancion[i], "00" );
        }
    }
}

int hace_cancion( void )
{
    int i;

    for( i=0; i<64; i++ )
        {
        cancion[i] = (char*)malloc(256);
        if( !cancion[i] )
            return( 0 );
        }

    return( 1 );
}



void drawpatten( long *buffer, float t )
{
    int i, j, n;
    char    str[32];
    int     a, b, c;

    memsetl( buffer+xres*200, 0xff000000, xres*(yres-1-200));

    do_recrangle( buffer, 0, 202+15*9, xres, 16, 0xff607080 );
    do_marco( buffer, 0, 202+15*9, xres, 16, 1 );

    a = t*10.0;

    for( i=0; i<18; i++ )
        {
        n = a+i;
        n &= 63;
        sprintf( str, "%02x", n );

        c = 0xffffffc0;

        if( (n&3)==0 )
            c = 0xffffffff;
        FONT_PrintString( str, buffer, 4, 202+i*15, xres, yres, c );
        FONT_PrintString( str, buffer, xres-27, 202+i*15, xres, yres, c );

        FONT_PrintString( cancion[n], buffer, 4+28, 202+i*15, xres, yres, 0xffffffc0 );
        }





}

// iq
char *frases[20] = { "About",   "Ply S",
                     "Nibble", "Ply P",
                     "Zap",     "Stop",
                     "CD", "Rec",
                     "Extend", "Rec",
                     "Tran", "Disk",
                     "IEE", "Ins",
                     "SEE", "Samp",
                     "Adv", "Config",
                     "About", "Play Sng."};

void FFX_DoFrame( void *buffer, float time )
{
    int     i, j;
    long    *buf = (long*)buffer;
    char    str[16];


    //memsetl( buf, 0xff607080, xres*yres );
    memsetl( buf, 0xff607080, xres*200);


    for( i=0; i<9; i++ )
        {
        do_boton( buffer, 294, 2+20*i, 52, 16, frases[2*i+0] );
        do_boton( buffer, 356, 2+20*i, 52, 16, frases[2*i+1] );
        }
    do_boton( buffer, 294, 2+20*9, 24, 16, "Add" );
    do_boton( buffer, 294+28, 2+20*9, 24, 16, "Sub" );
    do_boton( buffer, 356, 2+20*9, 52, 16, "Help" );

    for( i=0; i<8; i++ )
        {
        sprintf( str, "%02x-%02x", i*8, i*8+8 );
        do_boton( buffer, 592, 2+20*i, 44, 16, str );
        }

    do_boton( buffer, 592, 162, 44, 40, "Bank" );

    do_recrangle( buffer, 412, 4, 176, 100, 0xff000000 );
    do_recrangle( buffer, 412, 4, 176, 15, 0xff808080 );

    do_marco( buffer, 412, 4, 176, 100, 0 );
    for( i=0; i<6; i++ )
        {
        sprintf( str, "%02x", i );
        FONT_PrintString( str, buffer, 414, 2+i*15, xres, yres, 0xffffffff );
        }

    do_recrangle( buffer, 412, 108, 176,  85, 0xff000000 );
    do_recrangle( buffer, 412, 108, 176, 15, 0xff808080 );
    do_marco( buffer, 412, 108, 176, 85, 0 );
    for( i=0; i<5; i++ )
        {
        sprintf( str, "%02x", i );
        FONT_PrintString( str, buffer, 414, 109+i*15, xres, yres, 0xffffffff );
        }


    do_recrangle( buffer, 2, 2, 50, 50, 0xff000000 );
    do_recrangle( buffer, 1, 23, 50, 13, 0xff607080 );
    do_marco( buffer, 1, 23, 50, 13, 1 );
    do_marco( buffer, 2, 2, 50, 50, 0 );

    FONT_PrintString( "00 00", buffer, 4, 22, xres, yres, 0xffffffff );


    drawsignals( buffer, time );
    rellena_cancion( time );
    drawpatten( buffer, time );

//    luz( buffer, time );

}

