#include <conio.h>      // out()
#include <string.h>     // memcpy()
#include "gfx.h"

void Mode13hOn(void);
#pragma aux Mode13hOn = \
 "mov ax, 0x13"\
 "int 0x10"\
 modify [eax];

void Mode13hOff(void);
#pragma aux Mode13hOff = \
 "mov ax, 0x03"\
 "int 0x10"\
 modify [eax];


void gfx_init( void )
{
    int i;


    Mode13hOn();
        
    // set a gray scale palette...

    outp( 0x3c8, 0 );
    for( i=0; i<256; i++ )
        {
        outp( 0x3c9, 63*i/255 );
        outp( 0x3c9, 63*i/255 );
        outp( 0x3c9, 63*i/255 );
        }
}

void gfx_end( void )
{
    Mode13hOff();
}

void gfx_dump( unsigned char *buffer, long amount )
{
    memcpy( (unsigned char*)0xa0000, buffer, amount );
}

void gfx_waitretrace( void )
{
    while(  (inp(0x3da)&8) );
    while( !(inp(0x3da)&8) );
}

void gfx_setcolor( int i, int r, int g, int b )
{

    outp( 0x3c8, i );
    outp( 0x3c9, r );
    outp( 0x3c9, g );
    outp( 0x3c9, b );
}
