#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "vesa.h"
#include "rxm.h"

//vesa
tvesa vesa;


//xm-player
int dflags = df16bit | dfStereo;
//int vol = 12;
int mixrate = 44100;
int mastervol = 0;
int iwflag = 1;

extern "C" int tune;
#pragma aux tune "*"

extern "C" {
void init256();
#pragma aux init256 "*" modify [eax ebx ecx edx esi edi]

void initengine(char *membase, char *memtop, tvesa &);
#pragma aux initengine "*" parm [eax] [edx] [esi] modify [eax ebx ecx edx esi edi]

void startengine();
#pragma aux startengine "*" modify [eax ebx ecx edx esi edi]

}



//grabber

struct theader {
 char  ident_len;   //zahl an byte, die nach dem header zu berspringen ist
 char  cmap_type;   // = 1: palette vorhanden
 char  image_type;  //bit0 = 1: mit palette, bit1 = 1: rgb, bit3 = 1: gepackt
 short cmap_origin; //?
 short cmap_len;    //palettenlnge
 char  centry_size; //bit pro paletteneintrag
 short image_xorg;  //x - ursprung
 short image_yorg;  //y - ursprung
 short image_width; //x - auflsung
 short image_height;//y - auflsung
 char  pixel_size;  //bit pro pixel
 char  image_discr; //bit5 = 0: bild "auf dem kopf"
};

void grab();
#pragma aux grab "grab"

void grab() {
  FILE *f;
  static char *fname = "shot_a.tga";
  theader header;
  char *cp;
  int x, y, i;
  char col[3];

  if (vesa.redbits != 8 || vesa.greenbits != 8 || vesa.bluebits != 8) return;

  f = fopen(fname,"wb");
  fname[5]++;

  header.ident_len = 0;
  header.cmap_type = 0;   // = 1: palette vorhanden
  header.image_type = 2;  //bit0 = 1: mit palette, bit1 = 1: rgb, bit3 = 1: gepackt
  header.cmap_origin = 0; //?
  header.cmap_len = 0;    //palettenlnge
  header.centry_size = 0; //bit pro paletteneintrag
  header.image_xorg = 0;  //x - ursprung
  header.image_yorg = 0;  //y - ursprung
  header.image_width = vesa.xres; //x - auflsung
  header.image_height = vesa.yres;//y - auflsung
  header.pixel_size = 24;  //bit pro pixel
  header.image_discr = 32; //bit5 = 0: bild "auf dem kopf"
  fwrite(&header,1,sizeof(theader),f);

  for (y = 0; y < vesa.yres; y++) {
    cp = (char *) vesa.linbuf + y*vesa.xbytes;
    for (x = 0; x < vesa.xres; x++) {
      i = *(int *) cp;

      col[2] = i >> vesa.redpos;
      col[1] = i >> vesa.greenpos;
      col[0] = i >> vesa.bluepos;
      fwrite(col,1,3,f);

      cp += vesa.pbytes;
    }
  }

  fclose(f);
}




void *allocmem(int size) {
  void *mem;
  mem = (void *) new char[size];
  if (!mem) exit("Out of memory");
  return mem;
}


void readline(FILE *f, char *str) {
  int c;
  int count = 0;
  int z;

  do {
    if ((c = fgetc(f)) == EOF) break;
    if (c > 32 && count < 45) {
      if (c >= 'A' && c <= 'Z') c += 32;
      str[count] = c;
      count++;
    };

  } while (c != 10);
  str[count] = '\0';
};

int hex(char *s) {
  int r = 0;

  while (*s) {
    r <<=4;
    if (*s >= '0' && *s <= '9') r += *s - '0';
    if (*s >= 'a' && *s <= 'f') r += *s - 'a' + 10;
    if (*s >= 'A' && *s <= 'F') r += *s - 'A' + 10;
    s++;
  };
  return r;
}

void readlist(char *s, char *values, int novalues) {
  int z;
  for(z = 0; z < novalues; z++) values[z] = 0;
  z = 0;
  while (*s && novalues > 0) {
    if (*s >= '0' && *s <= '9') {
      *values *= 10;
      *values += *s - '0';
    };
    if (*s == ',') {
      values++;
      novalues--;
    }
    s++;
  }
}

int atob(char *s) {
  int i;
  i = atoi(s);
  if (i) return i;
  if (*s == 'y' || *s == 'Y') return 1;
  return 0;
}

void readconfig() {
  char str[48];
  char *val;
  FILE *f;

  f = fopen("spotlite.cfg","rb");
  if (!f) exit("Can't read config file");
  while (!feof(f)) {
    readline(f,str);
    val = strchr(str,';');
    if (val) *val = '\0';
    val = strchr(str,'=');
    if (val) {
      *val = '\0';
      val++;

      //mode 1
      if (!strcmp(str,"mode")) vesa.mode = hex(val);
      if (!strcmp(str,"mode_x")) vesa.xres = atoi(val);
      if (!strcmp(str,"mode_y")) vesa.yres = atoi(val);
      if (!strcmp(str,"mode_bit")) readlist(val,vesa.bpplist,4);
      if (!strcmp(str,"mode_a")) vesa.area = atoi(val);

      //player
      if (!strcmp(str,"nosound")) if (atob(val)) dflags |= dfNosound;
//      if (!strcmp(str,"volume")) vol = atoi(val);
      if (!strcmp(str,"16bit")) if (!atob(val)) dflags &= ~df16bit;
      if (!strcmp(str,"stereo")) if (!atob(val)) dflags &= ~dfStereo;
      if (!strcmp(str,"reverse")) if (atob(val)) dflags &= ~dfReverse;
      if (!strcmp(str,"rate")) mixrate = atoi(val);
      if (!strcmp(str,"sb_dsp1")) if (atob(val)) dflags |= sb_dsp1;
      if (!strcmp(str,"sb_awe")) if (atob(val)) dflags |= sb_awe;
      if (!strcmp(str,"sb_master")) mastervol = atoi(val);
      if (!strcmp(str,"gus_iw")) iwflag = atob(val);
    }
  }
  fclose(f);
}

int parse(char *s, int mul) {
  int r = 0;

  while (*s && (*s < '0' || *s > '9')) s++;
  while (*s >= '0' && *s <= '9') {
    r *= mul;
    r += *s - '0';
    s++;
  }
  return r;
}

int checkenv(tdinfo *dinfo) {
  int i;
  i = dinfo->base >= 0x200 && dinfo->base <= 0x290;
  i &= dinfo->irq >= 2 && dinfo->irq <= 15;
  i &= dinfo->dma1 <= 7;
  i &= dinfo->dma2 <= 7;
  return i;
}

int gusenv(tdinfo *dinfo, int flags, int iwflag) {
  char *s;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("ULTRASND");
  dinfo->base = parse(s,16);
  s = strchr(s,',');
  if (!s) return 0;
  dinfo->dma1 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->dma2 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->irq = parse(s,10);

  if (iwflag >= 2 || (iwflag == 1 && getenv("INTERWAVE"))) dinfo->flags |= gus_iw;
  dinfo->flags |= flags;

  return checkenv(dinfo);
}

int sbenv(tdinfo *dinfo, int rate, int flags) {
  char *s;
  char *v;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("BLASTER");
  v = strchr(s,'A');
  if (v) dinfo->base = parse(v,16);
  v = strchr(s,'I');
  if (v) dinfo->irq = parse(v,10);
  v = strchr(s,'D');
  if (!v) return 0;
  dinfo->dma1 = parse(v,10);
  v = strchr(s,'H');
  if (v) dinfo->dma2 = parse(v,10);
  dinfo->rate = rate;
  dinfo->flags = flags;
  return checkenv(dinfo);
}

void initxm() {
  int t;
  tdinfo dinfo;
  void *drv_mem = NULL;

  rxminit();

  t = 0;
  if (!(dflags & dfNosound)) {
    //gus
    if (gusenv(&dinfo,dflags,iwflag)) t = u_test(&dinfo);
    //sb
    if (!t && sbenv(&dinfo,mixrate,dflags)) {
      if (dflags & sb_awe) t = a_test(&dinfo);
      if (!t) t = sb_test(&dinfo);
    }
  }
  //no sound
  if (!t) n_test(&dinfo);

  if (dinfo.mem) drv_mem = allocmem(dinfo.mem);
  if (dinfo.dmabuf) {
    if (!(dinfo.dmabuf = getdmabuf(dinfo.dmabuf))) {
      exit("Not enough low mem");
    }
  }

  dinfo.mastervol = mastervol;

  t = rxmdevinit(&dinfo,drv_mem);
  if (t) {
    if (t == 1) exit("DMA error");
    exit("IRQ error");
  }
  rxmsetvol(12);
}

void donexm() {
  rxmdevdone();
  freedmabuf();
  i8_done();
}

void main() {
  char *membase;
  int memsize;

  vesa.mode = 0;
  vesa.flags = 1;
  readconfig();

  if (vesa.mode == 0 && vesa.xres == 320 && vesa.yres == 200 && vesa.bpplist[0] == 8) {
    int a, o;

    vesa.xbytes = 320;
    vesa.pbytes = 1;

    a = vesa.area;
    if (a == 0 || a > 100) a = 100;
    if (a < 20) a = 20;

    o = (vesa.xres*(100-a)/200) & (~3);
    o += (vesa.yres*(100-a)/200)*vesa.xbytes;
    vesa.linbuf = (void *) (0xA0000 + o);

    vesa.xres = ((vesa.xres*a)/100) & (~3);
    vesa.yres = ((vesa.yres*a)/100) & (~3);

    mode13();
  } else {
    initvesa(&vesa,1);
    if (!setmode(vesa)) exit("Error initing mode");
  }
/*
  vesa.xres = (vesa.xres*vesa.area)/100;
  vesa.yres = (vesa.yres*vesa.area)/100;
  vesa.pbytes = (vesa.bpplist[0]+7) >> 3;
  vesa.xbytes = vesa.pbytes*vesa.xres;
  vesa.linbuf = allocmem(vesa.xbytes*vesa.yres);
  vesa.redbits = 8;
  vesa.greenbits = 8;
  vesa.bluebits = 8;
  vesa.redpos = 0;
  vesa.greenpos = 8;
  vesa.bluepos = 16;
*/

  i8_init();

  initxm();

  memsize = 700000 + (vesa.xres+1)*vesa.yres*4;
  membase = (char *) allocmem(memsize);
  initengine(membase,&membase[memsize],vesa);

  rxmplay(&tune);
  rxmcontinue();

  startengine();

  rxmstop(xmStop);

  donexm();

  i8_done();
  textmode();
}
