
gfx = 1

bla = 0  ;0 = include mode, 1 = stand alone mode


if bla gt 0
pmw = 1
else
include system.inc
endif

if pmw gt 0

.386                                    ;pmode/w
.model flat,prolog

if bla gt 0
.stack 1000h
endif

else

.386p
.model use32 small                      ;tran
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include kb.inc
endif

locals


if bla eq 0
extrn _getmemc:near
extrn _getmem:near

include int.inc
endif

public greets

density = 3

;---------font--
extrn f_text2:byte
extrn f_header:byte
extrn font:dword

cSpace    = 250;
cNextline = 251;
cNextpage = 253;
cEnd      = 255;

tfonth struc
 f_pos           dd ?
 f_x             db ?
 f_y             db ?
ends
;----------------
if pmw gt 0
;
.code
;
endif

if bla gt 0
_getmem proc near
        ;-> eax = size
        ;<- eax -> mem
        ;CF = 0: successful

        add     eax,3
        and     eax,not 3
        jz      @@weg
        add     eax,membase
        cmp     eax,memtop
        ja      @@0

        xchg    eax,membase
        clc
        jmp     @@weg
@@0:
        xor     eax,eax
        stc
@@weg:  ret
endp


_getmemc proc near
        push    ecx
        mov     ecx,eax
        call    _getmem
        jc      @@0
@@l:
        dec     ecx
        js      @@0
        mov     byte ptr [eax+ecx],0
        jmp     @@l

@@0:    pop     ecx
        ret
endp
endif

allocmem proc near
;heights1        dd      64000   dup(?)
                mov     eax,64000*4
                call    _getmemc
                jc      @@weg
                mov     height1_pointer,eax
;heights2        dd      64000   dup(?)
                mov     eax,64000*4
                call    _getmemc
                jc      @@weg
                mov     height2_pointer,eax
;scantab         dd      3000    dup(?)
;scantab2        dd      3000    dup(?)
;scantab3        dd      3000    dup(?)
                mov      eax,3000*4*4
                call     _getmem
                jc       @@weg
                mov      scantabpointer,eax

;the screens
;virtual_screen  db      64000   dup(?)
                mov      eax,64000
                call     _getmem
                jc       @@weg
                mov      virtual_screen,eax
;background      db      64000   dup(?)
                mov      eax,64000
                call     _getmem
                jc       @@weg
                mov      background,eax
;bgpic           db      64000   dup(?)
                mov      eax,64000
                call     _getmem
                jc       @@weg
                mov      bgpic,eax
;greetpic1       db      64000   dup(?)
                mov     eax,64000*4;3;
                call    _getmemc
                jc      @@weg
                mov     picpointer,eax
 ;palette        db       768     dup(?)
                mov     eax,768
                call    _getmemc
                jc      @@weg
                mov     palette,eax

@@weg:  ret
allocmem endp



if bla gt 0
start:
                sti
                cld

                xor     ax,ax           ;set zero selector to es
                mov     cx,1
                int     31h             ;get desc
                mov     zero_sel,ax
                xchg    ax,bx
                mov     ax,8
                mov     cx,-1
                mov     dx,-1
                int     31h
                mov     es,zero_sel

                mov     ax,13h
                int     10h

;
;mem-alloc
                mov     ebx,100000h             ;1 MB
                mov     memtop,ebx
                mov     cx,bx
                shr     ebx,16
                mov     ax,501h
                int     31h

                mov     handle_di,di
                mov     handle_si,si
                shl     ebx,16
                mov     bx,cx
                mov     membase,ebx
                add     memtop,ebx
;
endif

greets:
                call    allocmem

                call    init_pics
                call    init_mul255
                call    store_palette
                call    flash_in
                call    scan_font
main_loop:
                call    calc_water
                call    change_heights
                call    set_background
                call    scale&water
                call    waitborder
if gfx gt 0
                call    virtual2screen
endif

if pmw gt 0
        mov     ah,1
        int     16h
        jnz     @@fine
else
        cmp     kb_scan,80h
        jb      @@fine
endif
                cmp     maincounter,0
                jne     main_loop

                call    fade_out

@@fine:

if bla gt 0
                mov     ax,3h
                int     10h
 ;
        mov     di,handle_di
        mov     si,handle_si
        mov     ax,502h
        int     31h
;

                mov     ax,4c00h
                int     21h
endif
                ret




virtual2screen  PROC
                mov     edi,0a0000h
if pmw eq 0
        sub     edi,_code32a
endif
                mov     esi,virtual_screen
                mov     ecx,(64000-320)/4
                rep     movsd
                ret
virtual2screen  ENDP

set_background  PROC
                mov     edi,background
                mov     esi,bgpic
                mov     ecx,16000
                rep     movsd
                ret
set_background  ENDP


store_palette   PROC
                mov     edi,palette
              add     edi,3
                ;xor     eax,eax
                ;stosw
                ;stosb
                mov     ecx,1   ; count from 0 up

@@set_all_colors:
                mov     eax,ecx
                imul    eax,163
                shr     eax,8+2
                add     eax,3
                stosb

                mov     eax,ecx
                imul    eax,99
                shr     eax,8+2
                add     eax,2
                stosb

                mov     eax,ecx
                imul    eax,28
                shr     eax,8+2
                add     eax,2
                stosb

                inc     cl      ; check if all colors are set
                jnz     @@set_all_colors
                ret
store_palette   ENDP


flash_in        PROC
                ;mov     dx,3c8h         ;set palette complete to 0
                ;mov     al,0
                ;out     dx,al
                ;inc     edx
                ;xor     al,al
                ;stosb
                ;stosb
                ;stosb
                ;mov     al,63
                ;mov     ecx,765
                ;rep     outsb

                ;call    set_background

                ;mov     esi,palette
                mov     cl,63;ecx,63
@@flashin_loop:
                mov     ebx,3
                mov     dx,3c8h
                mov     al,1
                out     dx,al
                inc     edx
                mov     esi,palette
@@inna:
                ;xor     eax,eax
                mov     al,[esi+ebx]
                cmp     cl,al;ecx,eax
                jb      @@store
                mov     al,cl;eax,ecx
@@store:
                out     dx,al
                inc     ebx
                cmp     ebx,768
                jb      @@inna

                push    ecx
        call    set_background
                call    water2virtual
;if gfx gt 0
                call    virtual2screen
;endif
                call    waitborder
                pop     ecx

                dec     cl;ecx
                jnz     @@flashin_loop
                ret
flash_in        ENDP



fade_out        PROC
                ;mov     esi,palette
                mov     cl,25;ecx,64
@@fadeout_loop:
                mov     ebx,3
                mov     dx,3c8h
                mov     al,1
                out     dx,al
                inc     edx
                mov     esi,palette
@@inna:
                ;xor     eax,eax
                mov     al,[esi+ebx]
                cmp     cl,al;ecx,eax
                ja      @@store
                mov     al,cl;eax,ecx
@@store:
                out     dx,al
                inc     ebx
                cmp     ebx,768
                jb      @@inna

;                push    ecx

;                call    calc_water
;                call    change_heights
;                call    set_background
;                call    water2virtual
;if gfx gt 0
;                call    virtual2screen
;endif
                call    waitborder
;                pop     ecx

                dec     cl;ecx
                ;dec     cl;ecx
                jnz     @@fadeout_loop
                ret
fade_out        ENDP



rle proc near
                ;-> ah = farbe1
                ;-> al = farbe2
                ;-> esi -> rle-daten
                ;-> edi -> pic
                xor     edx,edx
@@init_pic:                                     ; 2 colors...
                movzx   ecx,byte ptr [esi]
                inc     esi
                ;inc     esi
                xchg    ah,al
                add     edx,ecx
                rep     stosb
                cmp     edx,64000
                jb      @@init_pic
@@weg:          ret
rle endp


init_pics       PROC
hcol = 180
gcol = 140
                lea     esi,greetinx            ; put logo on pic-screen
                mov     edi,bgpic            ; encoded, cause only
                mov     al,hcol
                mov     ah,gcol
                call    rle

            call fontwr

                ;lea     esi,greetinx1            ; put logo on pic-screen
                ;mov     edi,picpointer
                ;mov     ax,30                    ; the pic is run-length
                ;call    rle

                ;mov     ax,30                    ; the pic is run-length
                ;call    rle

                ;mov     ax,30                    ; the pic is run-length
                ;call    rle

                ret
init_pics       ENDP


fontwr proc pascal
local   y, p

        lea     esi,f_text2
        mov     edi,picpointer
        add     edi,18*320+46
        mov     y,edi
        mov     p,edi

@@l:
        lodsb                           ;zeichen einlesen
        cmp     al,cSpace
        jne     @@1
        add     edi,25
        jmp     @@l
@@1:
        cmp     al,cNextline
        jne     @@2
        add     y,48*320
        mov     edi,y
        jmp     @@l
@@2:
        cmp     al,cNextpage
        jne     @@3
        add     p,64000
        mov     edi,p
        mov     y,edi
        jmp     @@l
@@3:
        cmp     al,cEnd
        je      @@weg
                                        ;font schreiben
        push    esi

        movzx   ebx,al
        imul    ebx,6
        mov     esi,f_header[ebx].f_pos
        add     esi,font

        push    edi

        movzx   edx,f_header[ebx].f_x
        mov     ch,f_header[ebx].f_y
@@y_l:
        mov     cl,dl
@@x_l:
        movsb

        dec     cl
        jnz     @@x_l

        add     edi,320
        sub     edi,edx ;f_x

        dec     ch
        jnz     @@y_l

        pop     edi
        ;inc     edx
        add     edi,edx ;f_x

        pop     esi

        jmp     @@l

@@weg:  ret
fontwr endp


init_mul320     proc    near

                mov     ecx,19
@@0:
                mov     mul320[ecx*4+200*4],64000-320
                dec     ecx
                jns     @@0

                mov     ecx,199
@@1:
                imul    eax,ecx,320
                mov     mul320[ecx*4],eax
                dec     ecx
                jns     @@1

@@weg:          ret
init_mul320     endp

init_mul255     PROC
                lea     edi,mul255
                xor     bl,bl

@@mul_loop2:
                xor     cl,cl
@@mul_loop:
                mov     al,cl
                mul     bl
                mov     al,ah
                or      al,al
                jnz     @@ok
                inc     al
@@ok:
                stosb
                inc     cl
                jnz     @@mul_loop
                inc     bl
                jnz     @@mul_loop2
                ret
init_mul255     ENDP


waitborder      proc
if bla gt 0
                push    ax
                push    dx
                mov     dx,3dah
wbr2:           in      al,dx
                test    al,8
                jz      wbr2
                pop     dx
                pop     ax
else
                mov     eax,oldcount
                add     eax,14
@@0:            cmp     eax,maincount
                jg      @@0
                mov     eax,maincount
                mov     oldcount,eax
endif
                ret
waitborder      endp



;        for(y=0;y<199;y++) {
;                video=(byte *)(0xA0000+320*y);
;                for(x=0;x<319;x++) {
;                        int o=x+320*y;
;                        int ox=(*(Height[hpage]+o) - *(Height[hpage]+o+1));
;                        int oy=(*(Height[hpage]+o) - *(Height[hpage]+o+320));
;                        int c=128 - ox;
;                        if(c < 0)
;                                c=0;
;                        else if(c > 255)
;                                c=255;
;                       *(video++)=(*(back+(ox >> 3) + x + ((oy >> 3) + y)*320) * c) >> 8;
water2virtual   PROC
                mov     edi,virtual_screen
                mov     esi,height1_pointer
                ;mov     ebp,background
              xor ebp,ebp
@@drawing_loop:
;                StartTSC
                mov     ebx,[esi]       ;u(1)  pair  1 cycle
                mov     ecx,128         ;v(1)
                mov     eax,ebx         ;u(1)  pair 1 cycle
                nop                     ;v(1)
                sub     ebx,[esi + 1*4]   ; deltax in ebx   ;u (2) pair 2 cycles
                sub     eax,[esi + 320*4] ; deltay in eax   ;v (2)
                sub     ecx,ebx           ;u (1) pair 1 cycle
                jns     @@not_below_0     ;v (1)
                xor     ecx,ecx
@@not_below_0:
                cmp     ecx,255         ;u(1) pair to 1 cycle
                jbe     @@not_above255  ;v(1)
                mov     ecx,255
@@not_above255:
                sar     eax,5                   ; deltay >> 5    u(1) p2 1 cycle
                mov     color_select,cl         ;                v(1)
                sar     ebx,5                   ; deltax >> 5    u(1) p2 1 cycle
                mov     edx,ebp                 ;                v(1)
            add edx,background
                mov     ecx,dword ptr mul320[eax*4] ; multiply dy with 320 u(1)
                add     edx,eax                 ; v (1)
                mov     ecx,eax                 ; u (1) pairs to 1 cycle
                xor     eax,eax                 ; v (1)
                mov     al,color_select         ; u (1) pairs to 1 cycle
                add     edx,ebx                 ; v (1)
                sal     ax,8           ; u  (1) pairs to 1 cycle
                inc     ebp            ; v  (1)
                add     al,[edx]        ; u  (2)
                mov     al,mul255[eax]  ; u   (2)
                add     esi,4           ; v (1)
                mov     [edi],al ; u (7) ???????
                inc     edi      ; v (1)
;                EndTSC
                cmp     ebp,64000-1*320;offset background+63680
                jb      @@drawing_loop

                ret
water2virtual   ENDP



;         int             newh;
;         int             npage=hpage^1;
;         int             val1,val;
;         for(y=1; y<199; y++) {
;            val1=y*320;
;            for(x=1; x < 319; x++) {
;               val=val1+x;
;               *(Height[npage]+val)=((*(Height[hpage]+val+1) +
;                                    *(Height[hpage]+val-1) +
;                                    *(Height[hpage]+val+320) +
;                                    *(Height[hpage]+val-320) ) >> 1) -
;                                    *(Height[npage]+val);
;               *(Height[npage]+val)=*(Height[npage]+val) - (*(Height[npage]+val) >> density);
calc_water      PROC
                mov     edi,height2_pointer     ; get the dest heighttab
                add     edi,320*4+4             ; let 1 pix free each side
                mov     esi,height1_pointer     ; get the source heights
                add     esi,320*4+4             ; the pix free stuff
                mov     edx,198                 ; do it for 198 rows
@@outer_calc:
                   mov     ecx,318              ; 318 pixel each line
   @@inner_calc:
                      mov     eax,[esi-320*4]   ; new value =  (1) u
                      mov     ebx,[esi-4]       ;              (1) v
                      add     eax,[esi+4]
                      add     ebx,[esi+320*4]
                      add     eax,ebx
                      add     esi,4

                      sar     eax,1
                      sub     eax,[edi]           ;(21)
                      mov     ebx,eax
                      sar     ebx,density
                      sub     eax,ebx
                      mov       [edi],eax
                      add     edi,4
                      dec     ecx
                      jnz     @@inner_calc
                   add     esi,2*4
                   add     edi,2*4
                   dec     edx
                   jnz     @@outer_calc
                ret
calc_water      ENDP


change_heights  PROC
                mov     eax,height1_pointer
                mov     ebx,height2_pointer
                xchg    eax,ebx
                mov     height1_pointer,eax
                mov     height2_pointer,ebx
                ret
change_heights  ENDP



scale1          PROC
                mov     esi,[picpointer]
                mov     edi,virtual_screen
                mov     eax,320                 ; select dest. column
                sub     eax,destwid
                mov     dest_rowwid,eax         ; store dist to next row
                shr     eax,1
                add     edi,eax
                mov     eax,200                 ; select dest. row
                sub     eax,desthgt
                shr     eax,1
                mov     bx,320
                mul     bx
                add     edi,eax

                mov     eax,320                 ; select scr. column
                sub     eax,scrwid
                shr     eax,1
                add     esi,eax
                mov     eax,200                 ; select scr. row
                sub     eax,scrhgt
                shr     eax,1
                mov     bx,320
                mul     bx
                add     esi,eax

                mov     eax,scrhgt              ; calc fixpoint add y val
                mov     ebx,desthgt
                shl     eax,16
                xor     edx,edx
                div     ebx
                mov     y_step,eax              ; store it in y_step
                mov     eax,scrwid              ; calc fixpoint add x val
                mov     ebx,destwid
                shl     eax,16
                xor     edx,edx
                div     ebx
                mov     ecx,eax                 ; store it in ecx

                mov     scry,0
                mov     y_counter,0             ; set line counter 2 zero
                                                ; outer loop
@@column_loop:
                xor     ebp,ebp                 ; set the x counter 2 zero
                mov     edx,destwid             ; init x_counter (inner loop)
@@row_loop:
                mov     ebx,ebp
                shr     ebx,16
                mov     al,[esi+ebx]
                or      al,al
                jz      @@no_pix
                mov     [edi],al
@@no_pix:
                inc     edi
                add     ebp,ecx
                dec     edx
                jnz     @@row_loop

                add     edi,dest_rowwid
                mov     eax,scry
                add     eax,y_step
                mov     ebx,eax
                shr     eax,16
                mov     edx,320
                mul     dx
                add     esi,eax
                and     ebx,0ffffh
                mov     scry,ebx
                inc     y_counter
                mov     eax,desthgt
                cmp     y_counter,eax
                jne     @@column_loop

                ret
scale1          ENDP

logos2bg        PROC
                mov     esi,picpointer
                mov     edi,background
                mov     ecx,64000
@@logo2back:
                mov     al,[esi]
                inc     esi
                or      al,al
                jz      @@no_pixel
                mov     [edi],al
@@no_pixel:
                inc     edi
                dec     ecx
                jnz     @@logo2back
                ret
logos2bg        ENDP



scale&water     PROC
                mov     al,scale_flag
                or      al,al
                jnz     no_scale
                call    water2virtual
                call    scale1
                add     scrhgt,25
                add     scrwid,25
                cmp     scrwid,320
                jne     @@nochange
                mov     al,scale_flag
                xor     al,1
                mov     scale_flag,al
                call    set_heights
                mov     timecounter,70
@@nochange:
                ret
no_scale:
                cmp     al,1
                jne     @@fade
                call    logos2bg
                call    water2virtual
                dec     timecounter
                jnz     @@no_change2
                mov     scale_flag,2
                mov     timecounter,60
                call    set_heights
@@no_change2:
                ret

@@fade:
                call    water2virtual
                dec     timecounter
                jnz     @@no_change3
                mov     scrwid,120
                mov     scrhgt,0
                mov     destwid,320
                mov     desthgt,200
                mov     scale_flag,0
                dec     maincounter
                add     picpointer,64000
                add     scantabpointer,3000*4
@@no_change3:
                ret
scale&water     ENDP




scan_font       PROC

                mov     ebp,4;3
                mov     esi,picpointer
                mov     edi,scantabpointer   ; set pointer to tab
@@l:

                mov     ecx,320               ; set value to store in heighttab
                mov     edx,1                   ; set indexpointer for tab
                xor     ebx,ebx                 ; reset counter
scan_loop:
                mov     al,[esi+ecx]
                or      al,al
                jnz     @@fontpix
                xor     eax,eax
                mov     al,[esi+ecx-320]
                add     al,[esi+ecx-1]
                adc     ah,0
                add     al,[esi+ecx+1]
                adc     ah,0
                add     al,[esi+ecx+320]
                adc     ah,0
                or      eax,eax
                jz      @@fontpix
                mov     eax,ecx
                shl     eax,2
                mov     [edi+edx*4],eax
                inc     ebx
                inc     edx
@@fontpix:
                inc     ecx
                cmp     ecx,(64000-320)
                jb      scan_loop
                mov     [edi],ebx

                add     esi,64000
                add     edi,3000*4

                dec     ebp
                jnz     @@l

                ret
scan_font       ENDP



set_heights     PROC
                mov     esi,scantabpointer
;                mov     esi,offset scantab
                mov     edi,height1_pointer
                mov     ecx,[esi]
                add     esi,4
set_height:
                lodsd
                mov     dword ptr [edi+eax],400
                loop    set_height
                ret
set_heights     ENDP




if pmw gt 0
;
.data
;

if bla gt 0
handle_si dw ?                          ;pmode/w
handle_di dw ?

membase dd ?
memtop  dd ?
endif

endif


;include greeting.inc
greetinx label byte
include greets.dat
;include greetin1.inc
;include greetin2.inc
;include greetin3.inc



;mainstuff
maincounter     db      4
timecounter     db      ?
oldcount        dd      0

picpointer      dd      ?
scantabpointer  dd      ?
;temppointer1    dd      ?
;temppointer2    dd      ?
;tempcounter     db      ?

;scaling stuff
destwid         dd      320
desthgt         dd      200
scrwid          dd      120
scrhgt          dd      0
dest_rowwid     dd      ?
scry            dd      ?
y_step          dd      ?
y_counter       dd      ?
scale_flag      db      0



;water stuff
color_select    db      ?
                align   2
;multiplier      dw      320
;zero_sel        dw      ?
                align   4
mul255          db      256*256 dup(?)
mul320          dd      220 dup(?)

height1_pointer dd      ?
height2_pointer dd      ?
;delta_x         dd      ?
;delta_y         dd      ?
;bg_counter      dd      ?

;the screens
virtual_screen  dd      ?
background      dd      ?
bgpic           dd      ?
palette         dd      ?

if pmw eq 0
code32  ends
endif

if bla gt 0
end start
else
end
endif
