Unit CataLib;
Interface
uses midas, mconfig, vgatext,mfile, mplayer, modp, errors,crt;


var
    configured : integer;
    module : PmpModule;
    i, error, isConfig : integer;


Procedure SetupMidas;
Procedure PlayMusic;
Procedure StopMusic;

Implementation

Procedure SetupMidas;
BEGIN
    midasSetDefaults;
    configured := midasConfig;
    midasSaveConfig('MIDAS.CFG');
    vgaSetMode($03);
End;

Procedure PlayMusic;
BEGIN

    error := fileExists('MIDAS.CFG', @isConfig);
    if error <> OK then
        midasError(error);
    midasSetDefaults;                   { set MIDAS defaults }
    midasLoadConfig('MIDAS.CFG');       { load configuration }
    midasInit;                          { initialize MIDAS Sound System }
    { Convert command line argument to ASCIIZ and load module: }
    module := midasLoadModule('amu-lisi.mod', @mpMOD, NIL);
    midasPlayModule(module, 0);         { start playing }
END;


Procedure StopMusic;
Begin
    midasStopModule(module);            { stop playing }
    midasFreeModule(module);            { deallocate module }
    midasClose;                         { uninitialize MIDAS }
End;

END.
