/***************************************************************************
 * trans64.c          version 2.2                                          *
 *                                                                         *
 * Lowlevelroutines for transfer 1541-PC                                   *
 *                                                                         *
 * Copyright (C) 1994/95  Bernhard Schwall                                 *
 *                                                                         *
 * This file is distributed WITHOUT ANY WARRANTY; without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.        *
 ***************************************************************************/

#include <dos.h>
#ifdef __GNUC__
#include <pc.h>
#define near
#endif
#include "trans64.h"

#ifdef _MSC_VER
#pragma warning(disable: 4761)
#define inportb _inp
#define outportb _outp
int peek(int iSeg, int iOffs) {
  return *(int __far*)(((long)iSeg << 16) | iOffs);
}
#endif

static int PortAdr;                        /* address of selected port     */
static int WC;                             /* Clock                        */
static int WD;                             /* Data                         */
static int WA;                             /* ATN                          */

static int Fehler;

static byte Byte94, Byte95, ByteA3;        /* flags for transfer (see C64) */
static byte Prt;                           /* contents of the port         */
static byte AnzOpen;                       /* number of open channels      */
static byte Tabelle[16][3];                /* for open                     */

static void near Eins(byte Value);
static void near All1(void);

static unsigned long TimeOut;

#define GetData   (((inportb(PortAdr) & WD) > 0) ? 0 : 1)

#define GetClock  (((inportb(PortAdr) & WC) > 0) ? 0 : 1)

#define GetATN    (((inportb(PortAdr) & WA) > 0) ? 0 : 1)

void WaitHI(byte len){                     /* delay (256*len)/1.193 ms     */
  byte kt, j1;
  outportb(0x43,0xa2);
  outportb(0x42,len);                      /* (256*len)/1.193 ms delay     */
  kt = inportb(0x61);
  outportb(0x61,kt | 1);                   /* start with bit 0 port 61 = 1 */
  outportb(0x61,kt);
  do {
    j1 = inportb(0x42);                    /* 255 when ready               */
  } while (j1 < 250);
}

void WaitLO(byte len){                     /* delay len/1.193 ms           */
  byte kt, j1;

  outportb(0x43,0x92);
  outportb(0x42,len);
  kt = inportb(0x61);
  outportb(0x61,kt | 1);                   /* start                        */
  outportb(0x61,kt);                       /* reset timer                  */
  do{
    j1 = inportb(0x42);                    /* 255 when ready               */
  } while (j1 < 250);
}

void near SEI(byte Value){
  byte ka;
  do{                                      /* in C64 SEI !!                */
    ka = inportb(0x40);                    /* mode timer = LB/HB           */
    ka = inportb(0x40);                    /* query 2.byte = HB            */
  } while (ka < Value);
}

void Keyboard(byte on){                    /* turn keyboard on and off     */
  if (on == 0){
    outportb(0x64, 0xad);
  }
  else{
    outportb(0x64, 0xae);
  }
}

void IECopen(byte Geraet, byte *SekAdr, char *Text){
  Fehler = 0;
  if (*SekAdr > 127){
    Fehler = 4;
    return;
  }
  if (*Text == 0){
    return;
  }
  Listen(Geraet);
  if (Fehler != 0){
    if (Fehler == 10) Fehler = 1;        /* timeout => wrong device number */
    CLRCH();
    return;
  }
  *SekAdr |= 0xf0;
  Seklist(*SekAdr);
  if (Fehler != 0){
    CLRCH();
    return;
  }
  while (*Text != 0){
    IECout(*Text++);
    if (Fehler != 0) break;
  }
  if (Fehler != 0){
    CLRCH();
    return;
  }
  Unlisten();
  WaitHI(0x10);                            /* 3,4 ms delay                 */
}

void CLRCH(){
  int xx = Fehler;
  Fehler = 0;
  Unlisten();
  Untalk();
  Fehler = xx;
}

void Talk(byte Value){
  Fehler = 0;
  Eins(Value | 0x40);
}

void Listen(byte Value){
  Fehler = 0;
  Eins(Value | 0x20);
}

void near Eins(byte Value){
  if (Byte94 > 0){
    ByteA3 = 1;
    ByteOut(Byte95);
    Byte94 = 0;
    ByteA3 = 0;
  }
  if (Fehler != 0) return;                 /* error in ByteOut             */
  Byte95 = Value;
  Data(1);
  ATN(0);
  Clock(0);
  ByteOut(Value);
  WaitLO(50);
}

void SekTalk(byte Value){                  /* Secondarry address to TALK   */
  int t;
  Fehler = 0;
  SEI(50);
  Byte95 = Value;
  Data(1);
  WaitLO(20);
  Clock(0);
  ByteOut(Value);
  if (Fehler != 0) return;
  Data(0);
  WaitLO(80);
  ATN(1);
  WaitLO(30);
  Clock(1);
  t = 0;
  do{                                      /* wait until Clock = 0         */
    t++;
  }while ((GetClock == 1) && (t < TimeOut));
  if (t > (TimeOut-1)){
    Fehler = 10;
    All1();
  }
}

void Seklist(byte Value){                  /* Secondarry address to LISTEN */
  Fehler = 0;
  Byte95 = Value;
  Data(1);
  WaitLO(10);
  Clock(0);
  ByteOut(Value);
  WaitLO(50);
  ATN(1);
}

void Unlisten(){
  Fehler = 0;
  Eins(0x3f);
  All1();
}

void near All1(){
  ATN(1);
  WaitLO(50);                              /* delay (should be 40 s)      */
  Clock(1);
  Data(0);
}

void Untalk(){
  Fehler = 0;
  Clock(0);
  ATN(0);
  Eins(0x5f);
  All1();
}

void Data(byte Value){
  if (Value == 0) Prt |= WD;
  else            Prt &= ~WD;
  outportb(PortAdr,Prt);
}

void Clock(byte Value){
  if (Value == 0) Prt |= WC;
  else            Prt &= ~WC;
  outportb(PortAdr,Prt);
}

void ATN(byte Value){
  if (Value == 0) Prt |= WA;
  else            Prt &= ~WA;
  outportb(PortAdr,Prt);
}

void IECout(byte Value){
  if (Byte94 > 0){
    ByteOut(Byte95);
  }
  else
    Byte94 = 1;
  Byte95 = Value;
}

void ByteOut(byte Value){
  byte kt, j1, Bit;
  int t;
  Fehler = 0;
  Data(1);
  WaitLO(20);
  Clock(0);
  outportb(0x43,0xa2);
  outportb(0x42,10);                       /* changed 11.05.1995 */
  kt = inportb(0x61);
  outportb(0x61,kt | 1);
  outportb(0x61,kt);
  do{
    j1 = inportb(0x42);
  } while ((GetData == 1) && (j1 < 240));
  if (j1 >= 240){
    Fehler = 5;
    All1();
    return;
  }
  /*SEI(25);*/         /* removed 09.06.1995 */ /* new 31.05.1995 */
  Clock(1);
  if (ByteA3 > 0){
    outportb(0x43,0xa2);
    outportb(0x42,150);
    kt = inportb(0x61);
    outportb(0x61,kt | 1);
    outportb(0x61,kt);
    t = 0;
    do{
      if (inportb(0x42) > 241){
        t++;
        outportb(0x42, 150);
      }
    } while ((GetData == 0) && (t < TimeOut));
    if (t > (TimeOut-1)){
      Fehler = 10;
      All1();
      return;
    }
    outportb(0x42, 150);
    t = 0;
    do{
      if (inportb(0x42) > 241){
        t++;
        outportb(0x42, 150);
      }
    } while ((GetData == 1) && (t < TimeOut));
    if (t > (TimeOut-1)){
      Fehler = 10;
      All1();
      return;
    }
  }
  outportb(0x43,0xa2);
  outportb(0x42,150);
  kt = inportb(0x61);
  outportb(0x61,kt | 1);
  outportb(0x61,kt);
  t = 0;
  do{
    if (inportb(0x42) > 241){
      t++;
      outportb(0x42, 150);
    }
  } while ((GetData == 0) && (t < TimeOut));
  if (t > (TimeOut-1)){
    Fehler = 10;
    All1();
    return;
  }
  for (Bit=0; Bit<8; Bit++){
    Clock(0);
    WaitLO(100);                                /* changed 09.06.1995    */
    Data(Value & 1);
    Value >>= 1;
    Clock(1);
    WaitLO(50);                                 /* changed 12.05.1995    */
  }
  Clock(0);

  outportb(0x43,0xa2);
  outportb(0x42,5);
  kt = inportb(0x61);
  outportb(0x61,kt | 1);
  outportb(0x61,kt);
  do{
    j1 = inportb(0x42);
  } while ((GetData == 1) && (j1 < 240));       /* wait for data = 0     */
  if (j1 > 239){
    Fehler = 10;
    All1();
  }
}

byte IECin(){
  byte kc, kt, A4=0;
  int i=0, t;
  Fehler = 0;
  outportb(0x43,0xa2);
  outportb(0x42,150);
  kt = inportb(0x61);
  outportb(0x61,kt | 1);
  outportb(0x61,kt);
  t = 0;
  do{
    if (inportb(0x42) > 241){
      t++;
      outportb(0x42, 150);
    }
  } while ((GetClock == 0) && (t < TimeOut));
  if (t >= TimeOut){
    Fehler = 11;
    All1();
    return 0;
  }
  WaitLO(50);
  SEI(40);
  Data(1);
  outportb(0x43,0xa2);                    /* HB read/write, MF 2          */
  outportb(0x42,1);                       /* HB = 1, = 215 s             */
  kt = inportb(0x61);
  outportb(0x61, kt | 1);                 /* start MF 2 Bit 0 Port 61=1   */
  outportb(0x61, kt);                     /* write back original value    */
  do{
    kc = GetClock;
  } while ((kc == 1) && (inportb(0x42) < 250));      /* until Clock = 0   */
  if (kc == 1){                      /* Clock = 1 => last byte in message */
    Fehler = 64;
    Data(0);
    WaitLO(120);
    Data(1);
    outportb(0x43,0xa2);                   /* HB read/write, MF 2          */ 
    outportb(0x42,1);                      /* HB = 1, = 215 s             */ 
    kt = inportb(0x61);
    outportb(0x61, kt | 1);                /* start MF 2 Bit 0 Port 61=1   */
    outportb(0x61, kt);                    /* write back original value    */
    do{
      kc = GetClock;
    } while ((kc == 1) && (inportb(0x42) < 250));     /* until Clock = 0   */
    if (kc == 1){
      Fehler = 11;
      All1();
      return 0;
    }
  }
  for (i=0; i<8; i++){
    A4 >>= 1;
    t = 0;
    do{
      t++;
    } while ((GetClock == 0) && (t < TimeOut));       /* until Clock = 1   */
    if (t >= TimeOut){
      Fehler = 11;
      All1();
      return 0;
    }
    if (GetData == 1) A4 |= 128;
    t = 0;
    do{
      t++;
    } while ((GetClock == 1) && (t < TimeOut));       /* until Clock = 0   */
    if (t >= TimeOut){
      Fehler = 11;
      All1();
      return 0;
    }
  }
  WaitLO(30);
  Data(0);
  if (Fehler == 64){                   /* EOF                          */
    WaitLO(200);                       /* 215 s delay                 */
    Clock(1);
    Data(1);
  }
  return A4;
}

void Open64(byte Kanal, byte Geraet, byte *SekAdr, char *Text){
  byte g,s;
  if (Kanal == 0){                         /* logFileNr missing            */
    Fehler = 6;
    return;
  }
  GetFileTab(Kanal, &g, &s);
  if (Fehler == 0){                        /* still open                   */
    Fehler = 7;
    return;
  }
  Fehler = 0;
  if (AnzOpen >= 10){                      /* too much files open          */
    Fehler = 8;
    return;
  }
  *SekAdr |= 0x60;
  s = *SekAdr;
  IECopen(Geraet, SekAdr, Text);
  if (Fehler == 0){
    AnzOpen++;
    Tabelle[Kanal][0] = Kanal;
    Tabelle[Kanal][1] = s;
    Tabelle[Kanal][2] = Geraet;
  }
}

void Close64(byte Kanal){
  byte Geraet, SekAdr;
  GetFileTab(Kanal, &Geraet, &SekAdr);
  if (Fehler == 12){
    Fehler = 0;                           /* not found = ready             */
    return;
  }
  if (SekAdr < 128){
    Fehler = 0;
    Listen(Geraet);
    if (Fehler == 0){
      Seklist((SekAdr & 0xef) | 0xe0);
      if (Fehler == 0) Unlisten();
    }
  }
  AnzOpen--;
  Tabelle[Kanal][0] = 0;
}

byte GetFileTab(byte Kanal,byte *Geraet,byte *SekAdr){
  Fehler = 0;                              /* S=No. or entrys              */
  if ((Kanal > 15) || (Tabelle[Kanal & 15][0] == 0)){ /* not found         */
    Fehler = 12;
    *Geraet = 0;
    *SekAdr = 0;
    return 0;
  }
  else{
    *SekAdr = Tabelle[Kanal][1];
    *Geraet = Tabelle[Kanal][2];
  }
  return Kanal;
}

byte Get64(byte Kanal){                         /* Get #Byte            */
  byte xx, GetA, Geraet, SekAdr;
  GetFileTab(Kanal, &Geraet, &SekAdr);
  Talk(Geraet);
  SekTalk(SekAdr);
  GetA = IECin();
  WaitLO(100);
  xx = Fehler;
  Untalk();
  Fehler = xx;
  return GetA;
}

unsigned int GetBlock64(byte Kanal, byte *text, unsigned int count){
  unsigned int Anzahl;
  byte Geraet, SekAdr;
  GetFileTab(Kanal, &Geraet, &SekAdr);
  Talk(Geraet);
  SekTalk(SekAdr);
  for (Anzahl=0; Anzahl < count; Anzahl++){
    *text++ = IECin();
    if (Fehler > 0) break;
  }
  return (Anzahl+1);
}

void Print64(byte Kanal, byte *text, unsigned int count){ /* jsr FFD2   */
  byte xx, Geraet, SekAdr;
  GetFileTab(Kanal, &Geraet, &SekAdr);
  if (Fehler != 0) return;
  Listen(Geraet);
  if (Fehler != 0) return;
  Seklist(SekAdr);
  if (Fehler != 0) return;
  while (count-- > 0) {
    IECout(*text++);
    if ((Fehler & 15) > 0) break;
  }
  /*WaitLO(100);*/          /* removed 09.06.1995 */
  xx = Fehler;
  Unlisten();
  Fehler = xx;
}

void Message64(byte Geraet, char *Text){
  byte xx, SekAdr;
  *Text = 0;
  SekAdr = 15 | 0x60;
  Open64(10,Geraet, &SekAdr,"");
  if (Fehler > 0) return;
  Talk(Geraet);
  if (Fehler != 0){
    xx = Fehler;
    Close64(10);
    Fehler = xx;
    return;
  }
  SekTalk(SekAdr);
  if (Fehler != 0){
    xx = Fehler;
    Close64(10);
    Fehler = xx;
    return;
  }
  do{
    xx = IECin();
    if (Fehler > 0) break;
    if (xx < 122) *Text++ = xx;
  }while (1 == 1);
  WaitLO(100);
  xx = Fehler;
  Untalk();
  Close64(10);
  Fehler = xx;
  *Text = 0;
}

void SendCommand(byte Geraet, char *text){
  byte i, SekAdr;
  SekAdr = 15 | 0x60;
  Open64(10,Geraet, &SekAdr,text);
  if (Fehler>0) return;
  if (*text == 'U'){
    text++;
    if ((*text == 'I') || (*text == '.')){
      /* bei reset mind. 4 Sekunden warten */
      for (i=0; i<118; i++){
        WaitHI(198);                       /* 118*42,5ms nearly 5 sec      */
      }
    }
  }
  Close64(10);
}

byte Error(){
  return Fehler;
}

void SetError(byte Value){
  Fehler = Value;
}

unsigned long GetTimeOut(){
  return TimeOut;
}

void GetCableValues(byte *aWA, byte *aWC, byte *aWD, unsigned int *aPortAdr){
  *aWA = WA;
  *aWC = WC;
  *aWD = WD;
  *aPortAdr = PortAdr;
}

int Init64(int PortNr, byte Cable){
  int i;
  byte kt;

  if (PortNr < 5) {
    PortNr--;                         /* LPT1 = 40:08/09, LPT2 = 40:0A/0B  */
#ifdef __GNUC__
    PortAdr = (*(short *)(0xe0000000+0x408+2*PortNr))+2;
#else
    PortAdr = peek(0x40,0x08+2*PortNr)+2;
#endif
  }
  else PortAdr = PortNr+2;
  if (PortAdr == 2) return 0;         /* 2 because of adsr+2               */
  /* outportb(PortAdr, inportb(PortAdr) & ~0x20); */
                                      /* set bidirectional port to output  */
  Byte94 = inportb(PortAdr-2);        /* test if port available            */
  outportb(PortAdr-2, ~Byte94);
  if (Byte94 == inportb(PortAdr-2)) return 0;
  Prt = 0xc4;
  outportb(PortAdr, Prt);             /* ATN, Clock and Data = 1           */
  outportb(PortAdr-2, 0);             /* set dataport to 0 for 1541P-Kabel */
  outportb(0x61, inportb(0x61) & 0xfe);
                                      /* reset timer                       */
  AnzOpen = 0;                        /* no file open                      */
  for (i=1; i<=15; i++){
    Tabelle[i][0] = 0;
  }
  Byte94 = 0;                         /* set all flags 0                   */
  Byte95 = 0;
  ByteA3 = 0;
  if (Cable == 0){                    /* DISK64E cable   PC  1541          */
    WC = 1;                           /* Clock = Bit 0,   1    4           */
    WD = 2;                           /* Data  = Bit 1,  14    5           */
    WA = 8;                           /* ATN   = Bit 3   17    3           */
  }
  else{                               /* X1541 cable     PC  1541          */
    WC = 2;                           /* Clock = Bit 1   14    4           */
    WD = 8;                           /* Data  = Bit 3   17    5           */
    WA = 1;                           /* ATN   = Bit 0    1    3           */
  }

  outportb(0x43,0xa2);
  outportb(0x42,150);
  kt = inportb(0x61);
  outportb(0x61,kt | 1);
  outportb(0x61,kt);
  TimeOut = 0;
  do{
    TimeOut++;
  } while (inportb(0x42) < 240);

  TimeOut <<= 1;                      /* new 12.05.1995                    */

  Fehler = 0;
  return PortAdr;
}

