Uses BlendGif,Crt;

Var
  pal0,pal1,pal2 : PaletteT;
  i : Byte;
  
Procedure waitvsync; Assembler;
Asm
  MOV   DX,3DAh
  @Wait:
  In    AL,DX
  Test  AL,08h
  JZ    @Wait
  @Retr:
  In    AL,DX
  Test  AL,08h
  JNZ   @Retr
End;

Procedure ModeX; Assembler;
  Asm
    mov AX,0013h                (* Mode 13h setzen *)
    Int 10h
    
    mov DX,3c4h                 (* Timing Sequenzer *)
    mov AL,4                    (* Register 4 (Memory Mode): *)
    out DX,AL                   (* Bit 3 lschen -> Chain4 aus *)
    Inc DX
    In AL,DX
    And AL,0f7h
    Or AL,4h                    (* Bit 2 setzen -> Odd/Even Mode aus *)
    out DX,AL
    Dec DX
    
    mov AX,0f02h                (* Register 2 (Write Plane Mask): *)
    out DX,AX                   (* 0fh: alle Planes beim Schreiben ein *)
    mov AX,0a000h               (* Bildschirmspeicher lschen *)
    mov ES,AX
    XOr DI,DI
    XOr AX,AX
    mov CX,0ffffh
    cld
    rep stosw
    
    mov DX,3D4h                 (* CRTC *)
    mov AL,14h                  (* Register 14h  (Underline Row Adress): *)
    out DX,AL
    Inc DX
    In AL,DX                    (* Bit 6 lschen -> Doubleword adress. aus *)
    And AL,0bfh
    out DX,AL
    Dec DX
    mov AL,17h                  (* Register 17h (CRTC Mode): *)
    out DX,AL                   (* Bit 6 setzen -> Byte Mode ein *)
    Inc DX
    In AL,DX
    Or AL,40h
    out DX,AL
    
    mov DX,3D4h                 (* in erweieterten 400-Zeilen-Modus *)
    mov AL,9                    (* CRTC Register 9 (Maximum Row Adress) *)
    out DX,AL                   (* selektieren *)
    Inc DX                      (* Wert auslesen *)
    In AL,DX
    And AL,01110000b            (* Bit 7 und 3:0 lschen *)
    out DX,AL                   (* und zurckschreiben *)
  End;

Procedure Display(Screen:Pointer; Nr: Byte);
   Var p,X,Y : Word;
   Begin
     For p := 0 To 3 Do
     Begin
       Port[$03c4] := 2;
       Port[$03c5] := 1 ShL p;
       For Y := 0 To 200 Do
         For X := 0 To 79 Do
           Mem[$A000:X+Y*160+nr*80{+(p mod 2)*80}] := Mem[Seg(Screen^):X*4+Y*320+p] Or (nr*128);
     End;
   End;

Procedure BlendIt(pal1,pal2:PaletteT;s:Byte);
   Var i : Byte;
     j : Word;
     pal : PaletteT;
   Begin
     For i := 0 To s Do
     Begin
       waitvsync;
       For j := 0 To 255*3 Do Pal[j] := (pal1[j]*(s-i) + pal2[j]*i) Div s;
       SetPal(pal,0,255);
     End;
   End;

Begin
  ModeX;
  LoadGif('blend1.gif',pal1);
  FillChar(pal1[3*128],127*3,0);
  Display(VScreen,0);
  LoadGif('blend2.gif',pal2);
  Move(pal2,pal2[3*128],127*3);
  FillChar(pal2,127*3,0);
  Display(VScreen,1);
  SetPal(pal1,0,255);
  ReadLn;
  Delay(300);
  
  Blendit(pal1,pal2,128);
  
  LoadGif('blend3.gif',pal1);
  Display(VScreen,0);
  FillChar(pal1[3*128],127*3,0);
  
  Delay(300);
  Blendit(pal2,pal1,200);
  
  LoadGif('blend4.gif',pal2);
  Display(VScreen,1);
  Move(pal2,pal2[3*128],127*3);
  FillChar(pal2,127*3,0);
  
  Delay(300);
  For i := 0 To 3 Do
  Begin
    Blendit(pal1,pal2,51);
    Blendit(pal2,pal1,51);
  End;
  
  ReadLn;
  Asm
    mov AX,$0003
    Int $10
  End;
End.