/* Copyright (C) 1994 Christian Wagner, Tale Software.
 * All rights reserved.
 */

#include <conio.h>		/* keyboard fct. */
#include <ctype.h>		/* char lowercase conversion */
#include <mem.h>		/* for standard fades init */
#include <stdio.h>		/* standard I/O fct. */
#include <stdlib.h>		/* random number fct. */
#include <time.h>		/* for randomize() */

#include "tgdlp4.h"		/* TGDLP4 functions */
#include "tgdsupp.h"		/* TGD support fct. */
#include "lp4supp.h"		/* LP4 file support fct. */

/* main() error codes (returned to DOS as errorlevels) */
#define DEMOERR_NO 0
#define DEMOERR_BADVGA 1
#define DEMOERR_LOAD 2
#define DEMOERR_NOMEM 3

/* getch() key ID's */
#define ENTER_KEY 13
#define ESC_KEY 27
#define SPACE_KEY 32
#define CRSR_UP_KEY 72
#define CRSR_DOWN_KEY 80
#define CRSR_LEFT_KEY 75
#define CRSR_RIGHT_KEY 77

/* global variables */
char *filename;
ubyte error=DEMOERR_NO,loaderr;
ubyte allblack[256*3],allwhite[256*3];


/* universal fade in/out ...and I mean UNIVERSAL */
void fade(ubyte frames,ubyte startcol,ubyte colnum,const ubyte *destcoltab,const ubyte *srccoltab)
{ ubyte tempcoltab[256*3];
  uword a,b;
  word coldelta[256*3];

  /* instant fade? */
  if (!frames) { waittof(); rgb6(startcol,colnum,destcoltab); return; };

  /* calculate RGB color deltas per fade step */
  for (a=0;a<=(uword)colnum*3;a+=3)
  { coldelta[a]=((word)destcoltab[a]-(word)srccoltab[a])*520;
    coldelta[a+1]=((word)destcoltab[a+1]-(word)srccoltab[a+1])*520;
    coldelta[a+2]=((word)destcoltab[a+2]-(word)srccoltab[a+2])*520;

    coldelta[a]/=(word)frames;
    coldelta[a+1]/=(word)frames;
    coldelta[a+2]/=(word)frames;
  };

  /* fade */
  for (a=1;a<=frames;a+=1)
  { for (b=0;b<=(uword)colnum*3;b+=3)
    { tempcoltab[b]=srccoltab[b]+(byte)((coldelta[b]*(word)a)/520);
      tempcoltab[b+1]=srccoltab[b+1]+(byte)((coldelta[b+1]*(word)a)/520);
      tempcoltab[b+2]=srccoltab[b+2]+(byte)((coldelta[b+2]*(word)a)/520);
    };
    waittof(); rgb6(startcol,colnum,tempcoltab);
  };

  /* compensate rounding errors */
  waittof(); rgb6(startcol,colnum,destcoltab);
}

/* graphic primitives part: clear presentation box and
 * print new description.
 */
void primclear(char *description)
{
  /* redraw presentation box */
  pen(PEN_F,0); rectangle(30,210,289,359);

  /* clear text */
  pfill(TRUE);
  rectangle(0,370,319,399);
  pfill(FALSE);

  /* print new description */
  bltmode(BM_COLREPLACE|BM_TRANSPARENT); pen(PEN_F,24);
  drawmode(DM_OR);
  prttext("\x0c");
  prttext(description);
  drawmode(DM_SOLID); bltmode(BM_SOLID);
}

ubyte primdemo(bcdescr huge *introbc)
{ ubyte primcolors[256*3]={ 0,0,0, 16,0,32, 0,0,0, 12,0,24 };
  ubyte darkvio[256*3];
  ubyte starspeed[45];
  word starx[45],stary[45],oldstarx[45],oldstary[45];
  word hexagon[]={ 0,370, 10,390, 10,410, 0,430, -10,410, -10,390 };
  word a,b,triangles[6];
  bcdescr huge *primbc=0,huge *prim1bc=0;
  fcdescr huge *primfc=0;
  sincostab far *primsincos;

  /* init fade colormap (fade color = hexagon color) */
  for (a=0;a<=765;a+=3)
  { darkvio[a]=16; darkvio[a+1]=0; darkvio[a+2]=32; };

  /* draw the hexagons */
  pen(PEN_F,6);
  for (a=0;a<10;a+=1)
  { for (b=0;b<15;b+=1)
    { waittof();
      drawpoly(6,hexagon);
      if (a&1) { hexagon[0]-=23; hexagon[2]-=23; hexagon[4]-=23;
		 hexagon[6]-=23; hexagon[8]-=23; hexagon[10]-=23;
	       }
      else { hexagon[0]+=23; hexagon[2]+=23; hexagon[4]+=23;
	     hexagon[6]+=23; hexagon[8]+=23; hexagon[10]+=23;
	   };
    };

    if (a&1) { hexagon[0]+=12; hexagon[2]+=12; hexagon[4]+=12;
	       hexagon[6]+=12; hexagon[8]+=12; hexagon[10]+=12;
	     }
    else { hexagon[0]-=12; hexagon[2]-=12; hexagon[4]-=12;
	   hexagon[6]-=12; hexagon[8]-=12; hexagon[10]-=12;
	 };

    hexagon[1]+=44; hexagon[3]+=44; hexagon[5]+=44;
    hexagon[7]+=44; hexagon[9]+=44; hexagon[11]+=44;
  };

  /* fade into hexagon color */
  fade(140,0,255,darkvio,introbc->cmap);
  /* free tale background bitmap (we only needed the color information) */
  freebc(introbc);


  /* load background pattern */
  filename="lp4demo\\basketgr.lp4";
  primbc=readbc(filename,1,&loaderr);
  if (!primbc) { error=DEMOERR_LOAD; goto primcleanup; };

  /* load pixelz bitmap */
  filename="lp4demo\\pixelz.lp4";
  prim1bc=readbc(filename,1,&loaderr);
  if (!prim1bc) { error=DEMOERR_LOAD; goto primcleanup; };

  /* load galafont */
  filename="lp4demo\\galafnt.lp4";
  primfc=readfc(filename,1,&loaderr);
  if (!primfc) { error=DEMOERR_LOAD; goto primcleanup; };
  /* set galafont as active font */
  font(primfc->tgdfmdescr);

  /* set 320x200 phys. resolution, viewmode 0 */
  waittof(); screenmode(SM_320x200);

  /* patternize background */
  bltbitmap(0,0,0,0,primbc->tgdbmdescr->xsize,primbc->tgdbmdescr->ysize,primbc->tgdbmdescr);
  pattern(0,0,primbc->tgdbmdescr->xsize+1,primbc->tgdbmdescr->ysize+1);
  pfill(TRUE);
  rectangle(0,200,319,399);
  pfill(FALSE);

  /* free pattern */
  freebc(primbc); primbc=0;

  /* draw shadow of presentation box */
  drawmode(DM_OR); pen(PEN_F,2);
  rectangle(40,220,299,369);
  drawmode(DM_SOLID);
  /* draw presentation box */
  pen(PEN_F,0); rectangle(30,210,289,359);

  /* blit pixelz bitmap into presentation box */
  bltmode(BM_COLREPLACE);
  bltpen(PEN_B,0); bltpen(PEN_F,1); pen(PEN_B,0); pen(PEN_F,255);
  bltbitmap(100,265,0,0,prim1bc->tgdbmdescr->xsize,prim1bc->tgdbmdescr->ysize,prim1bc->tgdbmdescr);
  bltmode(BM_SOLID);
  /* free pixelz bm. - we don't need it anymore */
  freebc(prim1bc); prim1bc=0;

  /* pixelz stencil fill --- THIS IS FOR YOU DIRK */
  for (b=3,a=12;a<60;a+=3,b+=4)
  { primcolors[a]=b; primcolors[a+1]=0; primcolors[a+2]=(b>>1)+(b>>2); };
  drawmode(DM_AND);
  for (b=0,a=265;a<=305;a+=1,b=(b+1)&15)
  { pen(PEN_F,b+4); line(100,a,211,a); };
  drawmode(DM_SOLID);

  /* prepare star colors */
  for (b=32,a=60;a<72;a+=3,b+=8)
  { primcolors[a]=b; primcolors[a+1]=b; primcolors[a+2]=b; };

  /* generate random starfield */
  for (a=0;a<45;a+=1)
  { starspeed[a]=(rand()&3)+1;
    starx[a]=(rand()%260)+30;
    stary[a]=(rand()%150)+210;
    oldstary[a]=0;
  };

  /* font colors */
  primcolors[72]=0; primcolors[73]=32; primcolors[74]=48;
  primcolors[75]=0; primcolors[76]=40; primcolors[77]=56;

  /* display some text */
  bltmode(BM_COLREPLACE|BM_TRANSPARENT);
  bltpen(PEN_B,0); bltpen(PEN_F,1); pen(PEN_B,0); pen(PEN_F,24);
  drawmode(DM_OR);
  txtcrsr(0,370);
  prttext("Welcome to the graphics\r\nprimitives section.        <key>");
  drawmode(DM_SOLID); bltmode(BM_SOLID);

  /* show what was prepared */
  fade(140,0,25,primcolors,darkvio);

  while (!kbhit())
  { /* clear old star positions */
    for (a=0;a<45;a+=1)
    { if (oldstary[a]) { pen(PEN_F,0); writepixel(oldstarx[a],oldstary[a]); };
    };

    /* set new star positions and calc next star positions */
    for (a=0;a<45;a+=1)
    { if (!readpixel(starx[a],stary[a])) { pen(PEN_F,starspeed[a]+19); writepixel(starx[a],stary[a]);
					   oldstarx[a]=starx[a]; oldstary[a]=stary[a]; }
      else oldstary[a]=0;

      starx[a]-=starspeed[a];
      if (starx[a]<30) starx[a]+=289-29;
    };

    /* display star positions for one frame */
    waittof();
  };

  if (!getch()) getch();


  /* print line description */
  primclear("Lines (no floating point used)\r\nPress a key.");

  /* prepare line colors */
  for (b=34,a=12;a<36;a+=3,b+=4)
  { primcolors[a]=0; primcolors[a+1]=b; primcolors[a+2]=0; };
  for (b=34,a=36;a<60;a+=3,b+=4)
  { primcolors[a]=b; primcolors[a+1]=0; primcolors[a+2]=0; };
  for (a=60;a<69;a+=3)
  { primcolors[a]=0; primcolors[a+1]=0; primcolors[a+2]=0; };
  primcolors[69]=0; primcolors[70]=47; primcolors[71]=63;
  waittof(); rgb6(4,19,primcolors+12);

  /* lines */
  for (a=0;a<18;a+=1)
  { waittof();
    pen(PEN_F,(a&7)+4); line(30,215+(a<<3),38+(a<<3),359);
  };

  for (a=0;a<18;a+=1)
  { waittof();
    pen(PEN_F,(a&7)+12); line(145+(a<<3),210,289,218+(a<<3));
  };

  for (b=0,a=0;a<4000;a+=50,b=(b+1)&3)
  { primsincos=tgdsincos(a);
    waittof();
    pen(PEN_F,b+20); line((primsincos->cos)/750+160,(primsincos->sin)/1000+285,(primsincos->cos)/2000+160,(primsincos->sin)/2000+285);
  };

  /* color cycling */
  a=1;
  while (!kbhit())
  { framewait(4);
    rgb6(20+a,3-a,primcolors+60);
    if (a) rgb6(20,a-1,primcolors+60+(4-a)*3);
    a=(a+1)&3;
  };

  if (!getch()) getch();


  /* print arc description */
  primclear("Arcs. Sorry - no animation here.\r\nPress a key.");

  /* yellows */
  for (a=0;a<4;a+=1)
  { primcolors[12+a*3]=63-(a<<3); primcolors[13+a*3]=63-(a<<3); primcolors[14+a*3]=0; };
  waittof(); rgb6(4,3,primcolors+12);

  /* arcs */
  pen(PEN_F,4);
  arc(160,285,58,58,0,4000);

  for (a=0,b=0;a<4000;a+=500,b=(b+1)&3)
  { primsincos=tgdsincos(a);
    pen(PEN_F,b+4);
    arc(160+(primsincos->cos/565),285-(primsincos->sin/565),12,12,a-1000,a+1000);
  };

  for (a=0,b=0;a<4000;a+=500,b=(b+1)&3)
  { primsincos=tgdsincos(a);
    pen(PEN_F,b+4);
    arc(160+(primsincos->cos/819),285-(primsincos->sin/819),40,40,a+2000,a+3000);
  };

  if (!getch()) getch();


  /* print rectangle description */
  primclear("Area Functions:\r\nRectangles...              <key>");

  /* set rectangle random colors */
  for (a=12;a<72;a+=3)
  { primcolors[a]=(rand()&15)+16;
    primcolors[a+1]=(rand()&15)+16;
    primcolors[a+2]=(rand()&31)+32;
  };
  waittof(); rgb6(4,19,primcolors+12);

  /* draw rectangles */
  while (!kbhit())
  { for (a=0;a<100;a+=1)
    { pen(PEN_F,rand()%20+4);
      rectangle(rand()%260+30,rand()%150+210,rand()%260+30,rand()%150+210);
    };
  };

  if (!getch()) getch();


  /* print ellipse description */
  primclear("Area Functions:\r\n\Ellipses...                <key>");

  /* set ellipse random colors */
  for (a=12;a<72;a+=3)
  { primcolors[a]=(rand()&31)+32;
    primcolors[a+1]=(rand()&15)+16;
    primcolors[a+2]=(rand()&15)+16;
  };
  waittof(); rgb6(4,19,primcolors+12);

  /* draw ellipses */
  drawreg(30,210,259,149);
  while (!kbhit())
  { for (a=0;a<100;a+=1)
    { pen(PEN_F,rand()%20+4);
      ellipse(rand()%320,rand()%200+200,rand()%60,rand()%60);
    };
  };

  if (!getch()) getch();


  /* reset clip region */
  drawreg(0,200,319,199);
  /* print polygon description */
  primclear("Area Functions:\r\n\Convex Polygons.          <key>");

  /* set triangle random colors */
  for (a=12;a<72;a+=3)
  { primcolors[a]=(rand()&15)+16;
    primcolors[a+1]=(rand()&31)+32;
    primcolors[a+2]=(rand()&15)+16;
  };
  waittof(); rgb6(4,19,primcolors+12);

  /* draw triangles */
  drawreg(30,210,259,149);
  while (!kbhit())
  { for (a=0;a<100;a+=1)
    { pen(PEN_F,rand()%20+4);
      triangles[0]=rand()%320; triangles[1]=rand()%200+200;
      triangles[2]=rand()%320; triangles[3]=rand()%200+200;
      triangles[4]=rand()%320; triangles[5]=rand()%200+200;
      drawpoly(3,triangles);
    };
  };

  if (!getch()) getch();


  /* fade into white */
  fade(210,0,25,allwhite,primcolors);

  /* free used font */
  font(0); freefc(primfc); primfc=0;

primcleanup:
  if (error) { /* free everything if something went wrong */
	       if (primbc) freebc(primbc);
	       if (prim1bc) freebc(prim1bc);
	       if (primfc) freefc(primfc);
	     };
  return(error);
}

ubyte bitmapdemo(void)
{ int pressedkey;
  ubyte allred[256*3];
  uword srcx,srcy;
  word a,b,x,y,ax,ay;
  word talegon[]={ 110,230, 140,230, 120,274, 90,274 };
  bcdescr huge *bitmapbc=0,huge *bitmap1bc=0;

  /* clear menu screen */
  pen(PEN_F,0);
  for (a=0;a<320;a+=2)
  { waittof();
    line(160,600,a,400);
    line(160,600,a+1,400);
  };
  for (a=400;a<799;a+=3)
  { waittof();
    line(160,600,319,a);
    line(160,600,319,a+1);
    line(160,600,319,a+2);
  };
  for (a=319;a>=0;a-=2)
  { waittof();
    line(160,600,a,799);
    line(160,600,a-1,799);
  };
  for (a=799;a>400;a-=3)
  { waittof();
    line(160,600,0,a);
    line(160,600,0,a-1);
    line(160,600,0,a-2);
  };


  /* load violet background pattern */
  filename="lp4demo\\bitmpat.lp4";
  bitmapbc=readbc(filename,1,&loaderr);
  if (!bitmapbc) { error=DEMOERR_LOAD; goto bitmapcleanup; };

  /* hide screen build up */
  waittof(); rgb6(0,255,allblack);
  /* give me 320x200 phys. res. and 640x400 virt. res. */
  waittof(); screenmode(SM_320x200); viewmode(VM_640x400);

  /* do a little pattern fill with the violet pattern */
  bltbitmap(320,0,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);
  pattern(320,0,bitmapbc->tgdbmdescr->xsize+1,bitmapbc->tgdbmdescr->ysize+1);
  pfill(TRUE);
  rectangle(0,0,319,399);
  pfill(FALSE);

  /* create shadowed box */
  drawmode(DM_OR);
  pen(PEN_F,16); rectangle(40,210,280,294);
  drawmode(DM_SOLID);

  /* create red green blue random swirl for tale logo */
  for (a=0;a<3;a+=1)
  { for (x=480;x<512;x+=1)
    { for (y=0;y<32;y+=1)
      { pen(PEN_F,32+(a<<2)+(rand()&3));
	writepixel((a<<5)+x,y);
      };
    };
  };
  /* draw tale logo and fill it with the created random swirl */
  for (a=0;a<3;a+=1)
  { pattern(480+(a<<5),0,32,32);
    pfill(TRUE);
    drawpoly(4,talegon);
    talegon[0]+=40; talegon[2]+=40; talegon[4]+=40; talegon[6]+=40;
  };
  pfill(FALSE);

  /* display lower part of virt. screen */
  viewreg(0,200);
  waittof(); rgb6(0,bitmapbc->cmdescr->colors,bitmapbc->cmap);

  /* build text in invisible upper part of virt. screen */
  bltmode(BM_TRANSPARENT); bltpen(PEN_B,0);
  txtcrsr(0,0);
  prttext("Let's take a look at the bitmap\r\n");
  prttext("functions offered by the TGDLP4\r\n");
  prttext("Graphics Driver...\r\n\n");
  prttext("Perhaps the most important feature about\r\n");
  prttext("bitmaps in this module is that there are\r\n");
  prttext("no size restrictions: A bitmap can be as\r\n");
  prttext("small as 1x1 or as big as 10000x10000\r\n");
  prttext("pixels. The only limitation is the\r\n");
  prttext("available base memory.\r\n");
  prttext("Press a key to blit a 640x388 bitmap\r\n");
  prttext("into VRAM.\r\n");
  bltmode(BM_SOLID);

  framewait(35);

  /* another nice effect... only scroll up info text */
  for (a=200;a>=104;a-=1)
  { framewait(2); splitscrn(a); };

  /* while the user is reading some text, load the next bitmap */
  filename="lp4demo\\pheonix.lp4";
  bitmap1bc=readbc(filename,1,&loaderr);
  if (!bitmap1bc) { error=DEMOERR_LOAD; goto bitmapcleanup; };

  /* wait for a key */
  if (!getch()) getch();

  /* scroll text away */
  for (a=104;a<=200;a+=1)
  { framewait(2); splitscrn(a); };

  /* hide display */
  fade(210,0,bitmapbc->cmdescr->colors,allblack,bitmapbc->cmap);

  /* free pattern bitmap */
  freebc(bitmapbc); bitmapbc=0;


  /* blit next bitmap into VRAM */
  bltbitmap(0,8,0,0,639,387,bitmap1bc->tgdbmdescr);

  /* the bitmap is sorted by luminance... take brightest color
   * as text color.
   */
  bltmode(BM_COLREPLACE); bltpen(PEN_B,0); bltpen(PEN_F,1); pen(PEN_B,0); pen(PEN_F,bitmap1bc->cmdescr->colors);
  txtcrsr(0,0); prttext("Cursor Keys = scroll around; ESC = Exit ");
  bltmode(BM_SOLID);

  /* show what we've done */
  splitscrn(192); viewreg(0,8);
  waittof(); rgb6(0,bitmap1bc->cmdescr->colors,bitmap1bc->cmap);

  /* let the user scroll around a bit */
  x=0; y=8; ax=0; ay=0; //syncxscroll(FALSE);
  while ((pressedkey=getch())!=ESC_KEY)
  { if (!pressedkey) { switch (getch())
		       { case CRSR_UP_KEY: ay-=1; break;
			 case CRSR_DOWN_KEY: ay+=1; break;
			 case CRSR_LEFT_KEY: ax-=1; break;
			 case CRSR_RIGHT_KEY: ax+=1; break;
			 default: ax=0; ay=0;
		       }
		     }
    else { ax=0; ay=0; };

    while (!kbhit())
    { x+=ax; y+=ay;
      if (y<8) { y=8; ay=0; }
      else if (y>204) { y=204; ay=0; };

      if (x<0) { x=0; ax=0; }
      else if (x>320) { x=320; ax=0; };

      //waittof();
      viewreg(x,y);
    };
  };
  //syncxscroll(TRUE);

  fade(140,0,bitmap1bc->cmdescr->colors,allblack,bitmap1bc->cmap);
  /* remove info line */
  splitscrn(256);

  viewmode(VM_320x200); drawreg(0,200,319,199); clearreg();

  bltmode(BM_COLREPLACE);
  txtcrsr(0,312);
  prttext("When dealing with a huge bitmap it is\r\n");
  prttext("often usefull to be able to extract a\r\n");
  prttext("rectangular area of that bitmap.\r\n\n");
  prttext("TGDLP4 supports this key operation (as\r\n");
  prttext("you can see). You can blit rectangular\r\n");
  prttext("parts which may be located anywhere in\r\n");
  prttext("a larger bitmap and have any size to\r\n");
  prttext("anywhere on the screen.\r\n\n");
  prttext("Press a key to continue.");
  bltmode(BM_SOLID);

  /* show display again */
  fade(140,0,bitmap1bc->cmdescr->colors,bitmap1bc->cmap,allblack);

  /* limit region where blitting is possible */
  drawreg(0,200,319,111);
  /* blit bitmap extracts */
  while (!kbhit())
  { /* get source position of blit */
    srcx=rand()%640; srcy=rand()%388;
    /* get size of blit */
    x=rand()%(640-srcx); y=rand()%(388-srcy);

    /* slow the whole thing down a little bit so it doesn't go crazy
     * on my VL board. You may want to remove waittof() for a slow
     * '286 PC.
     */
    waittof();
    /* do the blit */
    bltbitmap(rand()%320,(rand()%112)+200,srcx,srcy,x,y,bitmap1bc->tgdbmdescr);
  };
  /* enable access to all parts of the screen again */
  drawreg(0,200,319,199);

  /* get key */
  if (!getch()) getch();

  /* prepare redness fade */
  for (a=0;a<=765;a+=3)
  { allred[a]=33; allred[a+1]=0; allred[a+2]=0; };
  /* go red */
  fade(210,0,255,allred,bitmap1bc->cmap);

  /* free heroes bitmap */
  freebc(bitmap1bc); bitmap1bc=0;


  /* load crunchy */
  filename="lp4demo\\crunchy.lp4";
  bitmapbc=readbc(filename,1,&loaderr);
  if (!bitmapbc) { error=DEMOERR_LOAD; goto bitmapcleanup; };

  /* draw red horizontal lines */
  for (a=200;a<400;a+=1)
  { b=a&7;
    if (b<4) { pen(PEN_F,b+1); }
    else pen(PEN_F,8-b);
    line(0,a,319,a);
  };

  bltmode(BM_TRANSPARENT|BM_COLREPLACE); bltpen(PEN_B,0); bltpen(PEN_F,1); pen(PEN_B,0); pen(PEN_F,5);
  txtcrsr(0,200);
  prttext("Apart from doing 'raw' blits this\r\n");
  prttext("Graphics Driver supports block image\r\n");
  prttext("transfer modifiers... Here are some\r\n");
  prttext("examples:");
  bltmode(BM_SOLID);

  /* draw original image */
  bltbitmap(10,240,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);

  /* draw background transparent image */
  bltmode(BM_TRANSPARENT); bltpen(PEN_B,6);
  bltbitmap(110,240,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);
  /* draw foreground transparent image */
  bltpen(PEN_B,8);
  bltbitmap(210,240,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);

  bltmode(BM_TRANSPARENT|BM_COLREPLACE); bltpen(PEN_B,0); pen(PEN_F,5);
  txtcrsr(10,280);
  prttext("selectable transparent color");
  bltmode(BM_SOLID);

  /* draw original image */
  bltbitmap(10,295,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);

  /* draw background transparent, foreground color-replaced */
  bltmode(BM_TRANSPARENT|BM_COLREPLACE); bltpen(PEN_B,6); bltpen(PEN_F,8); pen(PEN_B,6); pen(PEN_F,13);
  bltbitmap(90,295,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);
  /* draw foreground transparent, background color-replaced */
  bltpen(PEN_B,8); bltpen(PEN_F,6); pen(PEN_B,8); pen(PEN_F,14);
  bltbitmap(170,295,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);
  /* draw everything color-replaced */
  bltmode(BM_COLREPLACE); bltpen(PEN_B,6); bltpen(PEN_F,8); pen(PEN_B,15); pen(PEN_F,16);
  bltbitmap(250,295,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);

  bltmode(BM_TRANSPARENT|BM_COLREPLACE); bltpen(PEN_B,0); bltpen(PEN_F,1); pen(PEN_B,0); pen(PEN_F,5);
  txtcrsr(10,335);
  prttext("on the fly color replacement");
  bltmode(BM_SOLID);

  /* draw original image */
  bltbitmap(10,350,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);

  /* shadow fun */
  bltmode(BM_TRANSPARENT); bltpen(PEN_B,6); drawmode(DM_OR);
  bltbitmap(110,350,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);
  bltbitmap(130,350,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);
  drawmode(DM_XOR);
  bltbitmap(210,350,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);
  bltbitmap(225,350,0,0,bitmapbc->tgdbmdescr->xsize,bitmapbc->tgdbmdescr->ysize,bitmapbc->tgdbmdescr);

  bltmode(BM_TRANSPARENT|BM_COLREPLACE); bltpen(PEN_B,0); pen(PEN_B,0); pen(PEN_F,8);
  txtcrsr(10,390);
  prttext("fun with shadows...press a key");
  drawmode(DM_SOLID); bltmode(BM_SOLID);

  /* show display again */
  fade(140,0,bitmapbc->cmdescr->colors,bitmapbc->cmap,allred);

  /* get key */
  if (!getch()) getch();

  /* end of bitmap part... clean up */
  fade(140,0,bitmapbc->cmdescr->colors,allwhite,bitmapbc->cmap);

  /* free crunchy bitmap */
  freebc(bitmapbc); bitmapbc=0;

bitmapcleanup:
  if (error) { /* just in case splitscrn is still active */
	       splitscrn(256);

	       /* free used bitmaps */
	       if (bitmapbc) freebc(bitmapbc);
	       if (bitmap1bc) freebc(bitmap1bc);
	     };
  return(error);
}

ubyte fontdemo(fcdescr huge *introfc)
{ char *formtext;
  ubyte const introfntcol[]={ 56,48,56 };
  ubyte const patt2col[]={  0,0,0,  10,0,0,  20,0,0,  30,0,0,  63,63,63,  63,63,0,  0,0,63,  36,63,0,  0,0,0,  63,20,20,  63,30,30,  63,40,40,  0,0,0,  63,0,63,  63,40,63,  63,50,63 };
  byte crsrrightkey=FALSE;
  uword textsize;
  word a;
  word triangle1[]={ 0,200, 160,200, 0,300 };
  word triangle2[]={ 0,300, 0,399, 160,399 };
  word triangle3[]={ 319,300, 319,399, 160,399 };
  word triangle4[]={ 160,200, 319,200, 319,300 };
  bcdescr huge *fontbc=0,huge *font1bc=0;
  fcdescr huge *fontfc=0,huge *font1fc=0, huge *font2fc=0;

  /* clear invisible upper part of virtual screen */
  pen(PEN_F,0); rectangle(0,0,319,399);

  /* reprint menu text (will be used as pattern) */
  txtcrsr(0,0);
  prttext("Use cursor keys to select:");
  txtcrsr(50,96);
  prttext("Graphic Primitives\r\nBitmaps\r\nFonts & Text\r\nQuit");

  /* set pattern */
  pattern(0,0,320,400);
  pfill(TRUE);
  /* pattern-in text (and pattern-out the background) */
  for (a=0;a<160;a+=1)
  { waittof();
    line(a,a+400,319-a,a+400);
    line(319-a,a+400,319-a,799-a);
    line(a,799-a,319-a,799-a);
    line(a,a+400,a,799-a);
  };
  pfill(FALSE);

  fade(140,1,0,allblack,introfntcol);


  /* load background pattern (strips) */
  filename="lp4demo\\strips.lp4";
  fontbc=readbc(filename,1,&loaderr);
  if (!fontbc) { error=DEMOERR_LOAD; goto fontcleanup; };

  /* set ALL colors to black */
  waittof(); rgb6(0,255,allblack);

  /* select page mode */
  viewmode(VM_320x400);

  /* draw background pattern (strips) */
  bltbitmap(0,0,0,0,fontbc->tgdbmdescr->xsize,fontbc->tgdbmdescr->ysize,fontbc->tgdbmdescr);
  pattern(0,0,fontbc->tgdbmdescr->xsize+1,fontbc->tgdbmdescr->ysize+1);
  pfill(TRUE);
  rectangle(0,0,319,399);
  pfill(FALSE);

  /* print introduction */
  bltmode(BM_TRANSPARENT); bltpen(PEN_B,0);
  txtcrsr(0,0);
  prttext("And you thought the menu\r\n");
  prttext("font is not a real font...");
  txtcrsr(0,160);
  prttext("By the way, creating this\r\n");
  prttext("font didn't take ages. In\r\n");
  prttext("fact, it was done in five\r\n");
  prttext("minutes. Press a key.");
  bltmode(BM_SOLID);

  /* show page 0 (the page we have prepared) */
  fade(140,0,fontbc->cmdescr->colors,fontbc->cmap,allblack);

  /* prepare page 1 */
  drawpage(1);

  /* draw background pattern (again) - but this time on page 1 */
  bltbitmap(0,0,0,0,fontbc->tgdbmdescr->xsize,fontbc->tgdbmdescr->ysize,fontbc->tgdbmdescr);
  pattern(0,0,fontbc->tgdbmdescr->xsize+1,fontbc->tgdbmdescr->ysize+1);
  pfill(TRUE);
  rectangle(0,0,319,399);
  pfill(FALSE);

  bltmode(BM_TRANSPARENT);
  txtcrsr(0,0);
  prttext("How?\r\n");
  prttext("This font was converted\r\n");
  prttext("from Windows. FntToLP4\r\n");
  prttext("can convert almost any\r\n");
  prttext("font into a LP4 font.");
  formtext="Press a key.";
  txtcrsr(320-(uword)txtwidth(formtext),340);
  prttext(formtext);
  bltmode(BM_SOLID);

  /* free menu font */
  font(0); freefc(introfc); introfc=0;

  /* still showing page number 0... */
  if (!getch()) getch();

  /* ...now show page number 1 */
  waittof(); viewpage(1);

  /* load yet another pattern (while the user is still reading) */
  filename="lp4demo\\rough.lp4";
  font1bc=readbc(filename,1,&loaderr);
  if (!font1bc) { error=DEMOERR_LOAD; goto fontcleanup; };

  /* load ye olde font */
  filename="lp4demo\\oldefnt.lp4";
  fontfc=readfc(filename,1,&loaderr);
  if (!fontfc) { error=DEMOERR_LOAD; goto fontcleanup; };

  /* set olde font as active font */
  font(fontfc->tgdfmdescr);

  /* still showing page number 1 */
  if (!getch()) getch();


  /* fade to black */
  fade(210,0,fontbc->cmdescr->colors,allblack,fontbc->cmap);
  waittof(); rgb6(0,255,allblack);

  /* free 1st pattern (strips) */
  freebc(fontbc); fontbc=0;

  /* go from 320x400 phys. res. to 320x200 phys. res.
   * 320x200 page mode will initially be set by screenmode()
   */
  waittof(); screenmode(SM_320x200);

  /* prepare page 1 */
  drawpage(1);
  bltbitmap(0,0,0,0,font1bc->tgdbmdescr->xsize,font1bc->tgdbmdescr->ysize,font1bc->tgdbmdescr);
  pattern(0,0,font1bc->tgdbmdescr->xsize+1,font1bc->tgdbmdescr->ysize+1);
  pfill(TRUE);
  rectangle(0,200,319,399);
  pfill(FALSE);

  bltmode(BM_TRANSPARENT|BM_COLREPLACE);
  bltpen(PEN_B,0); bltpen(PEN_F,1); pen(PEN_B,0); pen(PEN_F,4);
  drawmode(DM_OR);
  formtext="TGDLP4 Font Specifications";
  textsize=(uword)txtwidth(formtext);
  txtcrsr((320-textsize)>>1,212);
  prttext(formtext);
  rectangle((320-textsize)>>1,237,(320+textsize)>>1,240);
  txtcrsr(0,250);
  prttext("Char. size: 1x1 - 255x255 pixels.\r\n");
  prttext("Font types: prop. & fixed width.\r\n");
  prttext("Multicolor fonts ARE supported.\r\n");
  prttext("All blit and draw modifiers also\r\n");
  prttext("apply to fonts.\r\n");
  prttext("Press a key for examples.");
  drawmode(DM_SOLID); bltmode(BM_SOLID);

  /* prepare page 0 - the one to show first */
  drawpage(0);
  bltbitmap(0,0,0,0,font1bc->tgdbmdescr->xsize,font1bc->tgdbmdescr->ysize,font1bc->tgdbmdescr);
  drawreg(0,200,319,199); clearreg();

  /* do some pattern tricks */
  pattern(0,0,font1bc->tgdbmdescr->xsize+1,font1bc->tgdbmdescr->ysize+1);
  pfill(TRUE);
  drawpoly(3,triangle1); drawpoly(3,triangle2); drawpoly(3,triangle3); drawpoly(3,triangle4);
  pfill(FALSE);

  fade(140,0,font1bc->cmdescr->colors,font1bc->cmap,allblack);

  framewait(35);

  pfill(TRUE);
  for (a=0;a<=160;a+=2)
  { waittof();
    ellipse(160,300,a,(a>>1)+(a>>3));
  };
  pfill(FALSE);

  /* show already prepared screen */
  waittof(); viewpage(1);

  /* load demo fonts while the user is busy reading text */
  filename="lp4demo\\tiffafnt.lp4";
  font1fc=readfc(filename,1,&loaderr);
  if (!font1fc) { error=DEMOERR_LOAD; goto fontcleanup; };

  filename="lp4demo\\future.lp4";
  font2fc=readfc(filename,1,&loaderr);
  if (!font2fc) { error=DEMOERR_LOAD; goto fontcleanup; };

  /* get user input */
  if (!getch()) getch();

  /* stenciled whiteness fade */
  fade(140,1,2,(font1bc->cmap)+15,(font1bc->cmap)+3);
  framewait(35);

  drawpage(1);
  pen(PEN_F,7);
  for (a=200;a<400;a+=1)
  { waittof();
    line(0,600-a,39,600-a);
    line(40,a,79,a);
    line(80,600-a,119,600-a);
    line(120,a,159,a);
    line(160,600-a,199,600-a);
    line(200,a,239,a);
    line(240,600-a,279,600-a);
    line(280,a,319,a);
  };

  /* set all colors that will be visible to white (except border color) */
  waittof(); rgb6(16,0,allblack); ovscol(16);
  waittof(); rgb6(0,15,allwhite);

  /* fill screen with the rough pattern for the last time */
  viewmode(VM_1280x200);
  bltbitmap(0,0,0,0,font1bc->tgdbmdescr->xsize,font1bc->tgdbmdescr->ysize,font1bc->tgdbmdescr);
  pattern(0,0,font1bc->tgdbmdescr->xsize+1,font1bc->tgdbmdescr->ysize+1);
  pfill(TRUE);
  rectangle(320,0,959,199);
  pfill(FALSE);

  /* free rough pattern */
  freebc(font1bc); font1bc=0;

  /* prepare visible part of screen */
  bltmode(BM_TRANSPARENT|BM_COLREPLACE);
  bltpen(PEN_B,0); bltpen(PEN_F,1); pen(PEN_B,0); pen(PEN_F,4);
  txtcrsr(320,0);
  prttext("And here come the examples...\r\n\n");
  font(font1fc->tgdfmdescr);
  prttext("This is a propor-\r\n");
  prttext("tional width\r\n");
  prttext("font.");
  font(font2fc->tgdfmdescr);
  txtcrsr(320,170);
  prttext("THIS IS A FIXED WIDTH FONT.");
  formtext="PRESS CURSOR RIGHT KEY";
  txtcrsr(320+((320-(uword)txtwidth(formtext))>>1),192);
  prttext(formtext);
  bltmode(BM_SOLID);

  /* show screen */
  viewreg(320,0);
  fade(140,0,15,patt2col,allwhite);
  ovscol(0);

  /* prepare invisible part of screen */
  bltmode(BM_TRANSPARENT|BM_COLREPLACE);
  font(font2fc->tgdfmdescr);
  txtcrsr(640,0);
  prttext("THIS TEXT IS LEFT ALIGNED.");
  font(font1fc->tgdfmdescr);
  formtext="centered";
  txtcrsr(640+((320-(uword)txtwidth(formtext))>>1),24);
  prttext(formtext);
  font(fontfc->tgdfmdescr);
  formtext="This text is right aligned.";
  txtcrsr(640+(320-(uword)txtwidth(formtext)),64);
  prttext(formtext);

  font(font2fc->tgdfmdescr);
  formtext="REPLACED FOREGROUNDCOLOR\r\n";
  txtcrsr(640,120);
  pen(PEN_F,5);
  prttext(formtext);
  pen(PEN_F,6);
  prttext(formtext);
  prttext("\n");

  pen(PEN_F,4);
  formtext="REPLACED BACKGROUNDCOLOR\r\n";
  pen(PEN_B,7);
  prttext(formtext);
  bltmode(BM_COLREPLACE);
  pen(PEN_B,0);
  prttext(formtext);
  prttext("\n");

  bltmode(BM_TRANSPARENT|BM_COLREPLACE); drawmode(DM_OR);
  pen(PEN_B,0); pen(PEN_F,8);
  prttext("REVERSE SHADOWS\r\n");
  bltpen(PEN_B,1); bltpen(PEN_F,0); pen(PEN_B,1); pen(PEN_F,8);
  prttext("INVERSE REVERSE SHADOWS???");

  bltpen(PEN_B,0); bltpen(PEN_F,1); pen(PEN_B,0); pen(PEN_F,12);
  formtext="STOP THIS...PRESS CURSOR RIGHT KEY";
  txtcrsr(640+((320-(uword)txtwidth(formtext))>>1),192);
  prttext(formtext);
  drawmode(DM_SOLID); bltmode(BM_SOLID);

  /* free all used fonts */
  freefc(fontfc); fontfc=0;
  freefc(font1fc); font1fc=0;
  freefc(font2fc); font2fc=0;

  /* the user is still watching the 1st screen */
  while (!crsrrightkey)
  { if (getch()) continue;
    if (getch()==CRSR_RIGHT_KEY) crsrrightkey=TRUE;
  };

  /* scroll invisible part of virtual screen into display area */
  for (a=320;a<=640;a+=1)
  { viewreg(a,0); };

  /* prepare a white screen area */
  pen(PEN_F,4); rectangle(960,0,1279,199);

  /* wait for user */
  crsrrightkey=FALSE;
  while (!crsrrightkey)
  { if (getch()) continue;
    if (getch()==CRSR_RIGHT_KEY) crsrrightkey=TRUE;
  };

  /* scroll into white area */
  for (a=640;a<=960;a+=1)
  { viewreg(a,0); };

  framewait(7);
  fade(70,0,0,allwhite,patt2col);

fontcleanup:
  if (error) { /* just in case a user defined font is still active */
	       font(0);

	       /* clean up everything */
	       if (introfc) freefc(introfc);
	       if (fontbc) freebc(fontbc);
	       if (font1bc) freebc(font1bc);
	       if (fontfc) freefc(fontfc);
	       if (font1fc) freefc(font1fc);
	       if (font2fc) freefc(font2fc);
	     };
  return(error);
}

main()
{ const char loaderr1[]="NO_FILE",loaderr2[]="BAD_FILE",loaderr3[]="NO_MEM",loaderr4[]="EOF";
  const char *lerrtxt[4];
  int pressedkey;

  const ubyte nxtgencolor1[]={  0,0,0,  63,63,63,  63,63,63,  63,63,63,  63,63,63 };
  const ubyte nxtgencolor2[]={  0,0,0,  63,63,63,   0,63,0,  63,0,0,   0,0,63 };
  ubyte topic=0;
  byte topicselected;
  word a;
  word talegon[]={ 36,194, 46,194, 56,148, 46,148 };
  bcdescr huge *introbc=0;
  scdescr huge *introsc=0;
  spriteinc far *introsprite=0;
  fcdescr huge *introfc=0;

  /* variable initializations: */
  /* possible load errors */
  lerrtxt[0]=loaderr1; lerrtxt[1]=loaderr2;
  lerrtxt[2]=loaderr3; lerrtxt[3]=loaderr4;
  /* standard fades */
  memset(allblack,0,768);
  memset(allwhite,63,768);

  randomize();


  /* initialize graphics driver */
  if (vgalp4()) { printf("?No VGA card or VGA card with less than 256KB installed\n Can't run demo!\n");
		  return(DEMOERR_BADVGA);
		};


  /* for the nxtgen intro I want 320x400 phys. resolution... */
  waittof(); screenmode(SM_320x400);
  /* ...and 320x819 virtual resolution */
  viewmode(VM_320x800); pen(PEN_F,0); rectangle(0,0,319,399);

  /* load next generation bitmap */
  filename="lp4demo\\nxtgen.lp4";
  introbc=readbc(filename,1,&loaderr);
  if (!introbc) { error=DEMOERR_LOAD; goto cleanup; };

  /* load star sprite */
  filename="lp4demo\\star.sp4";
  introsc=readsc(filename,1,&loaderr);
  if (!introsc) { error=DEMOERR_LOAD; goto cleanup; };
  /* ready star sprite */
  introsprite=newsprite(0,0,0,0,introsc->tgdsmdescr);
  if (!introsprite) { error=DEMOERR_NOMEM; goto cleanup; };

  /* hide graphics generation by setting all used colors to black */
  waittof(); rgb6(0,4,allblack);

  /* blit next generation bitmap into VRAM */
  bltbitmap(54,140,0,0,introbc->tgdbmdescr->xsize,introbc->tgdbmdescr->ysize,introbc->tgdbmdescr);

  /* draw the talegons - each with a different color */
  for (a=2;a<5;a+=1)
  { pen(PEN_F,a);
    drawpoly(4,talegon);
    talegon[0]-=16; talegon[2]-=16; talegon[4]-=16; talegon[6]-=16;
  };

  /* add sprite to display list and init sprite position */
  addspr(0,0,400,introsprite);
  movespr(0,8,136);

  /* show everything (except sprite) */
  fade(210,0,4,nxtgencolor1,allblack);
  framewait(35);
  fade(70,0,4,nxtgencolor2,nxtgencolor1);
  framewait(140);

  /* do a little sprite animation */
  onspr(0);
  for (a=0;a<7;a+=1)
  { animspr(0,a);
    waittof(); refreshspr();
    framewait(6);
  };

  for (a=7;a>=0;a-=1)
  { animspr(0,a);
    waittof(); refreshspr();
    framewait(6);
  };

  /* free next generation bitmap - we don't need it anymore */
  freebc(introbc); introbc=0;

  /* free star sprite */
  offspr(0); refreshspr(); removespr(0);
  freesprite(introsprite); introsprite=0;
  freesc(introsc); introsc=0;

  /* fade into white */
  fade(140,0,4,allwhite,nxtgencolor2);


menureenter:
  /* set every color of the 256 colors to white */
  waittof(); rgb6(0,255,allwhite);

  /* set 320x400 phys. resolution, 320x819 virtual resolution */
  waittof(); screenmode(SM_320x400); viewmode(VM_320x800);

  /* load tale logo background */
  filename="lp4demo\\talebgnd.lp4";
  introbc=readbc(filename,1,&loaderr);
  if (!introbc) { error=DEMOERR_LOAD; goto cleanup; };

  /* blit tale logo into VRAM at virtual position (0,400) */
  bltbitmap(0,400,0,0,319,399,introbc->tgdbmdescr);
  /* we need to use a double buffer for the upcoming text F/X */
  vramcopy(0,0,0,400,320,400);

  /* oh whiteness - stay a while but don't stay forever! */
  framewait(70);

  /* display the lower part of the virtual screen -
   * just to be able to produce the quit effect
   */
  viewreg(0,400);
  fade(210,0,255,introbc->cmap,allwhite);

  /* load intro font */
  filename="lp4demo\\introfnt.lp4";
  introfc=readfc(filename,1,&loaderr);
  if (!introfc) { error=DEMOERR_LOAD; goto cleanup; };

  /* load selection border sprite */
  filename="lp4demo\\txtbordr.sp4";
  introsc=readsc(filename,1,&loaderr);
  if (!introsc) { error=DEMOERR_LOAD; goto cleanup; };
  /* ready selection border sprite */
  introsprite=newsprite(0,0,0,0,introsc->tgdsmdescr);
  if (!introsprite) { error=DEMOERR_NOMEM; goto cleanup; };

  /* set intro font as active font */
  font(introfc->tgdfmdescr);
  /* font shall be printed TRANSPARENTLY */
  bltmode(BM_TRANSPARENT); bltpen(PEN_B,0);
  /* prepare text pattern */
  txtcrsr(0,0);
  prttext("Use cursor keys to select:");
  txtcrsr(50,96);
  prttext("Graphic Primitives\r\nBitmaps\r\nFonts & Text\r\nQuit");
  /* be careful with blitmode: set it back to SOLID if you don't want to
   * wonder why the next blit is not working as it should and spend time on
   * debugging all day.
   */
  bltmode(BM_SOLID);

  /* prepare border sprite for display */
  addspr(0,0,0,introsprite);
  movespr(0,43,494+60*(uword)topic);

  /* set pattern */
  pattern(0,0,320,400);
  pfill(TRUE);
  /* pattern-in text */
  for (a=0;a<400;a+=2)
  { waittof();
    line(0,a+400,319,a+400);
    line(0,799-a,319,799-a);
  };
  /* disable pattern fill */
  pfill(FALSE);

  /* initially display border sprite */
  onspr(0);
  refreshspr();

  topicselected=FALSE; a=1;
  /* let the user select a menu item */
  while (!topicselected)
  { /* do some fancy color cycling while no user input to process */
    while (!kbhit())
    { framewait(6);
      rgb6(2+a,3-a,introsc->cmap+6);
      if (a) rgb6(2,a-1,introsc->cmap+6+(4-a)*3);
      a=(a+1)&3;
    };

    /* evaluate key codes */
    pressedkey=getch();
    if (!pressedkey) { pressedkey=getch();
		       /* user command: [go to new topic] */
		       if (pressedkey==CRSR_DOWN_KEY && topic<3) topic+=1;
		       if (pressedkey==CRSR_UP_KEY && topic>0) topic-=1;
		     }
    else { switch (tolower(pressedkey))
	   { /* [execute topic] keycodes */
	     case ESC_KEY: topic=3; topicselected=TRUE; break;
	     case ENTER_KEY: topicselected=TRUE; break;
	     case SPACE_KEY: topicselected=TRUE; break;
	     /* direct selection of topics */
	     case 'g': topic=0; break;
	     case 'b': topic=1; break;
	     case 'f': topic=2; break;
	     case 'q': topic=3; break;
	   };
	 };
    /* tgdlp4xx.obj does only something if the sprite is *REALLY* moved */
    movespr(0,43,494+60*(uword)topic); refreshspr();
  };

  /* free tale logo bitmap - if selected topic is not quit or graph. prim. */
  if (topic!=3 && topic!=0) { freebc(introbc); introbc=0; };
  /* free font - if selected topic is not fonts and text */
  if (topic!=2) { font(0); freefc(introfc); introfc=0; };
  /* remove selection border */
  offspr(0); refreshspr(); removespr(0);
  freesprite(introsprite); introsprite=0;
  freesc(introsc); introsc=0;

  /* call program parts according to topic selection */
  switch (topic)
  { case 0: error=primdemo(introbc);
	    if (!error) goto menureenter;
	    else goto cleanup;
    case 1: error=bitmapdemo();
	    if (!error) goto menureenter;
	    else goto cleanup;
    case 2: error=fontdemo(introfc);
	    if (!error) goto menureenter;
	    else goto cleanup;
  };


  /* QUIT: */
  /* blit tale logo into double buffer */
  bltbitmap(0,0,0,0,319,399,introbc->tgdbmdescr);

  /* pattern-in tale logo */
  pattern(0,0,320,400);
  pfill(TRUE);
  for (a=0;a<200;a+=1)
  { waittof();
    line(0,a+400,319,a+400);
    line(0,799-a,319,799-a);
  };
  pfill(FALSE);

  /* clear upper part of the virtual screen... */
  pen(PEN_F,0);
  rectangle(0,0,319,399);
  /* ...and scroll up */
  for (a=399;a>=0;a-=1)
  { viewreg(0,a); };

  /* free tale logo bitmap */
  freebc(introbc); introbc=0;

cleanup:
  /* return to textmode */
  co80();

  if (error) { /* clean up memory */
	       if (introbc) freebc(introbc);
	       if (introsprite) freesprite(introsprite);
	       if (introsc) freesc(introsc);
	       if (introfc) freefc(introfc);

	       /* which error did occur? */
	       switch (error)
	       { case DEMOERR_LOAD: printf("?Can't load file: %s [error code: %s]\nAborting.\n",filename,lerrtxt[loaderr-1]);
				    break;
		 case DEMOERR_NOMEM: printf("?Out of memory\n");
				     break;
	       };
	     }
  else printf("Now it's your turn...\n");

  /* return error code to DOS */
  return(error);
}