/**********************************************

	Example #03 for the Reglage VGA-Library

		TEXT MODE
		Character Height Experimenting

	V1.1 - Reglage (C) 1994

**********************************************/

#include "Keyb.h"
#include "VGA.h"
#include "VGA_T.h"
#include	"VGA_BIOS.h"

#include "CooLogo.c"					//	Not forgetting the C00lEsT logotype...


/**********************************************

	main() ... Just a little test!

**********************************************/

int main(void)
{
	UWORD i,j,x,y;
	UBYTE ocurx,ocury;
	int dir=1,fade,vmode;

	UWORD oldscreen[0x4000];

	struct Palette OldPalette[16];
	struct Palette NewPalette[16];

	vmode=V_GetMode();						// Get Current VideoMode
	VB_GetCursorPos(&ocurx,&ocury);		//	Get Original Cursor Positions

	for(j=0;j<16;j++)
		T_GetPal(j,&OldPalette[j]);//	Store Old Palette

	for(j=0;j<0x4000;j++)			//	Store Old DOS-Screen
		oldscreen[j]=T_screen[j];

	VB_SetCursor(0);					//	Set Cursor Invisible [BIOS]

	for(fade=0x40;fade>0;fade--)	//	Fade Out DOS-Screen
	{
		for(j=0;j<16;j++)
		{
			NewPalette[j].R=(OldPalette[j].R*fade)>>6;
			NewPalette[j].G=(OldPalette[j].G*fade)>>6;
			NewPalette[j].B=(OldPalette[j].B*fade)>>6;
			T_SetPal(j,&NewPalette[j]);
		}
		V_WaitVB();						//	Wait for Vertical Blanking
	}

	V_SetMode(0x83);						//	Set TextMode 80x25, No Blanking
	for(j=0;j<16;j++)					//	Set Palette to BLACK
	{
		NewPalette[j].R=0;
		NewPalette[j].G=0;
		NewPalette[j].B=0;
		T_SetPal(j,&NewPalette[j]);
	}

	T_SetCursor(0);					//	Set Cursor Invisible
	T_ClearScreen(0);					//	Clear ALL Screen Memory

	for(x=0;x<COOLOGO_WIDTH;x++)	//	Move the COOLOGO to the Screen
		for(y=0;y<(COOLOGO_DEPTH);y++)
			T_screen[y*T_width+x+15]=COOLOGO[(x+y*COOLOGO_WIDTH)*2]+(COOLOGO[(x+y*COOLOGO_WIDTH)*2+1]<<8);

	K_EatKbHit();						//	Eat Keypresses

	while(K_KbHit())					//	Continue while no keypresses
	{
		if(fade<0x40)					//	Fade In!
		{
			for(j=0;j<16;j++)
			{
				NewPalette[j].R=(OldPalette[j].R*fade)>>6;
				NewPalette[j].G=(OldPalette[j].G*fade)>>6;
				NewPalette[j].B=(OldPalette[j].B*fade)>>6;
				T_SetPal(j,&NewPalette[j]);
			}
			fade++;
		}

		i+=dir;
		if(i>0x1e)						//	Height 0x1f is MAX
			dir=-1;
		if(i<0x01)						//	...and ofcourse, 0 is MIN
			dir=1;

		T_CharHeight(i);				//	Set Character Height

		V_WaitVB();						//	Wait for Vertical Blanking
	}

	while(fade>=0)						//	Fade Out!
	{
		for(j=0;j<16;j++)
		{
			NewPalette[j].R=(OldPalette[j].R*fade)>>6;
			NewPalette[j].G=(OldPalette[j].G*fade)>>6;
			NewPalette[j].B=(OldPalette[j].B*fade)>>6;
			T_SetPal(j,&NewPalette[j]);
		}
		fade--;
		V_WaitVB();						//	Wait for Vertical Blanking
	}

	V_SetMode(vmode|0x80);			//	Set Original VideoMode, No Blanking
	VB_SetCursor(0);					//	Set Cursor Invisible [BIOS]

	for(j=0;j<16;j++)					//	Set Palette to BLACK
	{
		NewPalette[j].R=0;
		NewPalette[j].G=0;
		NewPalette[j].B=0;
		T_SetPal(j,&NewPalette[j]);
	}

	for(j=0;j<0x4000;j++)			//	Restore Original DOS-Screen
		T_screen[j]=oldscreen[j];

	for(fade=0;fade<0x3f;fade++)	//	Fade In DOS-Screen
	{
		for(j=0;j<16;j++)
		{
			NewPalette[j].R=(OldPalette[j].R*fade)>>6;
			NewPalette[j].G=(OldPalette[j].G*fade)>>6;
			NewPalette[j].B=(OldPalette[j].B*fade)>>6;
			T_SetPal(j,&NewPalette[j]);
		}
		V_WaitVB();						//	Wait for Vertical Blanking
	}
	for(j=0;j<16;j++)
		T_SetPal(j,&OldPalette[j]);//	Store Old Palette

	VB_SetCursorPos(ocurx,ocury);	//	Set Original Cursor Positions
	VB_SetCursor(2);					//	Set Cursor Normal [BIOS]

	K_EatKbHit();						//	Eat Keypress

	return 0;
}
