/**********************************************

	Keyboard Routines
	Copyright Reglage (C) 1994

	Keyb.c

**********************************************/

#include "keyb.h"


/**********************************************

	Returns true if Keypress Waiting

**********************************************/

UBYTE K_KbHit(void)
{
	asm	xor	ax,ax;
	asm	mov	es,ax;
	asm	mov	ax,[es:0x41a];	//	KbHead
	asm	sub	ax,[es:0x41c];	//	KbTail

	return (_AX==0);
}


/**********************************************

	Remove (eat) All Keys from Keyboard Buffer

**********************************************/

void K_EatKbHit(void)
{
//	*(unsigned far *)0x0000041a=*(unsigned far *)0x0000041c;

	asm	xor	ax,ax;
	asm	mov	es,ax;
	asm	mov	ax,es:[0x41c];
	asm	mov	es:[0x41a],ax;
}

/**********************************************

	Store KbHit in Keyboard Buffer

**********************************************/

UBYTE K_StoreKbHit(UWORD KEY)
{
	asm	mov	ah,0x05;
	asm	mov	cx,KEY;
	asm	int	0x16;

	return _AL;
}


/**********************************************

	Finally...get a KeyPress

**********************************************/

UWORD K_KeyPress(void)
{
	while(K_KbHit());

	asm	mov	ah,0x10;
	asm	int	0x16;

	return _AX;
}
