/* test of Quill graphics routines
** copyleft April 1997 *fuzzy* (the porcupine) / grey (pascal@acm.org)
** see quill.h for more information
*/

#include <stdio.h>
#include <math.h>
#include <quill.h>

int stab[1024]; /* sine lookup table */
unsigned char *screen, *texture; /* pointers to the screen and texture
    buffers */
graph *g, *t; /* two graph windows */

void rotazoom (int x0, int y0, int xi, int yi, int xo, int yo)
/* simple rotazoomer code.  if you don't understand this, don't bother
trying. :) */
{
        int x, y, c;
        int i, j;
        int pos;

        pos = 0;
        for (j = 0; j < 200; j++)
        {
                x = x0;
                y = y0;
                x0 += xo;
                y0 += yo;

                for (i = 0; i < 320; i++)
                {
                        c = texture[(y & (255 << 8)) + ((x >> 8) & 255)];
			screen[pos] = c;

			pos++;

                        x += xi;
                        y += yi;
                }
        }

	Blit (g, 0, 0, 320, 200); /* blit the rectangle from
	    (0,0)-(319,199) (i.e. the whole window) */
}

void main(void)
{
	char *disp; /* var for storing the DISPLAY environment variable */
	int i, j; /* counting variables */

	/* get the current display variable */
	disp = (unsigned char *)getenv("DISPLAY");
	if (!disp)
		disp = ":0.0";

	/* setup the window for the rotazoom */
	if (!(g = SetupGraphics (disp, 320, 200)))
	{
		printf ("SetupGraphics failed!\n");
		return;
	}
	/* get a pointer to the buffer */
	screen = GetBuffer(g);

	/* setup the window for the texture viewer */
	if (!(t = SetupGraphics (disp, 256, 256)))
	{
		printf ("SetupGraphics failed!\n");
		return;
	}
	/* get a pointer to the buffer */
	texture = GetBuffer(t);

	/* init the sine table */
	for (i = 0; i < 1024; i++)
		stab[i] = 511.5*sin(i*PI/512);

	/* setup the palettes */
	for (i = 0; i < 256; i++)
	{
		SetColor (g, i, i*2, i*4, i*8);
		SetColor (t, i, i, i, i);
	}

	i = 0;

	/* we'll never quit until ctrl-c is pressed... the
	    ShutdownGraphics() at the end is just for good form :) */
	while (1)
	{
		/* draw the rotazoom */
		i++;
		rotazoom (stab[i&1023]<<8, stab[(i*2)&1023]<<8,
		    stab[(i*4)&1023], stab[(i*5)&1023],
		    stab[(i*5)&1023], stab[(i*6)&1023]);

		/* update the texture.  this should be in another
		    procedure.  i'm lazy. :) */
		/*for (j = 0; j < 1024; j++)
			texture[((stab[(i*18+j)&1023]/4 +
			    stab[((i+j)*15)&1023]/16 << 8) +
			    stab[(i*17+j)&1023]/4 +
			    stab[((i+j)*16)&1023]/16)&65535] += i*j;*/
		for (j = 0; j < 1024; j++)
			texture[rand()&65535] += i*j;
		for (j = 0; j < 65536; j++)
			texture[j] = (texture[j] + texture[(j+1)&65535] +
			    texture[(j+256)&65535] +
			    texture[(j+257)&65535]) >> 2;

		/* update the texture window */
		/*SetPalette (t, (int *)texture);*/  /* why not? :) */
		Blit (t, 0, 0, 256, 256);
	}

	/* done with graphics, shut them down */
	ShutdownGraphics (g);
	ShutdownGraphics (t);

	/* all done */
}
