program JoyTest;

{***************************************************************************}
{																			}
{		Author:				Kevin A. Lee									}
{																			}
{		Last Amended:		22nd January, 1993								}
{																			}
{		Description:		Test program for pasKAL graphics library and	}
{							joystick routines. The program initialises and	}
{							calibrates joystick 1 and then displays a grid	}
{							Moving the joystick to different positions		}
{							highlights different squares in the grid		}
{							and pressing a button changes the colour		}
{							Pressing escape quits.							}
{																			}
{***************************************************************************}

uses
  	MCGA256, Joystick, Crt, Memory;


var
	Ch: char;
    Joycolour: byte;
    lastPos: Direction;


begin
	if (not GameAdapterExists) then
    begin
    	WriteLn('Game Adapter not found.');
        Halt(1);
    end;

	if (not OpenGraphics) then
	begin
		WriteLn('Error opening graphics library.');
        Halt(2);
    end;

    if (not CalibrateJoystick(1)) then
    begin
    	CloseGraphics;
    	WriteLn('Error: Joystick 1 not responding');
        Halt(3);
    end;

    SetActivePage(VirtualScreen);

    JoyColour := 2;

    FillRectangle(0, 0, 319, 199, 0);
    Rectangle(99, 29, 219, 169, 15);
    Line(139, 29, 139, 169, 15);
    Line(179, 29, 179, 169, 15);
    Line(99, 75, 219, 75, 15);
    Line(99, 121, 219, 121, 15);


    while (not keypressed) do
    begin
        CheckJoysticks;

        FillRectangle(0, 0, 319, 199, 0);
    	Rectangle(99, 29, 219, 169, 15);
    	Line(139, 29, 139, 169, 15);
    	Line(179, 29, 179, 169, 15);
    	Line(99, 75, 219, 75, 15);
    	Line(99, 121, 219, 121, 15);

        if ((not JoyButton1[1]) and (not JoyButton2[1])) then Joycolour := 2;
        if JoyButton1[1] then Joycolour := 4;
        if JoyButton2[1] then Joycolour := 1;

        case (JoyPosition[1]) of
        	none:			FillRectangle(140, 76,  178, 120, Joycolour);
        	up:				FillRectangle(140, 30,  178, 74, Joycolour);
            down:			FillRectangle(140, 122, 178, 168, Joycolour);
            left:			FillRectangle(100, 76,  138, 120, Joycolour);
            right:			FillRectangle(180, 76,  218, 120, Joycolour);
            upright:		FillRectangle(180, 30,  218, 74, Joycolour);
            downright:      FillRectangle(180, 122, 218, 168, Joycolour);
            downleft:       FillRectangle(100, 122, 138, 168, Joycolour);
            upleft:         FillRectangle(100, 30,  138, 74, Joycolour);
            else
        end;

        lastPos := JoyPosition[1];
        CopyAllVirtualScreen;
    end;

    Ch := ReadKey;

    CloseGraphics;
end.