/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  Charging a distribution fee for this code is also
** FORBIDDEN.
*/
/*
 * X Version Copyright (C) 1995 Mike Manley
 * 
 * Based on SVGA code by Jonathan Paul Griffiths
 */

#include <jlib.h>
#include <X11/Xlib.h>

/*+------------------------------------------------------------------------+*/
/*|blit a fullscreen buffer to the screen                                  |*/
/*+------------------------------------------------------------------------+*/
/*|This routine is just a normal blit that assumes the buffer is the same  |*/
/*|size as the screen.                                                     |*/
/*+------------------------------------------------------------------------+*/

JINLINE void screen_blit_fs_buffer(buffer_rec *buff)
{
	/* This should be able to be optimised so the XCreateGC and XCreateImage */
	/* aren't called everytime - note ideally the XImage should be created */
	/* and managed as part of the buffer_rec */
	
/*	XGCValues	gcvals; */
/*	GC				gc; */
/*	unsigned long	gcvmask=0; */
	XImage*		image;

	/* Set up graphics context - oops this is currently a memory leak */
	/* GC can probably just be created once as part of screen_set_video_mode */
/*	gcvals.graphics_exposures = 0; */
/*	gcvmask = GCGraphicsExposures; */
/*	gc = XCreateGC(jxdisplay, RootWindow(jxdisplay, jxscreen), gcvmask, &gcvals);*/

	/* Create image */
	image = XCreateImage(jxdisplay, DefaultVisual(jxdisplay, jxscreen), 8, ZPixmap, 0, B_BUFF_PTR(buff),
						320, 200, 32, 320);
	/* Put to window */
	XPutImage(jxdisplay, jxwindow, jxgc, image, 0, 0, 0, 0, 320, 200);
	/* Delete the image */
	XDestroyImage(image);
}

#ifndef _SWAP
#define _SWAP(a,b) a^=b;b^=a;a^=b
#endif


/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen without clipping.                   |*/
/*+------------------------------------------------------------------------+*/

void screen_blit_buff_toNC(USHORT x,USHORT y,buffer_rec *sbuff,
			  USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2)
{
/*
	XGCValues	gcvals;
	GC				gc;
	unsigned long	gcvmask=0;
*/
	XImage*		image;
/*
	gcvals.graphics_exposures = 0;
	gcvmask = GCGraphicsExposures;
	gc = XCreateGC(jxdisplay, RootWindow(jxdisplay, jxscreen), gcvmask, &gcvals);
*/

	image = XCreateImage(jxdisplay, DefaultVisual(jxdisplay, jxscreen), 8, ZPixmap, 0, B_BUFF_PTR(sbuff),
						320, 200, 32, 320);
	XPutImage(jxdisplay, jxwindow, jxgc, image, sbx1, sby1, x, y, sbx2-sbx1, sby2-sby1);
	XDestroyImage(image);
	XFlush(jxdisplay);
}


/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen with clipping.                      |*/
/*+------------------------------------------------------------------------+*/

void screen_blit_buff_to(USHORT x,USHORT y,buffer_rec *sbuff,
			 USHORT sbx1, USHORT sby1,USHORT sbx2, USHORT sby2)
{
/*
	XGCValues	gcvals;
	GC				gc;
	unsigned long	gcvmask=0;
*/
	XImage*		image;

 int v_len = sby2-sby1,  h_len = sbx2-sbx1;
 int width = B_X_SIZE(sbuff);

 if(sbx1 > sbx2){
   _SWAP(sbx1,sbx2);
 }
 
 if(sby1 > sby2){
   _SWAP(sby1,sby2);
 }  
 
 if((x > SCREEN_MAX_X)|| (y > SCREEN_MAX_Y)){
   return;
 }  
 
 if((x+h_len) > SCREEN_MAX_X){
   h_len = SCREEN_MAX_X - x;
 }  

 if((y+v_len) > SCREEN_MAX_Y){
   v_len = SCREEN_MAX_Y - y;
 }  
  
/*
	gcvals.graphics_exposures = 0;
	gcvmask = GCGraphicsExposures;
	gc = XCreateGC(jxdisplay, RootWindow(jxdisplay, jxscreen), gcvmask, &gcvals);
*/

	image = XCreateImage(jxdisplay, DefaultVisual(jxdisplay, jxscreen), 8, ZPixmap, 0, B_BUFF_PTR(sbuff),
						320, 200, 32, 320);
	XPutImage(jxdisplay, jxwindow, jxgc, image, sbx1, sby1, x, y, sbx2-sbx1, sby2-sby1);
	XDestroyImage(image);
	XFlush(jxdisplay);
}

