/*
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "readme.jon" for more details.
*/

#include <stdio.h>
#include <vga.h>
#include <jlib.h>


/*+------------------------------------------------------------------------+*/
/*|set a DAC color register                                                |*/
/*+------------------------------------------------------------------------+*/

JINLINE void screen_put_pal(UBYTE col, UBYTE red, UBYTE green, UBYTE blue)
{
 UBYTE a;

 vga_setpalette((int)col,(int)red,(int)green,(int)blue);

}


/*+------------------------------------------------------------------------+*/
/*|set a block of DAC color registers                                      |*/
/*+------------------------------------------------------------------------+*/

void screen_block_set_pal(UBYTE *pal)
{
 int i;
 
 for(i=0;i<256;i++){
     screen_put_pal(i,pal[0]>>2,pal[1]>>2,pal[2]>>2);
     pal+=3;
 }

}


/*+------------------------------------------------------------------------+*/
/*|set all DAC color registers to zero                                     |*/
/*+------------------------------------------------------------------------+*/

void screen_blank_pal(void)
{
 int i;

 for(i=255;i>=0;i--){
     screen_put_pal(i,0,0,0);
 }

}


/*+------------------------------------------------------------------------+*/
/*|load a palette from a file                                              |*/
/*+------------------------------------------------------------------------+*/

#define SIZEOFPAL 768

UBYTE *screen_load_pal(char *fname)
{
 UBYTE *tmp;
 FILE *fp;

 /* allocate memory for the palette */
 if((tmp = (UBYTE *)malloc(SIZEOFPAL*sizeof(UBYTE)))==NULL){
    JLIB_SPRINTF(JLIB_MESSAGE_STRING,"Malloc Failed at screen_load_pal line %d\n",__LINE__);
    JLIB_PRINT_MESSAGE_STRING;

    return (UBYTE *)NULL;
 }

 /* open file */
 if((fp = fopen(fname,"rb"))==NULL){
    JLIB_SPRINTF(JLIB_MESSAGE_STRING,"Couldn't open palette file %s\n",fname);
    JLIB_PRINT_MESSAGE_STRING;

    return (UBYTE *)NULL;
 }

 /* read in the palette */
 fread(tmp,(sizeof(UBYTE)*SIZEOFPAL),1,fp);

 /* give if back */
 return tmp;
}


/*+------------------------------------------------------------------------+*/
/*|fade a palette in                                                       |*/
/*+------------------------------------------------------------------------+*/

#define PALSIZE 768

void screen_fade_in_pal(UBYTE *pal,unsigned int delaytime)
{
 int i,j;
 UBYTE temp_pal[PALSIZE];

  memset(temp_pal,(int)0,PALSIZE);

  for(i=1;i<64;i++){
      for(j=0;j<PALSIZE;j++){
	  temp_pal[j] = pal[j] * i / 64;
      }

      screen_block_set_pal(temp_pal);
      usleep(delaytime);
  }
}


/*+------------------------------------------------------------------------+*/
/*|fade a palette out                                                      |*/
/*+------------------------------------------------------------------------+*/

void screen_fade_out_pal(UBYTE *pal,unsigned int delaytime)
{
 int i,j;
 UBYTE temp_pal[PALSIZE];

  /* copy the palette into our local copy */
  FAST_SHORT_COPY(pal,temp_pal,PALSIZE);

  for(i=64;i>0;i--){
      for(j=0;j<PALSIZE;j++){
	  temp_pal[j] = pal[j] * i / 64;
      }

      screen_block_set_pal(temp_pal);
      usleep(delaytime);
  }

  /* do the last step */
  screen_blank_pal();
}

