
/*
   **
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for details.
 */

#include <jlib.h>
#include <vga.h>
#include <vgagl.h>
#include <vgamouse.h>


	    /* THE FOLLOWING CODE IS LINUX/SVGALIB SPECIFIC */

#define M_HEIGHT 6
#define M_WIDTH  5

/* the reason the mouse cursor is so small is SPEED */
static UBYTE __jlib_mouse_data[] =
{0, 0, 0, 0, 0,
 0, 15, 15, 15, 0,
 0, 15, 15, 0, 0,
 0, 15, 15, 15, 0,
 0, 15, 0, 15, 15,
 0, 0, 0, 0, 15,
};

static USHORT __jlib_mouse_x;
static USHORT __jlib_mouse_y;
static USHORT __jlib_mouse_button;

static UBYTE __jlib_mouse_save_area[40];
static UBYTE __jlib_mouse_showing;


void draw_mouse (void);
void save_mouse (void);
void restore_mouse (void);
void mouse_handle (int button, int dx, int dy);


/*+--------------------------------------------------------------------------+ */
/*|check for the presence of a mouse.                                        | */
/*+--------------------------------------------------------------------------+ */
/*|this routine should always be called FIRST to initialize the mouse        | */
/*+--------------------------------------------------------------------------+ */
int mouse_present (void)
{
   int result;

   result = mouse_init ("/dev/mouse", MOUSE_MICROSOFT, MOUSE_DEFAULTSAMPLERATE);

   if (result == 0)
     {
	mouse_setxrange (0, SCREEN_MAX_X);
	mouse_setyrange (0, SCREEN_MAX_Y);
	mouse_setwrap (MOUSE_NOWRAP);

	__jlib_mouse_x = 100;
	__jlib_mouse_y = 100;
	__jlib_mouse_showing = 0;	/* off */
	mouse_setposition (100, 100);

	mouse_seteventhandler (mouse_handle);

	return MOUSE_PRESENT;
     }
   else
     {
	return MOUSE_ABSENT;
     }
}


/*+--------------------------------------------------------------------------+ */
/*|show the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_show_pointer (void)
{
   mouse_update ();		/* remove this once interrupt-driven - have interrupt call it */

   if (__jlib_mouse_showing == 0)
     {
	__jlib_mouse_showing = 1;
	save_mouse ();
	draw_mouse ();
     }
   mouse_update ();		/* remove this once interrupt-driven - have interrupt call it */

}


/*+--------------------------------------------------------------------------+ */
/*|hide the pointer                                                          | */
/*+--------------------------------------------------------------------------+ */
void mouse_hide_pointer (void)
{
   mouse_update ();		/* remove this once interrupt-driven - have interrupt call it */

   if (__jlib_mouse_showing != 0)
     {
	__jlib_mouse_showing = 0;
	restore_mouse ();
     }

}

/*+--------------------------------------------------------------------------+ */
/*|read pointer coordinates                                                  | */
/*+--------------------------------------------------------------------------+ */
void mouse_get_status (int *x_pos, int *y_pos, int *b_status)
{
   mouse_update ();		/* remove this once interrupt-driven - have interrupt call it */

   *x_pos = __jlib_mouse_x;
   *y_pos = __jlib_mouse_y;
   *b_status = __jlib_mouse_button;
}


/*+--------------------------------------------------------------------------+ */
/*|change pointer coordinates                                                | */
/*+--------------------------------------------------------------------------+ */
void mouse_set_status (int x, int y)
{
   if (__jlib_mouse_showing != 0)
     {
	restore_mouse ();
	__jlib_mouse_x = x;
	__jlib_mouse_y = y;
	mouse_setposition (x, y);
	save_mouse ();
	draw_mouse ();
     }
   else
     {
	__jlib_mouse_x = x;
	__jlib_mouse_y = y;
	mouse_setposition (x, y);
     }

   mouse_update ();		/* remove this once interrupt-driven - have interrupt call it */

}


/*+--------------------------------------------------------------------------+ */
/*|shut down the mouse                                                       | */
/*+--------------------------------------------------------------------------+ */
void mouse_closedown (void)
{
   mouse_hide_pointer ();
   mouse_close ();
}


/*+--------------------------------------------------------------------------+ */
/*|mouse handler.                                                            | */
/*+--------------------------------------------------------------------------+ */

void mouse_handle (int button, int dx, int dy)
{

   if (__jlib_mouse_showing != 0)
     {
	restore_mouse ();	/* restore mouse cursor if showing */
     }

   __jlib_mouse_button = button;	/* 0 if no button */

   /* update coords, ensuring they dont get off the screen */
   if ((__jlib_mouse_x + dx) > SCREEN_MAX_X)
     {
	__jlib_mouse_x = SCREEN_MAX_X;
     }
   else
     {
	if ((__jlib_mouse_x + dx) < 0)
	  {
	     __jlib_mouse_x = 0;
	  }
	else
	  {
	     __jlib_mouse_x += dx;
	  }
     }

   if ((__jlib_mouse_y + dy) > SCREEN_MAX_Y)
     {
	__jlib_mouse_y = SCREEN_MAX_Y;
     }
   else
     {
	if ((__jlib_mouse_y + dy) < 0)
	  {
	     __jlib_mouse_y = 0;
	  }
	else
	  {
	     __jlib_mouse_y += dy;
	  }
     }


   if (__jlib_mouse_showing != 0)
     {
	save_mouse ();		/* redraw mouse if showing */
	draw_mouse ();

     }

}



#define X_LEFT   (xpos)
#define X_RIGHT  (xpos+M_WIDTH)
#define Y_TOP    (ypos)
#define Y_BOTTOM (ypos+M_HEIGHT)


void draw_mouse (void)
{
   UBYTE *data = __jlib_mouse_data;
   UBYTE count1, count2, endx = M_WIDTH, endy = M_HEIGHT;
   UBYTE *pos_on_screen;
   USHORT xpos = __jlib_mouse_x;
   USHORT ypos = __jlib_mouse_y;

   if (X_RIGHT > SCREEN_WIDTH)
     {
	/* some portion of the right is obscured */
	endx = SCREEN_WIDTH - X_LEFT;
     }

   if (Y_BOTTOM > SCREEN_HEIGHT)
     {
	/* some portion of the bottom is obscured */
	endy = SCREEN_HEIGHT - Y_TOP;
     }

   pos_on_screen = (UBYTE *) (vga_getgraphmem () + (__jlib_mouse_y * SCREEN_WIDTH)
			      + __jlib_mouse_x);


   /* move through the data, determining which pixels to draw */
   for (count1 = 0; count1 < endy; count1++)
     {
	for (count2 = 0; count2 < endx; count2++)
	  {

	     if (*data)
	       {
		  *pos_on_screen = *data;
	       }

	     pos_on_screen++;
	     data++;
	  }

	pos_on_screen += SCREEN_WIDTH - endx;
	data += M_WIDTH - endx;
     }

}


void save_mouse (void)
{
   UBYTE *data = __jlib_mouse_save_area;
   UBYTE count1, count2, endx = M_WIDTH, endy = M_HEIGHT;
   UBYTE *pos_on_screen;
   USHORT xpos = __jlib_mouse_x;
   USHORT ypos = __jlib_mouse_y;

   if (X_RIGHT > SCREEN_WIDTH)
     {
	/* some portion of the right is obscured */
	endx = SCREEN_WIDTH - X_LEFT;
     }

   if (Y_BOTTOM > SCREEN_HEIGHT)
     {
	/* some portion of the bottom is obscured */
	endy = SCREEN_HEIGHT - Y_TOP;
     }

   pos_on_screen = (UBYTE *) (vga_getgraphmem () + (__jlib_mouse_y * SCREEN_WIDTH)
			      + __jlib_mouse_x);

   for (count1 = 0; count1 < endy; count1++)
     {
	FAST_SHORT_COPY (pos_on_screen, data, endx);

	pos_on_screen += SCREEN_WIDTH;
	data += M_WIDTH;
     }

}


void restore_mouse (void)
{
   UBYTE *data = __jlib_mouse_save_area;
   UBYTE count1, count2, endx = M_WIDTH, endy = M_HEIGHT;
   UBYTE *pos_on_screen;
   USHORT xpos = __jlib_mouse_x;
   USHORT ypos = __jlib_mouse_y;

   if (X_RIGHT > SCREEN_WIDTH)
     {
	/* some portion of the right is obscured */
	endx = SCREEN_WIDTH - X_LEFT;
     }

   if (Y_BOTTOM > SCREEN_HEIGHT)
     {
	/* some portion of the bottom is obscured */
	endy = SCREEN_HEIGHT - Y_TOP;
     }

   pos_on_screen = (UBYTE *) (vga_getgraphmem () + (__jlib_mouse_y * SCREEN_WIDTH)
			      + __jlib_mouse_x);

   for (count1 = 0; count1 < endy; count1++)
     {
	FAST_SHORT_COPY (data, pos_on_screen, endx);

	pos_on_screen += SCREEN_WIDTH;
	data += M_WIDTH;
     }

}
