/*
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "readme.jon" for more details.
*/

#include <dos.h>
#include <grx20.h>
#include <jlib.h>

		  /* THE FOLLOWING CODE IS DJGPP SPECIFIC */


/*+--------------------------------------------------------------------------+*/
/*|check for the presence of a Mouse.                                        |*/
/*+--------------------------------------------------------------------------+*/
/*|this routine should always be called FIRST to initialize the mouse        |*/
/*+--------------------------------------------------------------------------+*/
int mouse_present(void)
{

 if(GrMouseDetect()){
    GrMouseEventMode(0);  /* use polled mode */
    GrMouseInit();

    return MOUSE_PRESENT;
 }
 else{
    return MOUSE_ABSENT;
 }

}


/*+--------------------------------------------------------------------------+*/
/*|shut down the mouse                                                       |*/
/*+--------------------------------------------------------------------------+*/
void mouse_closedown(void)
{
 GrMouseUnInit();

}

/*+--------------------------------------------------------------------------+*/
/*|show the pointer                                                          |*/
/*+--------------------------------------------------------------------------+*/
void mouse_show_pointer(void)
{
 GrMouseDisplayCursor();

}


/*+--------------------------------------------------------------------------+*/
/*|hide the pointer                                                          |*/
/*+--------------------------------------------------------------------------+*/
void mouse_hide_pointer(void)
{
 GrMouseEraseCursor();
}


/*+--------------------------------------------------------------------------+*/
/*|read pointer coordinates                                                  |*/
/*+--------------------------------------------------------------------------+*/
void mouse_get_status(int *x_pos, int *y_pos, int *b_status)
{
 GrMouseEvent event;

 GrMouseGetEvent((GR_M_MOTION | GR_M_BUTTON_CHANGE |GR_M_POLL),&event);

 *x_pos = event.x;
 *y_pos = event.y;
 *b_status = event.buttons;

}

/*+--------------------------------------------------------------------------+*/
/*|change pointer coordinates                                                |*/
/*+--------------------------------------------------------------------------+*/
void mouse_set_status( int x, int y)
{
 /* does nothing here at present */

}


