/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for details.
 */
#include <jlib.h>

		  /* THE FOLLOWING CODE IS DJGPP SPECIFIC */


#define MASK_1 0x00000001
#define MASK_16s 0xfffffff0

/* return the best copy method for two addresses and a length */
JINLINE int get_best_copy_method (void *addr1, void *addr2, unsigned int len)
{
   if (len & MASK_16s)
     {
	/* len is > 16 */
	(unsigned int) addr1 += (unsigned int) addr2;

	if ((unsigned int) addr1 & MASK_1)
	  {
	     /* one address is odd, one is even */
	     return ALIGNMENT_STATE_1;
	  }
	else
	  {
	     /* both address are either odd or even */
	     if ((unsigned int) addr2 & MASK_1)
	       {
		  /* both are odd */
		  if (len & MASK_1)
		    {
		       return ALIGNMENT_STATE_2;	/* length is odd */
		    }
		  else
		    {
		       return ALIGNMENT_STATE_5;	/* length is even */
		    }
	       }
	     else
	       {
		  /* both are even */
		  if (len & MASK_1)
		    {
		       return ALIGNMENT_STATE_4;	/* length is odd */
		    }
		  else
		    {
		       return ALIGNMENT_STATE_3;	/* length is even */
		    }
	       }
	  }
     }
   else
     {
	/* len is <= 16, use sb */
	return ALIGNMENT_STATE_1;
     }
}
