/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for more details.
 */
		  /* THE FOLLOWING CODE IS DJGPP SPECIFIC */

#include <jlib.h>
#include <go32.h>

#define MODE_13H_START  0xA0000

/*+------------------------------------------------------------------------+ */
/*|blit a fullscreen buffer to the screen                                  | */
/*+------------------------------------------------------------------------+ */
/*|This routine is just a normal blit that assumes the buffer is the same  | */
/*|size as the screen.                                                     | */
/*+------------------------------------------------------------------------+ */

JINLINE void screen_blit_fs_buffer (buffer_rec * buff)
{
   JLIB_PRINT_DEBUG_INFO ("Entering screen_blit_fs_buffer()\n");

   jdosmemput (B_BUFF_PTR (buff), 64000, MODE_13H_START);	/* copy using longwords */

   JLIB_PRINT_DEBUG_INFO ("Entering screen_blit_fs_buffer()\n");
}


#ifndef _SWAP
#define _SWAP(a,b) a^=b;b^=a;a^=b
#endif

/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen without clipping.                   | */
/*+------------------------------------------------------------------------+ */

void screen_blit_buff_toNC (USHORT x, USHORT y, buffer_rec * sbuff,
			 USHORT sbx1, USHORT sby1, USHORT sbx2, USHORT sby2)
{
   unsigned int sbuffx = B_X_SIZE (sbuff);
   UBYTE *src = B_BUFF_PTR (sbuff) + (sbuffx * sby1) + sbx1;
   UBYTE *dest = (UBYTE *) MODE_13H_START + (y * SCREEN_WIDTH) + x;
   unsigned int h_len = sbx2 - sbx1;
   unsigned int v_iterations = sby2 - sby1;


   switch (get_best_copy_method ((void *) src, (void *) dest, (unsigned int) h_len))
     {

     case ALIGNMENT_STATE_1:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_1 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_2:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_2 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_3:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_3 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_4:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_4 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_5:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_5 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_6:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_6 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_7:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_7 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_8:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_8 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     default:
	JLIB_PRINT_DEBUG_INFO ("Unknown value returned from get_best_copy_method()\n");
	exit (0);
	break;
     }


}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen with clipping.                      | */
/*+------------------------------------------------------------------------+ */

void screen_blit_buff_to (USHORT x, USHORT y, buffer_rec * sbuff,
			  USHORT sbx1, USHORT sby1, USHORT sbx2, USHORT sby2)
{
   unsigned int sbuffx = B_X_SIZE (sbuff);
   UBYTE *src = B_BUFF_PTR (sbuff);
   UBYTE *dest = (UBYTE *) MODE_13H_START;
   unsigned int h_len;
   unsigned int v_iterations;

   /* sort coordinates if needed */
   if (sbx2 < sbx1)
     {
	_SWAP (sbx1, sbx2);
     }
   if (sby2 < sby1)
     {
	_SWAP (sby1, sby2);
     }

   /* test coordinates for "don't draw" clipping */
   if ((x > SCREEN_MAX_X) || (y > SCREEN_MAX_Y))
     {
	return;
     }

   src += (sby1 * sbuffx) + sbx1;
   dest += (y * SCREEN_WIDTH) + x;

   v_iterations = (sby2 - sby1);	/* number of times to repeat horiz. blit */
   h_len = (sbx2 - sbx1);	/* length of horizontal blit */

   /* test coordinates to clip area drawn */
   if (x + h_len > SCREEN_MAX_X)
     {
	h_len = SCREEN_MAX_X - x;
     }
   if (y + v_iterations > SCREEN_MAX_Y)
     {
	v_iterations = SCREEN_MAX_Y - y;
     }

   switch (get_best_copy_method ((void *) src, (void *) dest, (unsigned int) h_len))
     {

     case ALIGNMENT_STATE_1:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_1 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_2:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_2 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_3:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_3 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_4:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_4 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_5:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_5 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_6:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_6 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_7:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_7 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     case ALIGNMENT_STATE_8:
	for (; v_iterations != 0; v_iterations--)
	  {
	     DOS_MEMCOPY_ALIGN_8 (src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
	  }
	break;

     default:
	JLIB_PRINT_DEBUG_INFO ("Unknown value returned from get_best_copy_method()\n");
	exit (0);
	break;
     }

}
