/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */

#ifndef __JINPUT_H__
#define __JINPUT_H__

#include <jconfig.h>

#ifdef __cplusplus
extern "C" {
#endif 

/* jinput.h - input functions */

/* This module must provide the following:
   **
   ** constants:
   **
   ** MOUSE_AVAILABLE             
   ** KEYBOARD_AVAILABLE
   ** JOYSTICK_AVAILABLE
   **
 * ** mouse functions: If MOUSE_AVAILABLE is true
   **
   ** BUTTON_DOWN(status)  
   **
   ** int mouse_present(void);
   ** void mouse_closedown(void);
   **
   ** void mouse_show_pointer(void);
   ** void mouse_hide_pointer(void);
   **
   ** void mouse_get_status(int *x_pos, int *y_pos, int *b_status);
   ** void mouse_set_status( int x, int y);
   **
   ** MOUSE_PRESENT and MOUSE_ABSENT are the return values of mouse_present()
   ** and are predefined.
   **
   ** Remember that you can only initialise the mouse AFTER the screen mode
   ** has been set.
   **
   **
 * ** keyboard functions: if KEYBOARD_AVAILABLE is true
   **
   ** The keys that may be tested for are a predefined subset and are listed 
   ** at the end of this file.
   **
   ** void kb_init(void);  doesnt return a value. if your KB doesn't
   **                             work, you don't have a computer!
   ** void kb_closedown(void);
   **
   ** int kb_keydown(int key);         is the given key hit ? 
   ** int kb_key_hit(void);            has any key been pressed?
   ** char kb_get_next_key(void);      wait & return the next key pressed
   **                                  or the next key waiting.
   **
   ** void kb_clear(void);             flush keyboard entries and buffer
   **
   **
 * ** joystick functions: if JOYSTICK_AVAILABLE is true
   **
   ** FIRE_1_DOWN(status)
   ** FIRE_2_DOWN(status)
   **
   ** int joystick_count(void);               how may sticks connected? 
   **
   ** int joystick_init(int which);
   ** int joystick_closedown(int which);
   **
   ** void joystick_calabrate(int which,int left,int right,int top,int bott,
   **              int x_centre,int y_centre);  calabrate for get_direction 
   **
   ** void joystick_get_status(int which,int *x_axis, int *y_axis,int *b_status);
   **
   ** directions returned from this are defined at the end of this file:
   ** int joystick_get_direction(int x_axis,int y_axis);
   **   
 */

#define MOUSE_PRESENT 1
#define MOUSE_ABSENT  0


/***************************************************************************/
#ifdef DJGPP_DPMI_COMPLIANT
/***************************************************************************/

/***************************************************************************/
#ifdef MODE_13H
/***************************************************************************/

/* _NO_KB_ is defined for djgpp V1 because its too dangerous */
#ifdef _NO_KB_
#define KEYBOARD_AVAILABLE 0     /* keyboard support is unavailable */
#else
#define KEYBOARD_AVAILABLE 1    /* keyboard support is available */
#endif

#define MOUSE_AVAILABLE 1	/* mouse is available */ 
#define JOYSTICK_AVAILABLE 0    /* no joystick support */

/* mouse */
#define BUTTON_DOWN(status)  (status & 0x1)

int mouse_present (void);
void mouse_show_pointer (void);
void mouse_hide_pointer (void);

void mouse_get_status (int *x_pos, int *y_pos, int *b_status);
void mouse_set_status (int x, int y);
void mouse_closedown (void);

/* kb */
void kb_init(void); 
void kb_closedown(void);
int kb_keydown(int key);         
int kb_key_hit(void);            
char kb_get_next_key(void);      
void kb_clear(void);             

#endif /* mode 13h */

/***************************************************************************/
#ifdef GRX_640x480x256
/***************************************************************************/

#define MOUSE_AVAILABLE 1	/* mouse is available */
#define KEYBOARD_AVAILABLE 0    /* no keyboard support */
#define JOYSTICK_AVAILABLE 0    /* no joystick support */

#define BUTTON_DOWN(status)  (status != 0)

int mouse_present (void);
void mouse_show_pointer (void);
void mouse_hide_pointer (void);

void mouse_get_status (int *x_pos, int *y_pos, int *b_status);
void mouse_set_status (int x, int y);
void mouse_closedown (void);

#endif /* grx 640x480x256 */

/***************************************************************************/
#ifdef GRX2_VARIANT
/***************************************************************************/

#define MOUSE_AVAILABLE 1	/* mouse is available */
#define KEYBOARD_AVAILABLE 1    /* keyboard support */
#define JOYSTICK_AVAILABLE 0    /* no joystick support */

/* mouse */
#define BUTTON_DOWN(status)  (status != 0)

int mouse_present (void);
void mouse_show_pointer (void);
void mouse_hide_pointer (void);

void mouse_get_status (int *x_pos, int *y_pos, int *b_status);
void mouse_set_status (int x, int y);
void mouse_closedown (void);

/* kb */
void kb_init(void); 
void kb_closedown(void);
int kb_keydown(int key);         
int kb_key_hit(void);            
char kb_get_next_key(void);      
void kb_clear(void);             

#endif /* grx variants */

#endif /* djgpp */


/***************************************************************************/
#ifdef LINUX_SVGALIB
/***************************************************************************/

/***************************************************************************/
#ifdef MODE_13H
/***************************************************************************/

#include <vgamouse.h>
#include <vgakeyboard.h>

#define MOUSE_AVAILABLE 1       /* mouse support */
#define KEYBOARD_AVAILABLE 1    /* tentative keyboard support */
#define JOYSTICK_AVAILABLE 0    /* no joystick support */

/* mouse */
#define BUTTON_DOWN(status)  (status)

int mouse_present (void);
void mouse_show_pointer (void);
void mouse_hide_pointer (void);

void mouse_get_status (int *x_pos, int *y_pos, int *b_status);
void mouse_set_status (int x, int y);
void mouse_closedown (void);

/* kb */
void kb_init(void); 
void kb_closedown(void);
int kb_keydown(int key);         
int kb_key_hit(void);            
char kb_get_next_key(void);      
void kb_clear(void);             

#endif /* mode 13h */

#endif /* linux svgalib */


/***************************************************************************/
#ifdef  LINUX_GRX2
/***************************************************************************/

#define MOUSE_AVAILABLE 1       /* mouse support */
#define KEYBOARD_AVAILABLE 1    /* keyboard support */
#define JOYSTICK_AVAILABLE 0    /* no joystick support */

/* mouse */
#define BUTTON_DOWN(status)  (status)

int mouse_present (void);
void mouse_show_pointer (void);
void mouse_hide_pointer (void);

void mouse_get_status (int *x_pos, int *y_pos, int *b_status);
void mouse_set_status (int x, int y);
void mouse_closedown (void);

/* kb */
void kb_init(void); 
void kb_closedown(void);
int kb_keydown(int key);         
int kb_key_hit(void);            
char kb_get_next_key(void);      
void kb_clear(void);             

#endif /* linux grx 2 */



/***************************************************************************/
#ifdef X_WINDOWS
/***************************************************************************/

/***************************************************************************/
#ifdef X_320x200x256
/***************************************************************************/

#define MOUSE_AVAILABLE 0       /* no mouse support */
#define KEYBOARD_AVAILABLE 0    /* no keyboard support */
#define JOYSTICK_AVAILABLE 0    /* no joystick support */


#endif /* X_320x200x256 */

#endif /* X windows */


/***************************************************************************/
#ifdef GENERIC
/***************************************************************************/

#define MOUSE_AVAILABLE 0	/* no mouse support for generic build */
#define KEYBOARD_AVAILABLE 0    /* no keyboard support for generic build */
#define JOYSTICK_AVAILABLE 0    /* no joystick support for generic build */

#endif /* generic */



/* key definitions */
#define KEY_ESC         1
#define KEY_1           2
#define KEY_2           3
#define KEY_3           4
#define KEY_4           5
#define KEY_5           6
#define KEY_6           7
#define KEY_7           8
#define KEY_8           9
#define KEY_9           10
#define KEY_0           11
#define KEY_MINUS       12
#define KEY_EQUALS      13
#define KEY_BACKSPACE   14
#define KEY_TAB         15
#define KEY_Q           16
#define KEY_W           17
#define KEY_E           18
#define KEY_R           19
#define KEY_T           20
#define KEY_Y           21
#define KEY_U           22
#define KEY_I           23
#define KEY_O           24
#define KEY_P           25
#define KEY_OPENBRACE   26
#define KEY_CLOSEBRACE  27
#define KEY_ENTER       28
#define KEY_CONTROL     29
#define KEY_A           30
#define KEY_S           31
#define KEY_D           32
#define KEY_F           33
#define KEY_G           34
#define KEY_H           35
#define KEY_J           36
#define KEY_K           37
#define KEY_L           38
#define KEY_COLON       39
#define KEY_QUOTE       40
#define KEY_TILDE       41
#define KEY_SHIFT       42
#define KEY_Z           44
#define KEY_X           45
#define KEY_C           46
#define KEY_V           47
#define KEY_B           48
#define KEY_N           49
#define KEY_M           50
#define KEY_COMMA       51
#define KEY_STOP        52
#define KEY_SLASH       53
#define KEY_ASTERISK    55
#define KEY_SPACE       57
#define KEY_CAPSLOCK    58
#define KEY_F1          59
#define KEY_F2          60
#define KEY_F3          61
#define KEY_F4          62
#define KEY_F5          63
#define KEY_F6          64
#define KEY_F7          65
#define KEY_F8          66
#define KEY_HOME        71
#define KEY_UP          72
#define KEY_PGUP        73
#define KEY_LEFT        75
#define KEY_RIGHT       77
#define KEY_END         79
#define KEY_DOWN        80
#define KEY_PGDN        81
#define KEY_INSERT      82
#define KEY_DEL         83


/* joystick directions */
#define JOY_NORTH     0
#define JOY_NORTHEAST 1
#define JOY_EAST      2
#define JOY_SOUTHEAST 3
#define JOY_SOUTH     4
#define JOY_SOUTHWEST 5
#define JOY_WEST      6
#define JOY_NORTHWEST 7

#ifdef __cplusplus
}
#endif 

#endif /* file */
