/* rle.h - run length encoding/decoding functions 
**
** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
**
** You may do anything with this code you wish EXCEPT sell it. You may sell
** any software you create using this code,  but you MUST NOT charge for
** the code itself.  See the file "jlib.doc" for more details.
*/

/* these functions are provided to encode buffers prior to them being
** compressed.  Run length encoding before compressing seems to save 
** around 25% or more than just compressing alone.
*/

#ifndef __RLE_H__
#define __RLE_H__

#ifdef __cplusplus
extern "C" {
#endif


/* rle encode a buffer */
long rle_encode(UBYTE *src,long len,UBYTE **dst);

/* rledecode a buffer */
long rle_decode(UBYTE *src,UBYTE **dst);


#ifdef __cplusplus
}
#endif 

#endif
