
/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */

#include <string.h>
#include <jlib.h>

#define NOT_CLIPPED 0

#define X_LEFT   (xpos)
#define X_RIGHT  (xpos+width)
#define Y_TOP    (ypos)
#define Y_BOTTOM (ypos+height)

/*+----------------------------------------------------------------------+ */
/*|draw_sprite - draw a sprite on screen with clipping                   | */
/*+----------------------------------------------------------------------+ */
/*| note - this version is a 'knock up' concieved only because I couldn't| */
/*| justify procrastinating any more.  it is even LESS optimised than the| */
/*| non clipping functions.                                              | */
/*+----------------------------------------------------------------------+ */

void buff_draw_sprite (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff)
{
   sprite_data_rec *current_sprite_data;
   UBYTE *data;
   UBYTE width, height, status = NOT_CLIPPED;
   UBYTE count1, count2, startx, starty, endx, endy;
   UBYTE *pos_in_buff, datum;
   USHORT xpos, ypos;


   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_sprite()\n");

   /* don't draw sprite if it isn't turned on */
   if (SPR_IS_ON (spr_sys, snum)) {

      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "Sprite %d is ON\n", snum);
      JLIB_PRINT_MESSAGE_STRING;

      /* the data is the sprite_data_rec indicated by it's frame */
      current_sprite_data = spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

      data = current_sprite_data->data;
      width = current_sprite_data->width;
      height = current_sprite_data->height;

      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "height is %d,width is %d", height, width);
      JLIB_PRINT_MESSAGE_STRING;

      /* set initial values of startx , endx etc */
      startx = 0;
      starty = 0;
      endx = width;
      endy = height;

      /* posistion is calculated from x and y minus the maximum sprite width */
      /* and height, so that we can have sprites off the edges of the buff. */
      xpos = spr_sys->sprites[snum]->x;
      ypos = spr_sys->sprites[snum]->y;


      /* check for "don't draw"  clipping  */
      if ((X_LEFT > B_X_SIZE (obuff) + SPR_MAX_X) ||
	  (X_RIGHT < SPR_MAX_X) ||
	  (Y_TOP > B_Y_SIZE (obuff) + SPR_MAX_Y) ||
	  (Y_BOTTOM < SPR_MAX_Y)) {
	 return;
      }

      /* check the other 4 clipping conditions */
      if (X_LEFT < SPR_MAX_X) {
	 /* some portion of the left side of the sprite is obscured */
	 status++;
	 startx = SPR_MAX_X - X_LEFT;
      }
      else {
	 if (X_RIGHT > B_X_SIZE (obuff) + SPR_MAX_X) {
	    /* some portion of the right side of the sprite is obscured */
	    status++;
	    endx = (B_X_SIZE (obuff) + SPR_MAX_X) - X_LEFT;
	 }
      }

      if (Y_TOP < SPR_MAX_Y) {
	 /* some portion of the top side of the sprite is obscured */
	 status++;
	 starty = SPR_MAX_Y - Y_TOP;
      }
      else {
	 if (Y_BOTTOM > B_Y_SIZE (obuff) + SPR_MAX_X) {
	    /* some portion of the bottom side of the sprite is obscured */
	    status++;
	    endy = (B_Y_SIZE (obuff) + SPR_MAX_Y) - Y_TOP;
	 }
      }

      /* only use the drawing routine below if needed */
      if (status == NOT_CLIPPED) {
	 buff_draw_spriteNC (spr_sys, snum, obuff);
	 return;
      }


      pos_in_buff = (UBYTE *) (obuff->buffer +
		((spr_sys->sprites[snum]->y - SPR_MAX_Y) * B_X_SIZE (obuff))
			       + (spr_sys->sprites[snum]->x) - SPR_MAX_X);

      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "xpos = %d,ypos = %d", spr_sys->sprites[snum]->x - SPR_MAX_X, spr_sys->sprites[snum]->y - SPR_MAX_Y);
      JLIB_PRINT_MESSAGE_STRING;

      /* start at the appropriate place in the data */
      data += ((unsigned int)starty * (unsigned int)width) + startx;

      /* start at the appropriate place in buff */
      pos_in_buff += ((unsigned int)starty * (unsigned int)B_X_SIZE (obuff)) + startx;

      /* move through the data, determining which pixels to draw */
      for (count1 = starty; count1 < endy; count1++) {
	 for (count2 = startx; count2 < endx; count2++) {
	    datum = *data;

	    if (datum) {
	       *pos_in_buff = *data;
	    }

	    pos_in_buff++;
	    data++;
	 }

	 pos_in_buff += B_X_SIZE (obuff) - (endx - startx);
	 data += width - (endx - startx);
      }
   }				/* IF */

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_sprite()\n");
}


/*+----------------------------------------------------------------------+ */
/*|draw_spriteNC - draw a sprite in a buff without clipping.             | */
/*+----------------------------------------------------------------------+ */

void buff_draw_spriteNC (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff)
{
   sprite_data_rec *current_sprite_data;
   UBYTE *data, *pattern;
   UBYTE width, height;
   UBYTE count1, count2;
   UBYTE *pos_in_buff, datum;
   int rlecount;


   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_spriteNC()\n");

   /* don't draw sprite if it isn't turned on */
   if (SPR_IS_ON (spr_sys, snum)) {

      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "Sprite %d is ON\n", snum);
      JLIB_PRINT_MESSAGE_STRING;

      /* posistion is calculated from x and y minus the maximum sprite width */
      /* and height, so that we can have sprites off the edges of the buff. */
      pos_in_buff = (UBYTE *) (obuff->buffer +
		((spr_sys->sprites[snum]->y - SPR_MAX_Y) * B_X_SIZE (obuff))
			       + (spr_sys->sprites[snum]->x) - SPR_MAX_X);

      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "xpos = %d,ypos = %d", spr_sys->sprites[snum]->x - SPR_MAX_X, spr_sys->sprites[snum]->y - SPR_MAX_Y);
      JLIB_PRINT_MESSAGE_STRING;

      /* the data is the sprite_data_rec indicated by it's frame */
      current_sprite_data = spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

      data = current_sprite_data->data;
      pattern = current_sprite_data->pattern;
      width = current_sprite_data->width;
      height = current_sprite_data->height;

      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "height is %d,width is %d", height, width);
      JLIB_PRINT_MESSAGE_STRING;

      /* move through the RLE pattern determining which pixels to draw */
      for (count1 = 0; count1 < height; count1++) {

	 for (count2 = *pattern, ++pattern; count2 > 0; count2--) {

	    datum = *pattern;
	    ++pattern;

	    rlecount = *pattern;
	    ++pattern;

	    if (datum) {
	       FAST_SHORT_COPY (data, pos_in_buff, rlecount);
	    }

	    pos_in_buff += rlecount;
	    data += rlecount;
	 }

	 pos_in_buff += B_X_SIZE (obuff) - width;
      }
   }				/* IF */

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_spriteNC()\n");
}


/*+----------------------------------------------------------------------+ */
/*|save_sprite - save the buff under a sprite with clipping            | */
/*+----------------------------------------------------------------------+ */
/*| NOTE - this version is a 'knock up' concieved only because I couldn't| */
/*| justify procrastinating any more.  it is even LESS optimised than the| */
/*| non clipping functions.                                              | */
/*+----------------------------------------------------------------------+ */

void buff_save_sprite (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff)
{
   sprite_data_rec *current_sprite_data;
   UBYTE *data, *buffer;
   UBYTE width, height, status = NOT_CLIPPED;
   UBYTE count1, count2, startx, starty, endx, endy;
   UBYTE *pos_in_buff, datum;
   USHORT xpos, ypos;


   JLIB_PRINT_DEBUG_INFO ("Entering buff_save_sprite()\n");

   /* the data is the sprite_data_rec indicated by it's frame */
   current_sprite_data = spr_sys->sprite_data[spr_sys->sprites[snum]->frame];


   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "snum = %d,frame = %d\n", snum, spr_sys->sprites[snum]->frame);
   JLIB_PRINT_MESSAGE_STRING;

   data = current_sprite_data->data;
   buffer = spr_sys->sprites[snum]->buffer;
   width = current_sprite_data->width;
   height = current_sprite_data->height;

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "height is %d,width is %d", height, width);
   JLIB_PRINT_MESSAGE_STRING;

   /* set initial values of startx , endx etc */
   startx = 0;
   starty = 0;
   endx = width;
   endy = height;

   /* posistion is calculated from x and y minus the maximum sprite width */
   /* and height, so that we can have sprites off the edges of the buff. */
   xpos = spr_sys->sprites[snum]->x;
   ypos = spr_sys->sprites[snum]->y;


   /* check for "don't save"  clipping  */
   if ((X_LEFT > B_X_SIZE (obuff) + SPR_MAX_X) ||
       (X_RIGHT < SPR_MAX_X) ||
       (Y_TOP > B_Y_SIZE (obuff) + SPR_MAX_Y) ||
       (Y_BOTTOM < SPR_MAX_Y)) {
      return;
   }

   /* check the other 4 clipping conditions */
   if (X_LEFT < SPR_MAX_X) {
      /* some portion of the left side of the sprite is obscured */
      status++;
      startx = SPR_MAX_X - X_LEFT;
   }
   else {
      if (X_RIGHT > B_X_SIZE (obuff) + SPR_MAX_X) {
	 /* some portion of the right side of the sprite is obscured */
	 status++;
	 endx = (B_X_SIZE (obuff) + SPR_MAX_X) - X_LEFT;
      }
   }

   if (Y_TOP < SPR_MAX_Y) {
      /* some portion of the top side of the sprite is obscured */
      status++;
      starty = SPR_MAX_Y - Y_TOP;
   }
   else {
      if (Y_BOTTOM > B_Y_SIZE (obuff) + SPR_MAX_X) {
	 /* some portion of the bottom side of the sprite is obscured */
	 status++;
	 endy = (B_Y_SIZE (obuff) + SPR_MAX_Y) - Y_TOP;
      }
   }

   /* only use the saving routine below if needed */
   if (status == NOT_CLIPPED) {
      buff_save_spriteNC (spr_sys, snum, obuff);
      return;
   }


   pos_in_buff = (UBYTE *) (obuff->buffer +
		((spr_sys->sprites[snum]->y - SPR_MAX_Y) * B_X_SIZE (obuff))
			    + (spr_sys->sprites[snum]->x) - SPR_MAX_X);

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "xpos = %d,ypos = %d", spr_sys->sprites[snum]->x - SPR_MAX_X, spr_sys->sprites[snum]->y - SPR_MAX_Y);
   JLIB_PRINT_MESSAGE_STRING;

   /* start at the appropriate place in the data */
   data += ((unsigned int)starty * (unsigned int)width) + startx;

   /* start at the appropriate place in buff */
   pos_in_buff += ((unsigned int)starty * (unsigned int)B_X_SIZE (obuff)) + startx;


   /* move through the data,  saving non-zero pixels */
   for (count1 = starty; count1 < endy; count1++) {
      for (count2 = startx; count2 < endx; count2++) {
	 datum = *data;

	 if (datum) {
	    *buffer = *pos_in_buff;
	 }

	 pos_in_buff++;
	 data++;
	 buffer++;
      }

      pos_in_buff += B_X_SIZE (obuff) - (endx - startx);
      data += width - (endx - startx);
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_save_sprite()\n");
}


/*+----------------------------------------------------------------------+ */
/*|buff_save_spriteNC - save the buff under a sprite into its buffer | */
/*+----------------------------------------------------------------------+ */

void buff_save_spriteNC (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff)
{
   sprite_data_rec *current_sprite_data;
   UBYTE *buffer, *pattern;
   UBYTE width, height;
   UBYTE count1, count2;
   UBYTE *pos_in_buff, datum;
   int rlecount;


   JLIB_PRINT_DEBUG_INFO ("Entering buff_save_spriteNC()\n");

   /* posistion is calculated from x and y minus the maximum sprite width */
   /* and height, so that we can have sprites off the edges of the buff. */
   pos_in_buff = (UBYTE *) (obuff->buffer +
		((spr_sys->sprites[snum]->y - SPR_MAX_Y) * B_X_SIZE (obuff))
			    + (spr_sys->sprites[snum]->x - SPR_MAX_Y));

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "xpos = %d,ypos = %d", spr_sys->sprites[snum]->x - SPR_MAX_X, spr_sys->sprites[snum]->y - SPR_MAX_Y);
   JLIB_PRINT_MESSAGE_STRING;

   /* the data is the sprite_data_rec indicated by it's frame */
   current_sprite_data = spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

   buffer = spr_sys->sprites[snum]->buffer;

   pattern = current_sprite_data->pattern;
   width = current_sprite_data->width;
   height = current_sprite_data->height;

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "height is %d,width is %d", height, width);
   JLIB_PRINT_MESSAGE_STRING;

   /* move through the RLE pattern determining which pixels to save */
   for (count1 = 0; count1 < height; count1++) {

      for (count2 = *pattern, ++pattern; count2 > 0; count2--) {

	 datum = *pattern;
	 ++pattern;

	 rlecount = *pattern;
	 ++pattern;

	 if (datum) {
	    FAST_SHORT_COPY (pos_in_buff, buffer, rlecount);
	    buffer += rlecount;
	 }
	 pos_in_buff += rlecount;

      }

      pos_in_buff += B_X_SIZE (obuff) - width;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_save_spriteNC()\n");
}

/*+----------------------------------------------------------------------+ */
/*|rest_sprite - restore the buff under a sprite with clipping         | */
/*+----------------------------------------------------------------------+ */
/*| NOTE - this version is a 'knock up' concieved only because I couldn't| */
/*| justify procrastinating any more.  it is even LESS optimised than the| */
/*| non clipping functions.                                              | */
/*+----------------------------------------------------------------------+ */

void buff_rest_sprite (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff)
{
   sprite_data_rec *current_sprite_data;
   UBYTE *data, *buffer;
   UBYTE width, height, status = NOT_CLIPPED;
   UBYTE count1, count2, startx, starty, endx, endy;
   UBYTE *pos_in_buff, datum;
   USHORT xpos, ypos;


   JLIB_PRINT_DEBUG_INFO ("Entering buff_rest_sprite()\n");

   /* the data is the sprite_data_rec indicated by it's frame */
   current_sprite_data = spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

   data = current_sprite_data->data;
   buffer = spr_sys->sprites[snum]->buffer;
   width = current_sprite_data->width;
   height = current_sprite_data->height;

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "height is %d,width is %d", height, width);
   JLIB_PRINT_MESSAGE_STRING;

   /* set initial values of startx , endx etc */
   startx = 0;
   starty = 0;
   endx = width;
   endy = height;

   /* posistion is calculated from x and y minus the maximum sprite width */
   /* and height, so that we can have sprites off the edges of the buff. */
   xpos = spr_sys->sprites[snum]->x;
   ypos = spr_sys->sprites[snum]->y;


   /* check for "don't restore"  clipping  */
   if ((X_LEFT > B_X_SIZE (obuff) + SPR_MAX_X) ||
       (X_RIGHT < SPR_MAX_X) ||
       (Y_TOP > B_Y_SIZE (obuff) + SPR_MAX_Y) ||
       (Y_BOTTOM < SPR_MAX_Y)) {
      return;
   }

   /* check the other 4 clipping conditions */
   if (X_LEFT < SPR_MAX_X) {
      /* some portion of the left side of the sprite is obscured */
      status++;
      startx = SPR_MAX_X - X_LEFT;
   }
   else {
      if (X_RIGHT > B_X_SIZE (obuff) + SPR_MAX_X) {
	 /* some portion of the right side of the sprite is obscured */
	 status++;
	 endx = (B_X_SIZE (obuff) + SPR_MAX_X) - X_LEFT;
      }
   }

   if (Y_TOP < SPR_MAX_Y) {
      /* some portion of the top side of the sprite is obscured */
      status++;
      starty = SPR_MAX_Y - Y_TOP;
   }
   else {
      if (Y_BOTTOM > B_Y_SIZE (obuff) + SPR_MAX_X) {
	 /* some portion of the bottom side of the sprite is obscured */
	 status++;
	 endy = (B_Y_SIZE (obuff) + SPR_MAX_Y) - Y_TOP;
      }
   }

   /* only use the saving routine below if needed */
   if (status == NOT_CLIPPED) {
      buff_rest_spriteNC (spr_sys, snum, obuff);
      return;
   }


   pos_in_buff = (UBYTE *) (obuff->buffer +
		((spr_sys->sprites[snum]->y - SPR_MAX_Y) * B_X_SIZE (obuff))
			    + (spr_sys->sprites[snum]->x) - SPR_MAX_X);

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "xpos = %d,ypos = %d", spr_sys->sprites[snum]->x - SPR_MAX_X, spr_sys->sprites[snum]->y - SPR_MAX_Y);
   JLIB_PRINT_MESSAGE_STRING;

   /* start at the appropriate place in the data */
   data += ((unsigned int)starty * (unsigned int)width) + startx;

   /* start at the appropriate place on buff */
   pos_in_buff += ((unsigned int)starty * (unsigned int)B_X_SIZE (obuff)) + startx;


   /* move through the data,  saving non-zero pixels */
   for (count1 = starty; count1 < endy; count1++) {
      for (count2 = startx; count2 < endx; count2++) {
	 datum = *data;

	 if (datum) {
	    *pos_in_buff = *buffer;
	 }

	 pos_in_buff++;
	 data++;
	 buffer++;
      }

      pos_in_buff += B_X_SIZE (obuff) - (endx - startx);
      data += width - (endx - startx);
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_rest_sprite()\n");
}


/*+----------------------------------------------------------------------+ */
/*|buff_rest_spriteNC - rest the buff under a sprite from its buffer | */
/*+----------------------------------------------------------------------+ */

void buff_rest_spriteNC (sprite_system * spr_sys, USHORT snum, buffer_rec * obuff)
{
   sprite_data_rec *current_sprite_data;
   UBYTE *buffer, *pattern;
   UBYTE width, height;
   UBYTE count1, count2;
   UBYTE *pos_in_buff, datum;
   int rlecount;


   JLIB_PRINT_DEBUG_INFO ("Entering buff_rest_spriteNC()\n");


   /* posistion is calculated from x and y minus the maximum sprite width */
   /* and height, so that we can have sprites off the edges of the buff. */
   pos_in_buff = (UBYTE *) (obuff->buffer +
		((spr_sys->sprites[snum]->y - SPR_MAX_Y) * B_X_SIZE (obuff))
			    + (spr_sys->sprites[snum]->x - SPR_MAX_X));

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "xpos = %d,ypos = %d", spr_sys->sprites[snum]->x - SPR_MAX_X, spr_sys->sprites[snum]->y - SPR_MAX_Y);
   JLIB_PRINT_MESSAGE_STRING;

   /* the data is the sprite_data_rec indicated by it's frame */
   current_sprite_data = spr_sys->sprite_data[spr_sys->sprites[snum]->frame];

   buffer = spr_sys->sprites[snum]->buffer;

   pattern = current_sprite_data->pattern;
   width = current_sprite_data->width;
   height = current_sprite_data->height;

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "height is %d,width is %d", height, width);
   JLIB_PRINT_MESSAGE_STRING;

   /* move through the RLE pattern determining which pixels to restore */
   for (count1 = 0; count1 < height; count1++) {

      for (count2 = *pattern, ++pattern; count2 > 0; count2--) {

	 datum = *pattern;
	 ++pattern;

	 rlecount = *pattern;
	 ++pattern;

	 if (datum) {
	    FAST_SHORT_COPY (buffer, pos_in_buff, rlecount);
	    buffer += rlecount;
	 }

	 pos_in_buff += rlecount;
      }

      pos_in_buff += B_X_SIZE (obuff) - width;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_rest_spriteNC()\n");
}


/*+----------------------------------------------------------------------+ */
/*|stamp a sprite frame on buff without clipping                       | */
/*|                                                                      | */
/*|"stamp" means that the background is drawn as black.                  | */
/*+----------------------------------------------------------------------+ */

JINLINE void buff_stamp_spriteNC (USHORT x, USHORT y, sprite_system * spr_sys,
				  USHORT frame, buffer_rec * obuff)
{
   sprite_data_rec *current_sprite_data;
   UBYTE *data, *pattern;
   UBYTE width, height;
   UBYTE count1, count2;
   UBYTE *pos_in_buff, datum;
   int rlecount;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_stamp_spriteNC()\n");

   pos_in_buff = (UBYTE *) obuff->buffer + ((unsigned int)y * (unsigned int)B_X_SIZE (obuff)) + x;

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "x = %d,y = %d", x, y);
   JLIB_PRINT_MESSAGE_STRING;

   current_sprite_data = spr_sys->sprite_data[frame];

   data = current_sprite_data->data;
   pattern = current_sprite_data->pattern;
   width = current_sprite_data->width;
   height = current_sprite_data->height;

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "height is %d,width is %d", height, width);
   JLIB_PRINT_MESSAGE_STRING;

   for (count1 = 0; count1 < height; count1++) {

      for (count2 = *pattern, ++pattern; count2 > 0; count2--) {

	 datum = *pattern;
	 ++pattern;

	 rlecount = *pattern;
	 ++pattern;

	 FAST_SHORT_COPY (data, pos_in_buff, rlecount);

	 pos_in_buff += rlecount;
	 data += rlecount;
      }


      pos_in_buff += B_X_SIZE (obuff) - width;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_stamp_spriteNC()\n");
}

/*+----------------------------------------------------------------------+ */
/*|stencil a sprite frame on buff without clipping                     | */
/*|                                                                      | */
/*|"stencil" means that the background remains transparent.              | */
/*+----------------------------------------------------------------------+ */

JINLINE void buff_stencil_spriteNC (USHORT x, USHORT y, sprite_system * spr_sys,
				    USHORT frame, buffer_rec * obuff)
{
   sprite_data_rec *current_sprite_data;
   UBYTE *data, *pattern;
   UBYTE width, height;
   UBYTE count1, count2;
   UBYTE *pos_in_buff, datum;
   int rlecount;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_stencil_spriteNC()\n");

   pos_in_buff = (UBYTE *) obuff->buffer + ((unsigned int)y * (unsigned int)B_X_SIZE (obuff)) + x;

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "x = %d,y = %d", x, y);
   JLIB_PRINT_MESSAGE_STRING;

   current_sprite_data = spr_sys->sprite_data[frame];

   data = current_sprite_data->data;
   pattern = current_sprite_data->pattern;
   width = current_sprite_data->width;
   height = current_sprite_data->height;

   JLIB_SPRINTF (JLIB_MESSAGE_STRING, "height is %d,width is %d", height, width);
   JLIB_PRINT_MESSAGE_STRING;

   for (count1 = 0; count1 < height; count1++) {

      for (count2 = *pattern, ++pattern; count2 > 0; count2--) {

	 datum = *pattern;
	 ++pattern;

	 rlecount = *pattern;
	 ++pattern;

	 if (datum) {
	    FAST_SHORT_COPY (data, pos_in_buff, rlecount);
	 }

	 pos_in_buff += rlecount;
	 data += rlecount;
      }

      pos_in_buff += B_X_SIZE (obuff) - width;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_stencil_spriteNC()\n");
}


/*+----------------------------------------------------------------------+ */
/*|buff_draw_all_sprites                                                 | */
/*+----------------------------------------------------------------------+ */
/*|draw all active sprites to the given buff.                            | */
/*+----------------------------------------------------------------------+ */

JINLINE void buff_draw_all_sprites (sprite_system * spr_sys, buffer_rec * obuff)
{
   int count;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_all_sprites()\n");


   for (count = 0; count < spr_sys->no_sprites; count++) {
      if (SPR_IS_ON (spr_sys, count)) {
	 buff_draw_sprite (spr_sys, count, obuff);
      }
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_all_sprites()\n");
}


/*+----------------------------------------------------------------------+ */
/*|buff_save_all_sprites                                                 | */
/*+----------------------------------------------------------------------+ */
/*|save all active sprites to the given buff.                            | */
/*+----------------------------------------------------------------------+ */

JINLINE void buff_save_all_sprites (sprite_system * spr_sys, buffer_rec * obuff)
{
   int count;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_save_all_sprites()\n");


   for (count = 0; count < spr_sys->no_sprites; count++) {
      if (SPR_IS_ON (spr_sys, count)) {
	 buff_save_sprite (spr_sys, count, obuff);
      }
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_save_all_sprites()\n");
}


/*+----------------------------------------------------------------------+ */
/*|buff_rest_all_sprites                                                 | */
/*+----------------------------------------------------------------------+ */
/*|rest all active sprites to the given buff.                            | */
/*+----------------------------------------------------------------------+ */

JINLINE void buff_rest_all_sprites (sprite_system * spr_sys, buffer_rec * obuff)
{
   int count;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_rest_all_sprites()\n");


   for (count = 0; count < spr_sys->no_sprites; count++) {
      if (SPR_IS_ON (spr_sys, count)) {
	 buff_rest_sprite (spr_sys, count, obuff);
      }
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_rest_all_sprites()\n");
}
