/*
 * Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
 *
 * You may do anything with this code you wish EXCEPT sell it. You may sell
 * any software you create using this code,  but you MUST NOT charge for
 * the code itself.  See the file "readme.jon" for detailed terms. 
 *
 *  I found and hacked around this simple filled polygon code and include the
 *  authors name and comments in tribute to him.  If you have any questions
 *  about this code please don't hassle him - This code doesn't resemble what
 *  he wrote any more.  Hassle me instead (sigh).  Anyway,  thank you Brian,
 *  may you live long and prosper!
 *
 * Brian wrote:
 *   "Simple optimization: obtain minimum and maximum vertex y coordinate
 *   and use these for the start/stop limits in the "for (iy=...)" loops
 *   in polygon()."
 *
 * I have implemented this simple optimisation.  I have not attempted any
 * others.  Note that this code will not draw any polygons with vertices 
 * bigger than MAX_X_RES x MAX_YRES and will definitely crash if the polygon is
 * not clipped to the desination buffer before being drawn. -jpg
 *
 * Original authors comments follow:
 */ 

/*
 * Simple convex polygon filler.
 * Written by Brian Paul  (brianp@ssec.wisc.edu)
 * With modifications by Jonathan Griffiths for inclusion in my graphics lib.
 * 
 * Notes:
 *   The general scheme is to use Bresenham's line algorithm to trace
 *   the outline of the polygon.  Instead of plotting points, however,
 *   we use (x,y) to establish the left and right boundaries of the
 *   polygon.  After we have the left and right bounds we can fill
 *   horizontal spans of pixels between them.
 *
 *   Results are undefined if any vertex of the polygon is outside of
 *   the region [0..MAX_XRES-1],[0..MAX_YRES-1].  This can be fixed.
 *
 *   This code also works for some concave polygons, namely those which
 *   never intersect a horizontal line more than 2 times.
 */

#include <jlib.h>

/* Screen/window size: */
#define MAX_YRES 1280
#define MAX_XRES 1024

JINLINE void __trace_edge( int x1, int y1, int x2, int y2 );

static int left[MAX_YRES], right[MAX_YRES];

/* Use Bresenham's line algorithm to trace an edge of the polygon. */
JINLINE void __trace_edge( int x1, int y1, int x2, int y2 )
{
   int dx, dy, xf, yf, a, b, t, i;

   if (x1==x2 && y1==y2)
      return;

   if (x2>x1) {
      dx = x2-x1;
      xf = 1;
   }
   else {
      dx = x1-x2;
      xf = -1;
   }

   if (y2>y1) {
      dy = y2-y1;
      yf = 1;
   }
   else {
      dy = y1-y2;
      yf = -1;
   }

   if (dx>dy) {
      a = dy+dy;
      t = a-dx;
      b = t-dx;
      for (i=0;i<=dx;i++) {
         if (x1<left[y1]) {
            left[y1] = x1;
         }
         if (x1>right[y1]) {
            right[y1] = x1;
         }
         x1 += xf;
         if (t<0) {
            t += a;
         }
         else {
            t += b;
            y1 += yf;
         }
      }

   }
   else {
      a = dx+dx;
      t = a-dy;
      b = t-dy;
      for (i=0;i<=dy;i++) {
         if (x1<left[y1]) {
            left[y1] = x1;
         }
         if (x1>right[y1]) {
            right[y1] = x1;
         }
         y1 += yf;
         if (t<0) {
            t += a;
         }
         else {
            t += b;
            x1 += xf;
         }
      }
   }
}


/* Draw a filled polygon of n vertices. */
void buff_convex_polyNC(buffer_rec *buff, int n, int *x, int *y,UBYTE col )
{
   int i, iy;
   int __lowest_bound=MAX_YRES,__highest_bound=0;

   /* set highest and lowest points to visit */
   for(i=0;i<n;i++){
        if(y[i] > __highest_bound){
          __highest_bound = y[i];
       }

       if(y[i] < __lowest_bound){
          __lowest_bound = y[i];
       }
   }

   /* reset the minumum amount of the edge tables */
   for (iy=__lowest_bound;iy<=__highest_bound;iy++) {
      left[iy] = MAX_XRES+1;
      right[iy] = -1;
   }
      
   /* define edges */
   __trace_edge( x[n-1], y[n-1], x[0], y[0] );

   for (i=0;i<n-1;i++) {
      __trace_edge( x[i], y[i], x[i+1], y[i+1] );
   }

   /* fill horizontal spans of pixels from left[] to right[] */
   for (iy=__lowest_bound;iy<=__highest_bound;iy++) {
         buff_draw_h_lineNC(buff, left[iy], iy, right[iy], col);
   }

}


/* Draw a concave/convex hollow polygon of n vertices. */
void buff_hollow_polyNC(buffer_rec *buff, int n, int *x, int *y,UBYTE col )
{
   int i;
   
   /* draw from vertex to vertex */
   for (i=1;i<n;i++){
        buff_draw_lineNC(buff, x[i], y[i],x[i-1],y[i-1], col);
   }
   
   /* draw final line */
   buff_draw_lineNC(buff, x[0], y[0],x[n-1],y[n-1], col);

}


/* Draw a concave/convex hollow polygon of n vertices with clipping lines. */
void buff_hollow_poly(buffer_rec *buff, int n, int *x, int *y,UBYTE col )
{
   int i;
   
   /* draw from vertex to vertex */
   for (i=1;i<n;i++){
        buff_draw_line(buff, x[i], y[i],x[i-1],y[i-1], col);
   }
   
   /* draw final line */
   buff_draw_line(buff, x[0], y[0],x[n-1],y[n-1], col);

}

