/* 
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */
#include <jlib.h>

/* Debugging statements are left out of point primitives as they can be 
   called thousands of times in a program.
 */

/*+------------------------------------------------------------------------+ */
/*|plot a dot at (x, y) with color c with clipping in a buffer             | */
/*+------------------------------------------------------------------------+ */

JINLINE void buff_draw_point (buffer_rec * buff, USHORT x, USHORT y, UBYTE c)
{
   UBYTE *addr = B_BUFF_PTR (buff);
   unsigned int xsize = B_X_SIZE (buff);

   if ((x > xsize) || (y > B_Y_SIZE (buff))) {
      return;
   }

   xsize *= y;
   xsize += x;
   addr += xsize;
   *addr = c;
}


/*+------------------------------------------------------------------------+ */
/*|plot a dot at (x, y) with color c without clipping in a buffer          | */
/*+------------------------------------------------------------------------+ */

JINLINE void buff_draw_pointNC (buffer_rec * buff, USHORT x, USHORT y, UBYTE c)
{
   UBYTE *addr = B_BUFF_PTR (buff);
   unsigned int xsize = B_X_SIZE (buff);

   xsize *= y;
   xsize += x;
   addr += xsize;
   *addr = c;
}


/*+------------------------------------------------------------------------+ */
/*|get a dot at (x, y) with clipping from a buffer                         | */
/*+------------------------------------------------------------------------+ */

JINLINE UBYTE buff_get_point (buffer_rec * buff, USHORT x, USHORT y)
{
   UBYTE *addr = B_BUFF_PTR (buff);
   unsigned int xsize = B_X_SIZE (buff);

   if ((x > xsize) || (y > B_Y_SIZE (buff))) {
      return 0;
   }

   xsize *= y;
   xsize += x;
   addr += xsize;
   return (*addr);
}


/*+------------------------------------------------------------------------+ */
/*|get a dot at (x, y) without clipping from a buffer                      | */
/*+------------------------------------------------------------------------+ */

JINLINE UBYTE buff_get_pointNC (buffer_rec * buff, USHORT x, USHORT y)
{
   UBYTE *addr = B_BUFF_PTR (buff);
   unsigned int xsize = B_X_SIZE (buff);

   xsize *= y;
   xsize += x;
   addr += xsize;
   return (*addr);
}
