
/*
   ** Copyright (C) 1995  Jonathan Paul Griffiths.  All rights reserved.
   **
   ** You may do anything with this code you wish EXCEPT sell it. You may sell
   ** any software you create using this code,  but you MUST NOT charge for
   ** the code itself.  See the file "readme.jon" for detailed terms. 
 */
#include <string.h>
#include <jlib.h>

/* how much memory a character uses */
#define USED_SPACE (CHAR_WIDTH('a')*CHAR_HEIGHT('a'))

/*+-------------------------------------------------------------------------+ */
/*|Draw a character in a buffer at x,y in color c without clipping          | */
/*+-------------------------------------------------------------------------+ */

JINLINE void buff_draw_charNC (buffer_rec * buff, UBYTE letter, USHORT x, USHORT y, UBYTE colour)
{
   UBYTE *buffer = B_BUFF_PTR (buff);
   UBYTE width, height, a, b;
   USHORT i;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_charNC().\n");

   if (!HAS_FONT (letter)) {
      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "character %d is non printable.\n", letter);
      JLIB_PRINT_MESSAGE_STRING;

      return;
   }

   buffer += (unsigned int)(B_X_SIZE (buff) * y) + x;

   width = CHAR_WIDTH (letter);
   height = CHAR_HEIGHT (letter);

   i = ((letter - 32) * USED_SPACE);	/* set i to point to letter data */

   for (a = 0; a < height; a++) {
      for (b = 0; b < width; b++) {
	 if (__font_data[i++]) {
	    *buffer = colour;
	 }
	 ++buffer;
      }
      buffer += B_X_SIZE (buff) - width;
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_charNC().\n");
}

/*+-------------------------------------------------------------------------+ */
/*|Draw a character in a buffer at x,y in color c with clipping             | */
/*+-------------------------------------------------------------------------+ */

JINLINE void buff_draw_char (buffer_rec * buff, UBYTE letter, USHORT x, USHORT y, UBYTE colour)
{
   UBYTE width, height, a, b;
   USHORT i;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_char().\n");

   if (!HAS_FONT (letter)) {
      JLIB_SPRINTF (JLIB_MESSAGE_STRING, "character %d is non printable.\n", letter);
      JLIB_PRINT_MESSAGE_STRING;

      return;
   }

   /* trivially reject any letter that begins off the buffer */
   if (x > B_X_SIZE (buff)) {
      return;
   }
   if (y > B_Y_SIZE (buff)) {
      return;
   }

   width = CHAR_WIDTH (letter);
   height = CHAR_HEIGHT (letter);

   i = ((letter - 32) * USED_SPACE);	/* set i to point to letter data */

   /* use clipping point function to draw char */
   for (a = 0; a < height; a++) {
      for (b = 0; b < width; b++) {
	 if (__font_data[i++]) {
	    buff_draw_point (buff, x + b, y + a, colour);
	 }
      }
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_char().\n");
}


/*+--------------------------------------------------------------------------+ */
/*|Draw a string of characters on the buff at x,y in color c without clipping| */
/*+--------------------------------------------------------------------------+ */

void buff_draw_stringNC (buffer_rec * buff, char *string, USHORT x, USHORT y, UBYTE colour)
{
   UBYTE i;
   int end;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_stringNC().\n");

   for (i = 0, end = strlen (string); i != end; i++) {
      if (HAS_FONT (string[i])) {
	 buff_draw_charNC (buff, string[i], x, y, colour);
	 x += CHAR_WIDTH (string[i]);
      }
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_stringNC().\n");
}


/*+--------------------------------------------------------------------------+ */
/*|Draw a string of characters on the buff at x,y in color c with clipping.  | */
/*+--------------------------------------------------------------------------+ */

void buff_draw_string (buffer_rec * buff, char *string, USHORT x, USHORT y, UBYTE colour)
{
   UBYTE i;
   int end;

   JLIB_PRINT_DEBUG_INFO ("Entering buff_draw_string().\n");

   /* trivially reject any string that begins off the buffer */
   if (x > B_X_SIZE (buff)) {
      return;
   }
   if (y > B_Y_SIZE (buff)) {
      return;
   }

   /* draw string using clipping draw_char function */
   for (i = 0, end = strlen (string); i != end; i++) {
      if (HAS_FONT (string[i])) {
	 buff_draw_char (buff, string[i], x, y, colour);
	 x += CHAR_WIDTH (string[i]);
      }
   }

   JLIB_PRINT_DEBUG_INFO ("Leaving buff_draw_string().\n");
}
